/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoEventLogDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoEventLog;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoEventType;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoUserType;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoEventLogService;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TxVZhiBoEventLogServiceImpl
implements TxVZhiBoEventLogService {
    @Autowired
    private TxVZhiBoEventLogDao txVZhiBoEventLogDao;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Override
    public void saveEvent(int lessonId, int uId, TxVZhiBoUserType userType, TxVZhiBoEventType eventType) {
        TxVZhiBoEventLog eventLog = new TxVZhiBoEventLog();
        eventLog.setCreateTime(new Date());
        eventLog.setEvent(Integer.valueOf(eventType.getCode()));
        eventLog.setLessonId(Integer.valueOf(lessonId));
        eventLog.setUId(Integer.valueOf(uId));
        eventLog.setUType(Integer.valueOf(userType.getCode()));
        this.txVZhiBoEventLogDao.save((Object)eventLog, new String[0]);
    }

    @Override
    public void saveEvents(List<TxVZhiBoEventLog> eventLogs) {
        if (CollectionUtils.isEmpty(eventLogs)) {
            return;
        }
        this.txVZhiBoEventLogDao.saveAll(eventLogs, false, new String[0]);
    }

    @Override
    public void markEvent(Integer uid, Integer uType, Integer lessonId, String openId) {
        StringBuilder sb = new StringBuilder();
        sb.append(RedisKeyEnums.VZB.EVENT_KEY.getRedisKey()).append(lessonId).append("_").append(uid).append("_").append(uType).append("_").append(openId);
        String key = sb.toString();
        this.redisTemplate.opsForZSet().add((Object)RedisKeyEnums.VZB.EVENT_KEY.getRedisKey(), (Object)key, new Double(System.currentTimeMillis()).doubleValue());
    }
}

