/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoBlackboardDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoBlackboard;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoBlackboardService;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoBlackboardDto;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxVZhiBoBlackboardServiceImpl
implements TxVZhiBoBlackboardService {
    @Autowired
    private TxVZhiBoBlackboardDao txVZhiBoBlackboardDao;

    @Override
    public void saveBlackboard(List<TxVZhiBoBlackboardDto> pics, Integer orgId, Integer lessonId) {
        TxVZhiBoBlackboard blackboard = this.txVZhiBoBlackboardDao.getByLessonId(lessonId, orgId);
        if (blackboard == null) {
            blackboard = new TxVZhiBoBlackboard();
            blackboard.setLessonId(lessonId);
            blackboard.setOrgId(orgId);
            blackboard.setCreateTime(new Date());
        }
        String picContent = "";
        if (!CollectionUtils.isEmpty(pics)) {
            picContent = JacksonUtil.obj2Str(pics);
        }
        blackboard.setPicContent(picContent);
        blackboard.setUpdateTime(new Date());
        this.txVZhiBoBlackboardDao.saveOrUpdate((Object)blackboard, new String[0]);
    }

    @Override
    public List<TxVZhiBoBlackboardDto> getPics(Integer lessonId, Integer orgId) throws Exception {
        TxVZhiBoBlackboard blackboard = this.txVZhiBoBlackboardDao.getByLessonId(lessonId, orgId);
        if (blackboard == null) {
            return Collections.EMPTY_LIST;
        }
        String picContent = blackboard.getPicContent();
        if (StringUtils.isBlank((CharSequence)picContent)) {
            return Lists.newArrayList();
        }
        List data = JacksonUtil.str2List((String)picContent, TxVZhiBoBlackboardDto.class);
        return data;
    }
}

