/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.vo;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;

import java.util.Date;

import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoLessonListTypeEnums;
import lombok.Data;

/**
 * @title TxVZhiBoLessonListVO
 * @desc 直播课列表VO
 * @author fubaokui
 * @date 2016年11月28日
 * @version 1.0
 */
@Data
public class TxVZhiBoLessonListVO {

    private long roomId; // 直播间id

    private long id; // 直播课id

    private String name; // 直播课名称

    private String teacherName; // 老师名称

    private String detailUrl; // 介绍页url

    private String liveUrl; // 直播url

    private Long startTime; // 直播开始时间

    private int studentCount = 0; // 学生人数

    private String avatar; // 直播课logo url

    private Integer orgId;

    private Integer orgNumber;

    private Date createTime;

    private int status = TxVZhiBoLessonStatusEnums.LIVE.getCode(); // 直播状态，0-已结束，1-直播中

    private Integer hidden; // 是否隐藏,1-隐藏,0-显示.

    private Integer ownType = TxVZhiBoLessonListTypeEnums.OTHERS.getCode();
    
}
