package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.vzhibo.constant.TxVZhiBoInviteeInviterType;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoInviteeDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoRoomDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoInvitee;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoRoom;
import com.baijia.tianxiao.dal.wechat.constant.QRCodeSceneBizType;
import com.baijia.tianxiao.dal.wechat.constant.WechatAppVerifyType;
import com.baijia.tianxiao.dal.wechat.dao.QRCodeSceneDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.QRCodeScene;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.redis.lock.RedisDistributeLock;
import com.baijia.tianxiao.redis.lock.RedisDistributeLockImpl;
import com.baijia.tianxiao.sal.common.dto.InviteCardTaskDto;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.vzhibo.constant.InviteCardStatus;
import com.baijia.tianxiao.sal.vzhibo.constant.OwnerTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.service.AudienceService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoInviteCardService;
import com.baijia.tianxiao.sal.vzhibo.vo.AudienceDto;
import com.baijia.tianxiao.sal.vzhibo.vo.InviteCardInfoDto;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoInviteCardVO;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.api.MessagePushService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.enums.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.TempMediaApiDto;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import sun.misc.BASE64Encoder;

import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import javax.annotation.PostConstruct;

import lombok.NonNull;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 06/06/2017 5:42 PM
 */
@Slf4j
@Service
public class TxVZhiBoInviteCardServiceImpl implements TxVZhiBoInviteCardService {

    @Autowired
    private AudienceService audienceService;

    @Autowired
    private TxVZhiBoInviteeDao txVZhiBoInviteeDao;

    @Autowired
    private FansService fansService;

    @Autowired
    private OrgInfoService orgInfoService;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;

    @Autowired
    private TxVZhiBoLessonDao txVZhiBoLessonDao;

    @Autowired
    private TxVZhiBoRoomDao txVZhiBoRoomDao;

    @Autowired
    private QRCodeSceneDao qrCodeSceneDao;

    @Autowired
    private AuthorizerInfoService authorizerInfoService;

    @Autowired
    private AuthorizationInfoService authorizationInfoService;

    @Autowired
    private TxVZhiBoLessonStudentDao txVZhiBoLessonStudentDao;

    @Autowired
    private MessagePushService messagePushService;

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    private RedisDistributeLock distributeLock;

    @PostConstruct
    public void postConstruct() {
        this.distributeLock = new RedisDistributeLockImpl(redisTemplate);
    }

    private QRCodeScene generateCardWeChatQrUrl(String openId, @NonNull Integer lessonId) {
        TxVZhiBoLesson txVZhiBoLesson = txVZhiBoLessonDao.getById(lessonId);
        AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(txVZhiBoLesson.getOrgId());
        AuthorizerInfo authorizerInfo = authorizerInfoService.getByOrgId(txVZhiBoLesson.getOrgId());
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_WEBAUTH);

        TxVZhiBoInviteeInviterType inviterType = null;
        Integer roleId = 0;
        String roleStr = "";
        if (StringUtils.isBlank(openId)) {
            if (OwnerTypeEnums.MAIN.getCode() == txVZhiBoLesson.getOwnerType()) {
                inviterType = TxVZhiBoInviteeInviterType.MASTER;
                roleId = txVZhiBoLesson.getOrgId();
            } else {
                inviterType = TxVZhiBoInviteeInviterType.CASCADE;
                roleId = txVZhiBoLesson.getOwnerId();
            }
        } else {
            inviterType = TxVZhiBoInviteeInviterType.AUDIENCE;
            roleStr = openId;
        }
        QRCodeScene scene = qrCodeSceneDao.getByAllParam(QRCodeSceneBizType.VZHIBO_INVITECARD.getCode(), lessonId,
            inviterType.getCode(), roleId, roleStr);
        if (null == scene) {
            scene = new QRCodeScene();
            scene.setBizType(QRCodeSceneBizType.VZHIBO_INVITECARD.getCode());
            scene.setBizId(lessonId);
            scene.setRoleType(inviterType.getCode());
            scene.setRoleId(roleId);
            scene.setRoleStr(roleStr);
            scene.setCreateTime(new Date());
            scene.setUpdateTime(scene.getCreateTime());
            qrCodeSceneDao.save(scene);
        }

        // 获取二维码连接
        QRCodeDto qrCodeDto = null;
        try {
            qrCodeDto = WechatQRCodeLinkHelper.getQRCodeDtoForOneMonth(authorizationInfo.getAuthorizerAccessToken(),
                scene.getId());
        } catch (WechatException e) {
            // 权限不足 就更新数据库认证字段
            if (e.getErrorCode().equals(SalWechatErrorCode.WECHAT_PERMISSION_DENIED)
                || e.getErrorCode().equals(SalWechatErrorCode.WECHAT_AUTHORIZATION_DENIED)) {
                log.error("vzhibo generate invite card qrCode error:{}, update authorizerInfo:{} into NOT_VERIFY", e,
                    authorizerInfo);
                authorizerInfo.setVerifyType(WechatAppVerifyType.NOT_VERIFY.getValue());
                authorizerInfoService.update(authorizerInfo);
            }
            throw e;
        }
        String base64Img = null;
        try {
            byte[] data = WechatQRCodeLinkHelper.downloadQRCodeImage(qrCodeDto.getTicket());
            BASE64Encoder encoder = new BASE64Encoder();
            base64Img = encoder.encode(data);
        } catch (Exception e) {
            log.error("get wechat qr code img error! e:{}", e);
        }
        scene.setBase64Img("data:image/jpg;base64," + base64Img);
        return scene;
    }

    @Override
    public TxVZhiBoInviteCardVO createNewInviteCard(String openId, @NonNull Integer lessonId) {
        QRCodeScene qrCodeScene = generateCardWeChatQrUrl(openId, lessonId);
        TxVZhiBoLesson txVZhiBoLesson = txVZhiBoLessonDao.getById(lessonId);
        TxVZhiBoRoom txVZhiBoRoom = txVZhiBoRoomDao.getById(txVZhiBoLesson.getRoomId());
        TxVZhiBoInviteCardVO txVZhiBoInviteCardVO = new TxVZhiBoInviteCardVO();
        txVZhiBoInviteCardVO.setQrCodeScene(qrCodeScene);
        txVZhiBoInviteCardVO.setDate(txVZhiBoLesson.getStartTime());
        txVZhiBoInviteCardVO.setCardTitle(txVZhiBoLesson.getName());
        txVZhiBoInviteCardVO.setBase64Img(qrCodeScene.getBase64Img());
        if (StringUtils.isNotEmpty(txVZhiBoRoom.getName())) {
            txVZhiBoInviteCardVO.setLocation(txVZhiBoRoom.getName());
        } else {
            OrgInfoSimpleDto orgInfo = orgInfoService.getMOrgInfo(txVZhiBoLesson.getOrgId().longValue());
            txVZhiBoInviteCardVO.setLocation(orgInfo.getShortName());
        }
        if (StringUtils.isBlank(openId)) {
            if (txVZhiBoLesson.getOwnerType() == OwnerTypeEnums.CASCADE_ACCOUNT.getCode()) {
                TXCascadeAccount cascadeAccount = this.txCascadeAccountDao.getById(txVZhiBoLesson.getOwnerId());
                TXCascadeCredential txCascadeCredential =
                    this.txCascadeCredentialDao.getById(cascadeAccount.getCredentialId());
                if (StringUtils.isNotBlank(txCascadeCredential.getAvatar())) {
                    txVZhiBoInviteCardVO.setInviterAvatar(txCascadeCredential.getAvatar());
                } else {
                    txVZhiBoInviteCardVO.setInviterAvatar(AvatarConstants.STUFF_AVATAR_URL);
                }
                txVZhiBoInviteCardVO.setInviterName(txCascadeCredential.getName());
            } else if (txVZhiBoLesson.getOwnerType() == OwnerTypeEnums.MAIN.getCode()) {
                OrgInfoSimpleDto infoSimpleDto = orgInfoService.getMOrgInfo(txVZhiBoLesson.getOrgId().longValue());
                txVZhiBoInviteCardVO.setInviterAvatar(infoSimpleDto.getLogo());
                txVZhiBoInviteCardVO.setInviterName(infoSimpleDto.getContacts());
            }
        } else {
            Fans fans = fansService.getFans(openId);
            if (fans != null) {
                if (StringUtils.isBlank(fans.getHeadImgUrl())) {
                    // FIXME nullable
                    txVZhiBoInviteCardVO.setInviterAvatar(fans.getHeadImgUrl());
                } else {
                    txVZhiBoInviteCardVO.setInviterAvatar(fans.getHeadImgUrl());
                }
                txVZhiBoInviteCardVO.setInviterName(fans.getNick());

            }
        }
        return txVZhiBoInviteCardVO;
    }

    @Override
    public InviteCardInfoDto getInviteCardInfoDto(String openId, Integer lessonId) {
        TxVZhiBoLesson txVZhiBoLesson = txVZhiBoLessonDao.getById(lessonId);
        InviteCardInfoDto inviteCardInfoDto = new InviteCardInfoDto();
        try {
            AuthorizationInfo authorizationInfo =
                authorizationInfoService.refreshAccessToken(txVZhiBoLesson.getOrgId());
            AuthorizerInfo authorizerInfo = authorizerInfoService.getByOrgId(txVZhiBoLesson.getOrgId());
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_WEBAUTH);
        } catch (Exception e) {
            log.info("lesson:{} find no auth wechat. no invite card! e:{}", txVZhiBoLesson, e);
            inviteCardInfoDto.setCardStatus(InviteCardStatus.WECHAT_NO_AUTH.getCode());
            inviteCardInfoDto.setCardStatusStr(InviteCardStatus.WECHAT_NO_AUTH.getDesc());
            return inviteCardInfoDto;
        }

        InviteCardInfoDto.CardInfo cardInfo = new InviteCardInfoDto.CardInfo();
        cardInfo.setCardPageUrl(PropertiesReader.getValue("tianxiao", "vzhibo.url")
            + String.format("/invite/myCard.do?lessonId=%s", lessonId));
        TxVZhiBoInvitee maxNumInviter = txVZhiBoInviteeDao.getMaxInviteNumInviter(lessonId);
        log.debug("maxNumInviter:{}", maxNumInviter);
        if (null == maxNumInviter) {
            cardInfo.setInviteNum(0);
        } else {
            cardInfo.setInviteNum(maxNumInviter.getCount());
            if (TxVZhiBoInviteeInviterType.MASTER.getCode() == maxNumInviter.getInviterType()) {
                OrgInfoSimpleDto orgInfo = orgInfoService.getMOrgInfo(maxNumInviter.getInviterId().longValue());
                cardInfo.setInviterName(orgInfo.getContacts());
            } else if (TxVZhiBoInviteeInviterType.CASCADE.getCode() == maxNumInviter.getInviterType()) {
                TXCascadeAccount cascadeAccount =
                    txCascadeAccountDao.getById(maxNumInviter.getInviterId(), "credentialId");
                TXCascadeCredential cascadeCredential =
                    txCascadeCredentialDao.getById(cascadeAccount.getCredentialId(), "name");
                cardInfo.setInviterName(cascadeCredential.getName());
            } else {
                AudienceDto audienceDto = audienceService.getAudienceDetail(maxNumInviter.getInviterOpenId(),
                    txVZhiBoLesson.getOrgNumber(), lessonId);
                cardInfo.setInviterName(audienceDto.getName());
            }
        }
        inviteCardInfoDto.setCardInfo(cardInfo);

        if (StringUtils.isBlank(openId)) {
            if (StringUtils.isNotBlank(txVZhiBoLesson.getInvitePicUrl())
                && txVZhiBoLesson.getInvitePicReady() == Flag.TRUE.getInt()) {
                return inviteCardInfoDto;
            } else if (StringUtils.isBlank(txVZhiBoLesson.getInvitePicUrl())
                && DateUtil.getMinuteDiff(txVZhiBoLesson.getCreateTime(), new Date()) > 5) {
                // 历史数据， 访问时生成
                RedisDistributeLock.LockObject lockObject = this.distributeLock.lockFastFail(
                    RedisKeyEnums.VZB.VZHIBO_REGENERATE_INVITE_CARD_LOCK.getRedisKey() + "_" + lessonId.toString(),
                    5 * 60 * 1000);
                if (null != lockObject) {
                    InviteCardTaskDto taskDto = new InviteCardTaskDto(lessonId, openId, false);
                    redisTemplate.opsForList().rightPush(RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(),
                        taskDto.toJson());
                }
            }
        } else {
            TxVZhiBoLessonStudent txVZhiBoLessonStudent = txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            if (null != txVZhiBoLessonStudent && StringUtils.isNotBlank(txVZhiBoLessonStudent.getInvitePicUrl())
                && txVZhiBoLessonStudent.getInvitePicReady() == Flag.TRUE.getInt()) {
                return inviteCardInfoDto;
            } else if (null != txVZhiBoLessonStudent && StringUtils.isBlank(txVZhiBoLessonStudent.getInvitePicUrl())
                && DateUtil.getMinuteDiff(txVZhiBoLessonStudent.getCreateTime(), new Date()) > 2 * 60) {
                // 历史数据， 访问时生成
                RedisDistributeLock.LockObject lockObject =
                    this.distributeLock.lockFastFail(RedisKeyEnums.VZB.VZHIBO_REGENERATE_INVITE_CARD_LOCK.getRedisKey()
                        + "_" + lessonId.toString() + "_" + openId, 5 * 60 * 1000);
                if (null != lockObject) {
                    InviteCardTaskDto taskDto = new InviteCardTaskDto(lessonId, openId, false);
                    redisTemplate.opsForList().rightPush(RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(),
                        taskDto.toJson());
                }
            }
        }

        inviteCardInfoDto.setCardStatus(InviteCardStatus.CARD_GENERATING.getCode());
        inviteCardInfoDto.setCardStatusStr(InviteCardStatus.CARD_GENERATING.getDesc());
        return inviteCardInfoDto;
    }

    @Override
    public boolean canGenerateInviteCard(Integer lessonId) {
        TxVZhiBoLesson txVZhiBoLesson = txVZhiBoLessonDao.getById(lessonId);
        try {
            AuthorizationInfo authorizationInfo =
                authorizationInfoService.refreshAccessToken(txVZhiBoLesson.getOrgId());
            AuthorizerInfo authorizerInfo = authorizerInfoService.getByOrgId(txVZhiBoLesson.getOrgId());
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_WEBAUTH);
            return true;
        } catch (Exception e) {
            log.info("lesson:{} find no auth wechat. no invite card! e:{}", txVZhiBoLesson, e);
            return false;
        }
    }

    @Override
    public void updateInviteCardUrl(String openId, Integer lessonId, String url, Boolean sendWechatMsg) {
        TxVZhiBoLesson txVZhiBoLesson = txVZhiBoLessonDao.getById(lessonId);
        if (StringUtils.isEmpty(openId)) {
            txVZhiBoLesson.setInvitePicUrl(url);
            txVZhiBoLesson.setInvitePicReady(Flag.TRUE.getInt());
            txVZhiBoLessonDao.update(txVZhiBoLesson, "invitePicUrl", "invitePicReady");
        } else {
            TxVZhiBoLessonStudent txVZhiBoLessonStudent = txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            if (null != txVZhiBoLessonStudent) {
                txVZhiBoLessonStudent.setInvitePicUrl(url);
                txVZhiBoLessonStudent.setInvitePicReady(Flag.TRUE.getInt());
                txVZhiBoLessonStudentDao.update(txVZhiBoLessonStudent, "invitePicUrl", "invitePicReady");
            }

            if (null != sendWechatMsg && true == sendWechatMsg) {
                sendWechatPic(txVZhiBoLesson.getOrgId(), openId, url);
            }
        }
    }

    @Override
    public void reGenerateInviteCard(String openId, Integer lessonId) {
        TxVZhiBoLesson txVZhiBoLesson = txVZhiBoLessonDao.getById(lessonId);
        AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(txVZhiBoLesson.getOrgId());
        AuthorizerInfo authorizerInfo = authorizerInfoService.getByOrgId(txVZhiBoLesson.getOrgId());
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_WEBAUTH);

        RedisDistributeLock.LockObject lockObject =
            this.distributeLock.lockFastFail(RedisKeyEnums.VZB.VZHIBO_REGENERATE_INVITE_CARD_LOCK.getRedisKey() + "_"
                + lessonId.toString() + "_" + openId, 5 * 60 * 1000);
        if (null == lockObject) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "如需重新生成请5分钟后再试");
        }

        InviteCardTaskDto taskDto = new InviteCardTaskDto();
        if (StringUtils.isBlank(openId)) {
            if (txVZhiBoLesson.getInvitePicReady() == Flag.FALSE.getInt()) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "邀请卡生成中!");
            }
            taskDto.setLessonId(lessonId);
            redisTemplate.opsForList().rightPush(RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(),
                taskDto.toJson());
            txVZhiBoLesson.setInvitePicReady(Flag.FALSE.getInt());
            txVZhiBoLessonDao.update(txVZhiBoLesson, "invitePicReady");
        } else {
            TxVZhiBoLessonStudent txVZhiBoLessonStudent = txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            if (txVZhiBoLessonStudent.getInvitePicReady() == Flag.FALSE.getInt()) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "邀请卡生成中!");
            }
            taskDto.setOpenId(openId);
            taskDto.setLessonId(lessonId);
            redisTemplate.opsForList().rightPush(RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(),
                taskDto.toJson());
            txVZhiBoLessonStudent.setInvitePicReady(Flag.FALSE.getInt());
            txVZhiBoLessonStudentDao.update(txVZhiBoLessonStudent, "invitePicReady");
        }
    }

    @Override
    @SneakyThrows
    public String getInviteCardPicUrl(String openId, Integer lessonId) {
        if (StringUtils.isNotBlank(openId)) {
            TxVZhiBoLessonStudent txVZhiBoLessonStudent = txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            if (null == txVZhiBoLessonStudent) {
                // 主从延迟 咋搞？
                TimeUnit.SECONDS.sleep(3L);
                txVZhiBoLessonStudent = txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            }
            return txVZhiBoLessonStudent.getInvitePicUrl();
        } else {
            TxVZhiBoLesson txVZhiBoLesson = txVZhiBoLessonDao.getById(lessonId);
            return txVZhiBoLesson.getInvitePicUrl();
        }
    }

    @Override
    public void sendWechatPic(Integer orgId, String openId, String picUrl) {
        File localFile = null;
        try {
            AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(orgId);
            String accessToken = authorizationInfo.getAuthorizerAccessToken();

            byte[] data = null;
            if (StringUtils.isNotBlank(picUrl)) {
                data = HttpClientUtils.download(picUrl);
                localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
            } else {
                log.info("error msg - url:{}", picUrl);
                return;
            }
            // 上传文件到微信
            TempMediaApiDto mediaApiDto = WechatMediaApiHelper.uploadTempMedia(accessToken, MediaType.IMAGE, localFile);
            // 发送微信消息
            CustomerServiceApiHelper.sendImageMsg(accessToken, openId, mediaApiDto.getMediaId());
        } catch (Exception e) {
            log.warn("send wechat msg error! openId:{}, e:{}", openId, e);
        } finally {
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
        }
    }

}
