/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Maps;

/**
 * @title JSSignUtil
 * @desc TODO 
 * @author he11o
 * @date 2016年6月8日
 * @version 1.0
 */
public class JSSignUtil {
     
    private static Logger logger = LoggerFactory.getLogger(JSSignUtil.class);
    
    public static Map<String, String> sign(String jsapi_ticket, String url) {
        Map<String, String> ret = Maps.newHashMap();
        String nonce_str = create_nonce_str();
        String timestamp = create_timestamp();
        StringBuffer str = new StringBuffer();
        //注意这里参数名必须全部小写，且必须有序
        str.append("jsapi_ticket=").append(jsapi_ticket)
            .append("&noncestr=").append(nonce_str)
            .append("&timestamp=").append(timestamp)
            .append("&url=").append(url);
        String signature;
        try {
            signature = getSignature(str.toString());
            ret.put("url", url);
            ret.put("jsapi_ticket", jsapi_ticket);
            ret.put("nonceStr", nonce_str);
            ret.put("timestamp", timestamp);
            ret.put("signature", signature);
        } catch (Exception e) {
            logger.error("签名失败", e);
        }
 
        return ret;
    }
    
    /**
     * 签名
     * @param signature
     * @param timestamp
     * @param nonce
     * @return
     */
    public static String getSignature(String sKey) throws Exception {
        String ciphertext = null;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] digest = md.digest(sKey.toString().getBytes());
        ciphertext = byteToStr(digest);
        return ciphertext.toLowerCase();
    }
 
    /** 
        * 将字节数组转换为十六进制字符串 
        *  
        * @param byteArray 
        * @return 
        */ 
   private static String byteToStr(byte[] byteArray) {  
           String strDigest = "";  
           for (int i = 0; i < byteArray.length; i++) {  
               strDigest += byteToHexStr(byteArray[i]);  
           }  
           return strDigest;  
       }  
     /** 
        * 将字节转换为十六进制字符串 
        *  
        * @param mByte 
        * @return 
        */ 
   private static String byteToHexStr(byte mByte) {  
           char[] Digit = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };  
           char[] tempArr = new char[2];  
           tempArr[0] = Digit[(mByte >>> 4) & 0X0F];  
           tempArr[1] = Digit[mByte & 0X0F];  
      
           String s = new String(tempArr);  
           return s;  
       }
    
    private static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }
 
    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000);
    }
     
    //获取当前系统时间 用来判断access_token是否过期
    public static String getCurrentTime(){
        Date dt=new Date();
        SimpleDateFormat sdf =new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(dt);
    }

    public static String signature(String jsapi_ticket, String nonce_str, long timestamp, String url) {
        /****
         * 对 jsapi_ticket、 timestamp 和 nonce 按字典排序 对所有待签名参数按照字段名的 ASCII
         * 码从小到大排序（字典序）后，使用 URL 键值对的格式（即key1=value1&key2=value2…）拼接成字符串
         * string1。这里需要注意的是所有参数名均为小写字符。 接下来对 string1 作 sha1 加密，字段名和字段值都采用原始值，不进行
         * URL 转义。即 signature=sha1(string1)。
         * **如果没有按照生成的key1=value&key2=value拼接的话会报错
         */
        String[] paramArr = new String[] { "jsapi_ticket=" + jsapi_ticket,
                "timestamp=" + timestamp, "noncestr=" + nonce_str, "url=" + url };
        Arrays.sort(paramArr);
        // 将排序后的结果拼接成一个字符串
        String content = paramArr[0].concat("&"+paramArr[1]).concat("&"+paramArr[2])
                .concat("&"+paramArr[3]);
        logger.debug("拼接之后的content为:"+content);
        String gensignature = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            // 对拼接后的字符串进行 sha1 加密
            byte[] digest = md.digest(content.toString().getBytes());
            gensignature = byteToStr(digest);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        logger.debug("gensignature={}",gensignature.toLowerCase());
        return gensignature.toLowerCase();// 返回signature
    }
}