/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.util;


import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

/**
 * @title EmojiUtil
 * @desc 转义微信html版emoji表情 
 * @author he11o
 * @date 2016年8月20日
 * @version 1.0
 */
@Slf4j
public class EmojiUtil {
    
    private static Pattern pattern = Pattern.compile("<span(\\s+class=.*?emoji\\s+emoji).*?span>");

    private static final String NUMBER_FLAG = "20e3";
    
    public static String processWecharEmoji(String content){
        List<String> emojiCodeList = Lists.newArrayList();
        
        Matcher matcher = pattern.matcher(content);
        if(!matcher.find()){
            return content;
        }
        do { 
            String emoji = matcher.group();
            int start = emoji.indexOf("emoji emoji");
            int end = emoji.lastIndexOf("\"");
            if(start > -1){
                String emojiCode = emoji.substring(start+11, end);
                emojiCodeList.add(emojiCode);
                content = matcher.replaceFirst("kbf");
                matcher = pattern.matcher(content);
            }
        }while (matcher.find());
        
        List<String> emojiList = Lists.newArrayListWithExpectedSize(emojiCodeList.size());
        for(String str: emojiCodeList){
            try{
                if(str.endsWith(NUMBER_FLAG)){
                    String[] element =  str.split(NUMBER_FLAG);
                    emojiList.add(new String(Character.toChars(Integer.parseInt(element[0], 16))) + new String(Character.toChars(Integer.parseInt(NUMBER_FLAG, 16))));
                }else{
                    emojiList.add(new String(Character.toChars(Integer.parseInt(str, 16))));
                }
            }catch(Exception e){
                log.debug("[processWecharEmoji]str:{}",str);
                log.debug("error in processWecharEmoji",e);
                continue;
            }
        }
        
        for(String emojiTemp : emojiList){
            content = content.replaceFirst("kbf", emojiTemp);
        }
        return content;
    }
    
    public static void main(String[] args) {
        System.out.println(processWecharEmoji("风帆<span class=\"emoji emoji2600\"></span>️<span class=\"emoji emoji1f604\"></span>️Summer的班级群_fJ9"));
        System.out.println(processWecharEmoji("幼儿笔试VIP<span class=\"emoji emoji3320e3\"></span>班"));
    }
    
}