/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.vzhibo.constant.MessageTypeEnums;
import com.baijia.tianxiao.dal.vzhibo.constant.TxVZhiBoLessonStudentStatus;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.dto.DBResultDto;
import com.baijia.tianxiao.sal.common.dto.InviteCardTaskDto;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonStudentService;
import com.baijia.tianxiao.sal.vzhibo.util.WebSocketUtil;
import com.baijia.tianxiao.sal.vzhibo.vo.WsBaseMessage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

/**
 * @title TxVZhiBoLessonStudentServiceImpl
 * @desc TODO
 * @author fubaokui
 * @date 2016年11月29日
 * @version 1.0
 */
@Slf4j
@Service
public class TxVZhiBoLessonStudentServiceImpl implements TxVZhiBoLessonStudentService {

    @Autowired
    TxVZhiBoLessonStudentDao txVZhiBoLessonStudentDao;

    @Autowired
    TxVZhiBoLessonService txVZhiBoLessonService;

    @Autowired
    private TxConsultUserDao consultUserDao;

    @Autowired
    private ConsulterAPIService consulterAPIService;

    @Autowired
    private FansDao fansDao;

    @Transactional
    public void changeStudentNoNeedPwd(@NonNull Integer roomId, @NonNull Integer lessonId, @NonNull String openId,
        int noNeedPwd) {
        TxVZhiBoLesson lesson = txVZhiBoLessonService.getById(lessonId);

        Fans fans = fansDao.getByOpenId(openId);
        if (fans == null) {
            try {
                TimeUnit.SECONDS.sleep(3L);
                fans = fansDao.getByOpenId(openId);
                if (fans == null) {
                    throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "部分信息加载超时，请刷新当前页面");
                }
            } catch (InterruptedException e) {
                log.error("wait fans data save to db error!", e);
            }
        }

        List<TxConsultUser> consultUsers = consultUserDao.lookByWeixinOpenId(lesson.getOrgId().longValue(), openId);
        if (CollectionUtils.isEmpty(consultUsers)) {
            TxConsultUser consult = new TxConsultUser();
            consult.setOrgId(lesson.getOrgId().longValue());
            consult.setWeixinOpenId(openId);
            consult.setWeixinNickName(fans.getNick());
            consult.setName(fans.getNick());
            consult.setConsultSource(MessageSource.VZHIBO.getValue());
            DBResultDto<TxConsultUser> resultDto = consulterAPIService.saveOrUpdateByWechatOpenId(consult);
            consult.setId(resultDto.getData().getId());
        }
        
        TxVZhiBoLessonStudent txVZhiBoLessonStudent = getByOpenId(openId, lessonId);
        if (txVZhiBoLessonStudent == null) {
            Long studentCount = getStudentCountbyLessonId(lessonId);
            txVZhiBoLessonStudent = new TxVZhiBoLessonStudent();
            txVZhiBoLessonStudent.setCreateTime(new Date());
            txVZhiBoLessonStudent.setLessonId(lessonId);
            txVZhiBoLessonStudent.setRoomId(roomId);
            txVZhiBoLessonStudent.setOpenId(openId);
            txVZhiBoLessonStudent.setUpdateTime(new Date());
            txVZhiBoLessonStudent.setStatus(TxVZhiBoLessonStudentStatus.NORMAL.getCode());
            txVZhiBoLessonStudent.setNoNeedPwd(noNeedPwd);
            txVZhiBoLessonStudent.setInvitePicUrl("");
            txVZhiBoLessonStudent.setInvitePicReady(Flag.FALSE.getInt());
            saveStudent(txVZhiBoLessonStudent);
            // 生成邀请卡
            InviteCardTaskDto taskDto = new InviteCardTaskDto(lessonId, openId, false);
            redisTemplate.opsForList().rightPush(RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(),
                taskDto.toJson());

            // 给WebSocket发通知
            Set<Object> deviceIds =
                redisTemplate.opsForHash().keys(RedisKeyEnums.VZB.LESSON_DEVICEID_PREFIX.getRedisKey() + lessonId);
            WsBaseMessage studentCountNotice = new WsBaseMessage();
            studentCountNotice.setMsgType(MessageTypeEnums.STUDENTCOUNT.getCode());
            studentCountNotice.setStudentCount(studentCount + 1);
            studentCountNotice.setLessonId(Integer.valueOf(lessonId));
            if (deviceIds != null && deviceIds.size() > 0) {
                WebSocketUtil.sendBatchWsMessage(studentCountNotice, deviceIds);
            }
        } else {
            txVZhiBoLessonStudent.setNoNeedPwd(noNeedPwd);
            saveStudent(txVZhiBoLessonStudent);
        }
    }

    /*
     * (non-Javadoc) “直播中”的直播间，学生人数从redis取，其他的从数据库取
     */
    @Override
    public Map<Integer, Integer> statStudentCountByRoomId(Integer roomId) {
        log.info("[statStudentCountByRoomId]roomId:{}", roomId);
        Map<Integer, Integer> resutlMap = Maps.newHashMap();
        if (roomId == null) {
            return resutlMap;
        }
        // 1.获取直播间下面所有直播课
        List<TxVZhiBoLesson> lessons = txVZhiBoLessonService.getByRoomId(roomId);
        if (CollectionUtils.isEmpty(lessons)) {
            return resutlMap;
        }
        // 2.获取直播中的直播课的学生人数
        List<Long> doneLessonIds = Lists.newArrayList();
        for (TxVZhiBoLesson boLesson : lessons) {
            if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == boLesson.getStatus()) {
                long count = getStudentCountbyLessonId(boLesson.getId().intValue());
                resutlMap.put(boLesson.getId().intValue(), (int) count);
            } else {
                doneLessonIds.add(boLesson.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(doneLessonIds)) {
            // 3.获取直播结束的直播课的学生人数
            Map<String, Object> countCondition = Maps.newHashMap();
            countCondition.put("lessonId", doneLessonIds);
            Map<Integer, Integer> resutlMapDone =
                txVZhiBoLessonStudentDao.groupCount(countCondition, "open_id", "lesson_id", true, Integer.class);
            if (resutlMap != null && resutlMapDone.size() > 0) {
                resutlMap.putAll(resutlMapDone);
            }
        }
        return resutlMap;
    }

    @Override
    public List<TxVZhiBoLessonStudent> getAllByLessonId(Integer lessonId) {
        return txVZhiBoLessonStudentDao.getAllByLessonId(lessonId);
    }

    @Override
    public TxVZhiBoLessonStudent getByOpenId(String openId, Integer lessonId) {
        TxVZhiBoLessonStudent data = txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
        return data;
    }

    @Override
    public void saveStudent(TxVZhiBoLessonStudent student) {
        txVZhiBoLessonStudentDao.saveOrUpdate(student);
    }

    @Autowired
    RedisTemplate<String, String> redisTemplate;

    @Override
    public long getStudentCountbyLessonId(Integer lessonId) {
        // 直播中的取redis，直播结束的取数据库
        if (lessonId == null) {
            return 0;
        }
        // 保证数据一致性 都走db
        // 直播中的，进入redis
        // if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == status) {
        // return redisTemplate.opsForSet().size(RedisKeyEnums.VZB.STUDENT_COUNT_PREFFIX.getRedisKey() + lessonId);
        // } else {
        // List<String> openIdList = txVZhiBoLessonStudentDao.queryStudentOpenIdByLessonId(lessonId);
        // if (CollectionUtils.isEmpty(openIdList)) {
        // return 0;
        // }
        // Set<String> openIdSet = new HashSet<String>();
        // openIdSet.addAll(openIdList);
        // return openIdSet.size();
        // }
        Integer count = txVZhiBoLessonStudentDao.queryStudentOpenIdCountByLessonId(lessonId);
        return null == count ? 0 : count;
    }

    @Override
    public long entryLesson(Integer lessonId, String openid) {
        if (lessonId == null) {
            return 0;
        }
        TxVZhiBoLesson lesson = txVZhiBoLessonService.getById(lessonId);
        if (lesson == null) {
            return 0;
        }
        // 直播中的，进入redis
        // if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == lesson.getStatus()) {
        // String redisKey = RedisKeyEnums.VZB.STUDENT_COUNT_PREFFIX.getRedisKey() + lessonId;
        // Set<String> openIds = redisTemplate.opsForSet().members(redisKey);
        // if (CollectionUtils.isEmpty(openIds)) {
        // log.debug("[entryLesson]key:{},members is empty!", redisKey);
        // // redis重启后数据可能丢失，需要从数据库同步一下数据
        // List<String> openIdList = txVZhiBoLessonStudentDao.queryStudentOpenIdByLessonId(lessonId);
        // if (CollectionUtils.isEmpty(openIdList)) {
        // return 0;
        // }
        // log.debug("[entryLesson]openIdList:{}", openIdList);
        // openIds.addAll(openIdList);
        // long result = redisTemplate.opsForSet().add(redisKey, openIds.toArray(new String[openIds.size()]));
        // log.debug("[entryLesson]result:{}", result);
        // // 当openIds为空时，为key设置过期时间
        // Calendar calendar = Calendar.getInstance();
        // if (lesson.getStartTime() != null) {
        // calendar.setTimeInMillis(lesson.getStartTime().getTime());
        // } else {
        // calendar.setTimeInMillis(System.currentTimeMillis());
        // }
        // calendar.add(Calendar.DAY_OF_MONTH, 7);
        // calendar.add(Calendar.HOUR_OF_DAY, 2);
        // boolean flag = redisTemplate.expireAt(redisKey, calendar.getTime());
        // log.debug("[entryLesson]expireAt:{}", flag);
        // }
        // if (StringUtils.isBlank(openid) || openIds.contains(openid)) {
        // return openIds.size();
        // } else {
        // redisTemplate.opsForSet().add(redisKey, openid);
        // openIds.add(openid);
        // return openIds.size();
        // }
        // } else {
        return getStudentCountbyLessonId(lessonId);
        // }
    }

    @Override
    public List<TxVZhiBoLessonStudent> getByLessonId(Integer lessonId, Integer lastId, Integer pageSize) {
        return txVZhiBoLessonStudentDao.getByLessonId(lessonId, lastId, pageSize);
    }

    @Override
    public List<TxVZhiBoLessonStudent> listLatestByLessonId(Integer lessonId, Integer pageSize) {
        return txVZhiBoLessonStudentDao.listLatestByLessonId(lessonId, pageSize);
    }

    @Override
    public boolean canSpeakCheck(Integer lessonId, String openid) {
        TxVZhiBoLessonStudent txVZhiBoLessonStudent = this.getByOpenId(openid, lessonId);
        if (null == txVZhiBoLessonStudent
            || txVZhiBoLessonStudent.getStatus() == TxVZhiBoLessonStudentStatus.NO_SPEAK.getCode()) {
            return false;
        } else {
            return true;
        }
    }

}
