package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoBlackboardDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoBlackboard;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoBlackboardService;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoBlackboardDto;
import com.baijia.tianxiao.util.json.JacksonUtil;

import com.google.common.collect.Lists;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Date;
import java.util.List;

@Service
public class TxVZhiBoBlackboardServiceImpl implements TxVZhiBoBlackboardService {

    @Autowired
    private TxVZhiBoBlackboardDao txVZhiBoBlackboardDao;

    @Override
    // FIXME app调用save方法使用不当导致这里有主从延迟问题，导致小黑板取数据有问题。加了个lesson_id唯一索引。问题待解决 by hongyan
    public void saveBlackboard(List<TxVZhiBoBlackboardDto> pics, Integer orgId, Integer lessonId) {
        TxVZhiBoBlackboard blackboard = txVZhiBoBlackboardDao.getByLessonId(lessonId, orgId);
        if (blackboard == null) {
            blackboard = new TxVZhiBoBlackboard();
            blackboard.setLessonId(lessonId);
            blackboard.setOrgId(orgId);
            blackboard.setCreateTime(new Date());
        }
        String picContent = "";
        if (!CollectionUtils.isEmpty(pics)) {
            picContent = JacksonUtil.obj2Str(pics);
        }
        blackboard.setPicContent(picContent);
        blackboard.setUpdateTime(new Date());
        txVZhiBoBlackboardDao.saveOrUpdate(blackboard);
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<TxVZhiBoBlackboardDto> getPics(Integer lessonId, Integer orgId) throws Exception {
        TxVZhiBoBlackboard blackboard = txVZhiBoBlackboardDao.getByLessonId(lessonId, orgId);
        if (blackboard == null) {
            return Collections.EMPTY_LIST;
        }
        String picContent = blackboard.getPicContent();
        if (StringUtils.isBlank(picContent)) {
            return Lists.newArrayList();
        }
        List<TxVZhiBoBlackboardDto> data = JacksonUtil.str2List(picContent, TxVZhiBoBlackboardDto.class);
        return data;
    }
}
