/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.service;

import java.util.Map;

import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoRoom;
import com.baijia.tianxiao.sal.vzhibo.constant.OrgFieldTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.vo.FieldUpdateVO;
import com.baijia.tianxiao.sal.vzhibo.vo.ShareDataVO;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoRoomBaseVO;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoRoomDetailVO;

/**
 * @title TxVZhiBoRoomService
 * @desc 直播间Service 
 * @author he11o
 * @date 2016年11月26日
 * @version 1.0
 */
public interface TxVZhiBoRoomService {

    /**
     * 根据机构number获取直播间详情
     * @param authToken 
     * @param orgNumber
     * @return
     */
    TxVZhiBoRoomDetailVO detail(int orgId, OrgFieldTypeEnums fieldTypeEnums, String authToken);

    /**
     * 按字段更新直播间
     * @param orgId
     * @param field
     * @param value
     * @return
     */
    int update(Integer orgId, FieldUpdateVO updateVO);

    /**
     * 按字段获取直播间基本信息
     * @param fieldValue
     * @param fieldType
     * @return
     */
    TxVZhiBoRoomBaseVO getBaseInfo(int fieldValue, OrgFieldTypeEnums fieldType);

    /**
     * 开启直播间，返回直播间id;还没有直播间时创建一个直播间
     * map：
     *  roomId
     *  welcomeUrl
     *  roomUrl
     * @return
     */
    Map<String, Object> create(Integer orgId);

    /**
     * 获取直播间分享数据
     * @param id
     * @return
     */
    ShareDataVO getShareData(TxVZhiBoRoomBaseVO baseVO);
    
    /**
     * 获取直播间分享数据
     * @param roomId
     * @return
     */
    ShareDataVO getShareData(int roomId);

    /**
     * 通过直播间id获取直播间信息
     * @param roomId
     * @return
     */
    TxVZhiBoRoom getById(Integer roomId);

}
