/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.service;

import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;

/**
 * 
 * @title TxVZhiBoLessonStudentService
 * @desc 直播课-学生映射关系service 
 * @author fubaokui
 * @date 2016年11月29日
 * @version 1.0
 */
public interface TxVZhiBoLessonStudentService {
    
    void changeStudentNoNeedPwd(Integer roomId, Integer lessonId, String openId, int noNeedPwd);

    /**
     * 统计直播间中每个直播课学生的认识
     * @param roomId 直播间id
     * @return map{key:lesson_id,value:count}
     */
    Map<Integer,Integer> statStudentCountByRoomId(Integer roomId);
    
    public List<TxVZhiBoLessonStudent> getAllByLessonId(Integer lessonId);
    
    public TxVZhiBoLessonStudent getByOpenId(String openId, Integer lessonId);
    
    public void saveStudent(TxVZhiBoLessonStudent student);
    /**
     * 获取学生人数
     * @param lessonId
     * @return
     */
    long getStudentCountbyLessonId(Integer lessonId);
    
    public List<TxVZhiBoLessonStudent> getByLessonId(Integer lessonId, Integer lastId, Integer pageSize);

    List<TxVZhiBoLessonStudent> listLatestByLessonId(Integer lessonId, Integer pageSize);

    /**
     * 学生进入直播间,返回直播间人数
     * @param lessonId
     * @param openid
     * @return 
     */
    long entryLesson(Integer lessonId, String openid);

    boolean canSpeakCheck(Integer lessonId, String openid);
}
