/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.constant;

import lombok.Getter;

/**
 * @title ContentTypeEnums
 * @desc 文件类型
 * @author he11o
 * @date 2016年6月1日
 * @version 1.0
 */
public enum UserTypeEnums {
    HACKER(-1, "非法用户"),

    TEACHER(0, "老师,课程拥有者"),

    STUDENT(1, "学生"),

    VISITOR(2, "访客"),

    OTHER_TEACHER(3, "老师，非课程拥有者"),

    ;

    @Getter
    private int code;
    @Getter
    private String desc;

    UserTypeEnums(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static final UserTypeEnums parse(Integer code) {
        if (null == code) {
            return null;
        }
        for (UserTypeEnums enums : UserTypeEnums.values()) {
            if (enums.getCode() == code) {
                return enums;
            }
        }
        return null;
    }

}
