/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.vo;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.sal.vzhibo.constant.AreaTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.MessageTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.vo.UploadInfo;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageInfo {
    private static final Logger log = LoggerFactory.getLogger(MessageInfo.class);
    private Integer lessonId;
    private Long studentId;
    private String openId;
    private Integer msgType = MessageTypeEnums.TEXT.getCode();
    private Integer areaType = AreaTypeEnums.DISCUSS.getCode();
    private String content;
    private String file;
    private Integer orgId;
    private Integer txCascadeId;

    public String toString() {
        return "MessageInfo [lessonId=" + this.lessonId + ", studentId=" + this.studentId + ", openId=" + this.openId + ", msgType=" + this.msgType + ", areaType=" + this.areaType + ", content=" + this.content + ", file=" + this.file + ", orgId=" + this.orgId + ", txCascadeId=" + this.txCascadeId + "]";
    }

    public Integer getLessonId() {
        return this.lessonId;
    }

    public void setLessonId(Integer lessonId) {
        this.lessonId = lessonId;
    }

    public Long getStudentId() {
        return this.studentId;
    }

    public void setStudentId(Long studentId) {
        this.studentId = studentId;
    }

    public String getOpenId() {
        return this.openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public Integer getMsgType() {
        return this.msgType;
    }

    public void setMsgType(Integer msgType) {
        this.msgType = msgType;
    }

    public Integer getAreaType() {
        return this.areaType;
    }

    public void setAreaType(Integer areaType) {
        this.areaType = areaType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public UploadInfo getFile() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.file})) {
            try {
                return (UploadInfo)JacksonUtil.str2Obj((String)this.file, UploadInfo.class);
            }
            catch (IOException e) {
                log.warn("Error in str2Obj", (Throwable)e);
            }
        }
        return null;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Integer getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public Integer getTxCascadeId() {
        return this.txCascadeId;
    }

    public void setTxCascadeId(Integer txCascadeId) {
        this.txCascadeId = txCascadeId;
    }

    public boolean isValidate() {
        if (MessageTypeEnums.TEXT.getCode() == this.msgType.intValue()) {
            String textMaxLengthConfig = PropertiesReader.getValue((String)"config-common", (String)"text_max_length");
            int textMaxLength = 1000;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{textMaxLengthConfig})) {
                textMaxLength = Integer.parseInt(textMaxLengthConfig);
            }
            if (StringUtils.isBlank((CharSequence)this.content) || this.content.length() > textMaxLength) {
                return false;
            }
        }
        return true;
    }
}

