/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.util;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.connect.route.api.enums.DeviceDomainEnum;
import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.vzhibo.util.HttpRetryUtil;
import com.baijia.tianxiao.sal.vzhibo.util.PropertiesReader;
import com.baijia.tianxiao.sal.vzhibo.vo.MessageVO;
import com.baijia.tianxiao.sal.vzhibo.vo.MsgInfoDto;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketUtil {
    private static final Logger log = LoggerFactory.getLogger(WebSocketUtil.class);
    private static final String WS_SERVER;
    private static final String BIZTYPE = "tx:cccr:vzhibo";
    private static final String DEVICEDOMAIN;
    private static final String UID_PREFIX = "vzhibo_";

    public static String sendWsMessage(MessageVO message, String deviceId) {
        HashMap map = Maps.newHashMap();
        map.put("bizType", BIZTYPE);
        map.put("deviceType", DeviceType.APP.getCode() + "");
        map.put("deviceDomain", DEVICEDOMAIN);
        map.put("uid", UID_PREFIX + message.getLessonId());
        if (deviceId != null) {
            map.put("deviceId", deviceId);
        }
        MsgInfoDto msgInfo = new MsgInfoDto();
        msgInfo.setMsgType(message.getMsgType());
        msgInfo.setContent(message);
        msgInfo.setAreaType(message.getAreaType());
        map.put("message", JacksonUtil.safeObj2Str((Object)msgInfo));
        return HttpRetryUtil.retryPost(WS_SERVER, map);
    }

    public static String sendBatchWsMessage(MessageVO message, Set<Object> deviceIds) {
        HashMap map = Maps.newHashMap();
        map.put("bizType", BIZTYPE);
        map.put("deviceType", DeviceType.APP.getCode() + "");
        map.put("deviceDomain", DEVICEDOMAIN);
        map.put("uid", UID_PREFIX + message.getLessonId());
        StringBuilder deviceIdsStr = new StringBuilder();
        for (Object object : deviceIds) {
            deviceIdsStr.append(object.toString()).append(",");
        }
        map.put("deviceIds", deviceIdsStr.deleteCharAt(deviceIdsStr.length() - 1).toString());
        MsgInfoDto msgInfo = new MsgInfoDto();
        msgInfo.setMsgType(message.getMsgType());
        msgInfo.setContent(message);
        msgInfo.setAreaType(message.getAreaType());
        map.put("message", JacksonUtil.safeObj2Str((Object)msgInfo));
        return HttpRetryUtil.retryPost(WS_SERVER, map);
    }

    public static String getUserToken(long liveId, String deviceId) {
        try {
            PushTokenConfig token = new PushTokenConfig();
            token.setBiz_type(BIZTYPE);
            token.setDevice_domain(Integer.valueOf(DEVICEDOMAIN));
            token.setDeviceId(deviceId);
            token.setDeviceType(Integer.valueOf(DeviceType.APP.getCode()));
            token.setUser_id(UID_PREFIX + liveId);
            return EncryptUtils.pushTokenEncode((PushTokenConfig)token);
        }
        catch (Exception e) {
            log.error("error in getUserToken", (Throwable)e);
            return null;
        }
    }

    static {
        DEVICEDOMAIN = DeviceDomainEnum.MOBILE.getCode();
        WS_SERVER = PropertiesReader.getValue("config", "WS_SERVER");
    }
}

