/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.util;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtil {
    private static Logger log = LoggerFactory.getLogger(JdbcUtil.class);
    private static final int DEF_BATCH_SIZE = 1000;

    public static Integer getInt(ResultSet rs, int index) throws SQLException {
        BigDecimal value = rs.getBigDecimal(index);
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public static Long getLong(ResultSet rs, int index) throws SQLException {
        BigDecimal value = rs.getBigDecimal(index);
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    public static Double getDouble(ResultSet rs, int index) throws SQLException {
        BigDecimal value = rs.getBigDecimal(index);
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public static String getString(ResultSet rs, int index) throws SQLException {
        return rs.getString(index);
    }

    public static Date getTimestamp(ResultSet rs, int index) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(index);
        if (timestamp == null) {
            return null;
        }
        return new Date(timestamp.getTime());
    }

    public static Date getTimestamp(ResultSet rs, int index, Calendar calendar) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(index);
        if (timestamp == null) {
            return null;
        }
        calendar.setTimeInMillis(timestamp.getTime());
        return calendar.getTime();
    }

    public static void setInt(PreparedStatement ps, int index, Integer value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 4);
        } else {
            ps.setInt(index, value);
        }
    }

    public static void setLong(PreparedStatement ps, int index, Long value) throws SQLException {
        if (value == null) {
            ps.setNull(index, -5);
        } else {
            ps.setLong(index, value);
        }
    }

    public static void setDouble(PreparedStatement ps, int index, Double value) throws SQLException {
        if (value == null) {
            ps.setNull(index, -5);
        } else {
            ps.setDouble(index, value);
        }
    }

    public static void setString(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 12);
        } else {
            ps.setString(index, value);
        }
    }

    public static void setTimestamp(PreparedStatement ps, int index, Date value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 93);
        } else {
            ps.setTimestamp(index, new Timestamp(value.getTime()));
        }
    }

    public static boolean appendCause(boolean needWhere, StringBuilder sql, String cause) {
        if (needWhere) {
            sql.append(" where");
            needWhere = false;
        } else {
            sql.append(" and");
        }
        sql.append(cause);
        return needWhere;
    }

    public static String genInsOnUpdateSql(String baseTable, String tablePrefix, String tableSuffix, String[] dimItems, String[] baseItems) {
        StringBuilder sql = new StringBuilder("insert into ");
        if (StringUtils.isNotBlank((String)tablePrefix)) {
            sql.append(tablePrefix);
        }
        sql.append(baseTable);
        if (StringUtils.isNotBlank((String)tableSuffix)) {
            sql.append(tableSuffix);
        }
        sql.append("(");
        if (dimItems != null) {
            for (String item : dimItems) {
                sql.append(item).append(",");
            }
        }
        for (String item : baseItems) {
            sql.append(item).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") values (");
        int size = (dimItems != null ? dimItems.length : 0) + baseItems.length;
        for (int i = 0; i < size; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") on duplicate key update ");
        for (String item : baseItems) {
            sql.append(item).append("=?,");
        }
        sql.deleteCharAt(sql.length() - 1);
        return sql.toString();
    }

    public static String genSelectSql(String baseTable, String tablePrefix, String tableSuffix, String[] dimItems, String[] items, String whereSql) {
        StringBuilder sql = new StringBuilder("select ");
        for (String item : dimItems) {
            sql.append(item).append(",");
        }
        for (String item : items) {
            sql.append(item).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" from ");
        if (StringUtils.isNotBlank((String)tablePrefix)) {
            sql.append(tablePrefix);
        }
        sql.append(baseTable);
        if (StringUtils.isNotBlank((String)tableSuffix)) {
            sql.append(tableSuffix);
        }
        if (StringUtils.isNotBlank((String)whereSql)) {
            sql.append(whereSql);
        }
        return sql.toString();
    }
}

