/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.util;

import com.google.common.collect.Maps;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSSignUtil {
    private static Logger logger = LoggerFactory.getLogger(JSSignUtil.class);

    public static Map<String, String> sign(String jsapi_ticket, String url) {
        HashMap ret = Maps.newHashMap();
        String nonce_str = JSSignUtil.create_nonce_str();
        String timestamp = JSSignUtil.create_timestamp();
        StringBuffer str = new StringBuffer();
        str.append("jsapi_ticket=").append(jsapi_ticket).append("&noncestr=").append(nonce_str).append("&timestamp=").append(timestamp).append("&url=").append(url);
        try {
            String signature = JSSignUtil.getSignature(str.toString());
            ret.put("url", url);
            ret.put("jsapi_ticket", jsapi_ticket);
            ret.put("nonceStr", nonce_str);
            ret.put("timestamp", timestamp);
            ret.put("signature", signature);
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
        return ret;
    }

    public static String getSignature(String sKey) throws Exception {
        String ciphertext = null;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] digest = md.digest(sKey.toString().getBytes());
        ciphertext = JSSignUtil.byteToStr(digest);
        return ciphertext.toLowerCase();
    }

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = strDigest + JSSignUtil.byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }

    private static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    public static String getCurrentTime() {
        Date dt = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(dt);
    }

    public static String signature(String jsapi_ticket, String nonce_str, long timestamp, String url) {
        Object[] paramArr = new String[]{"jsapi_ticket=" + jsapi_ticket, "timestamp=" + timestamp, "noncestr=" + nonce_str, "url=" + url};
        Arrays.sort(paramArr);
        String content = ((String)paramArr[0]).concat("&" + (String)paramArr[1]).concat("&" + (String)paramArr[2]).concat("&" + (String)paramArr[3]);
        logger.debug("\u62fc\u63a5\u4e4b\u540e\u7684content\u4e3a:" + content);
        String gensignature = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            gensignature = JSSignUtil.byteToStr(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        logger.debug("gensignature={}", (Object)gensignature.toLowerCase());
        return gensignature.toLowerCase();
    }
}

