/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmojiUtil {
    private static final Logger log = LoggerFactory.getLogger(EmojiUtil.class);
    private static Pattern pattern = Pattern.compile("<span(\\s+class=.*?emoji\\s+emoji).*?span>");
    private static final String NUMBER_FLAG = "20e3";

    public static String processWecharEmoji(String content) {
        ArrayList emojiCodeList = Lists.newArrayList();
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        do {
            String emoji = matcher.group();
            int start = emoji.indexOf("emoji emoji");
            int end = emoji.lastIndexOf("\"");
            if (start <= -1) continue;
            String emojiCode = emoji.substring(start + 11, end);
            emojiCodeList.add(emojiCode);
            content = matcher.replaceFirst("kbf");
            matcher = pattern.matcher(content);
        } while (matcher.find());
        ArrayList emojiList = Lists.newArrayListWithExpectedSize((int)emojiCodeList.size());
        for (String str : emojiCodeList) {
            try {
                if (str.endsWith(NUMBER_FLAG)) {
                    String[] element = str.split(NUMBER_FLAG);
                    emojiList.add(new String(Character.toChars(Integer.parseInt(element[0], 16))) + new String(Character.toChars(Integer.parseInt(NUMBER_FLAG, 16))));
                    continue;
                }
                emojiList.add(new String(Character.toChars(Integer.parseInt(str, 16))));
            }
            catch (Exception e) {
                log.debug("[processWecharEmoji]str:{}", (Object)str);
                log.debug("error in processWecharEmoji", (Throwable)e);
            }
        }
        for (String emojiTemp : emojiList) {
            content = content.replaceFirst("kbf", emojiTemp);
        }
        return content;
    }

    public static void main(String[] args) {
        System.out.println(EmojiUtil.processWecharEmoji("\u98ce\u5e06<span class=\"emoji emoji2600\"></span>\ufe0f<span class=\"emoji emoji1f604\"></span>\ufe0fSummer\u7684\u73ed\u7ea7\u7fa4_fJ9"));
        System.out.println(EmojiUtil.processWecharEmoji("\u5e7c\u513f\u7b14\u8bd5VIP<span class=\"emoji emoji3320e3\"></span>\u73ed"));
    }
}

