/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoRoomDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoRoom;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.vzhibo.constant.OrgFieldTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoRoomFieldEnums;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoRoomService;
import com.baijia.tianxiao.sal.vzhibo.vo.FieldUpdateVO;
import com.baijia.tianxiao.sal.vzhibo.vo.ShareDataVO;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoRoomBaseVO;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoRoomDetailVO;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.BindingService;
import com.baijia.tianxiao.sal.wechat.dto.binding.BindingInfoDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TxVZhiBoRoomServiceImpl
implements TxVZhiBoRoomService {
    private static final Logger log = LoggerFactory.getLogger(TxVZhiBoRoomServiceImpl.class);
    @Autowired
    TxVZhiBoRoomDao txVZhiBoRoomDao;
    @Autowired
    OrgAccountService orgAccountService;
    @Autowired
    OrgInfoService orgInfoService;
    @Value(value="${room_detail_url}")
    String ROOM_DETAIL_URL;
    @Value(value="${gsx_qrcode_url}")
    String GSX_QRCODE_URL;
    @Autowired
    BindingService bindingInfoService;
    @Autowired
    AuthorizerInfoService authorizerInfoService;
    @Value(value="${welcome_url}")
    String WELCOME_URL;
    @Value(value="${room_default_description}")
    String ROOM_DEFAULT_DESCRIPTION;

    @Override
    public TxVZhiBoRoomDetailVO detail(int fieldValue, OrgFieldTypeEnums fieldType, String authToken) {
        log.info("[detail]fieldValue:{},fieldType:{}", (Object)fieldValue, (Object)fieldType.getCode());
        TxVZhiBoRoomBaseVO roomBaseVO = this.getBaseInfo(fieldValue, fieldType);
        if (roomBaseVO == null) {
            return null;
        }
        TxVZhiBoRoomDetailVO detailVO = new TxVZhiBoRoomDetailVO(roomBaseVO);
        String roomUrl = this.ROOM_DETAIL_URL + roomBaseVO.getOrgNumber();
        String shortUrl = ShortUrlUtil.getHttpsShortUrl((String)roomUrl);
        detailVO.setRoomUrl(shortUrl);
        String qrcodeUrl = this.GSX_QRCODE_URL + roomUrl;
        detailVO.setQrcodeUrl(qrcodeUrl);
        Map<String, Object> orgWechatMap = null;
        try {
            orgWechatMap = this.getWechatBindingInfo(roomBaseVO.getOrgId(), authToken);
            log.info("[room.detail]getWechatBindingInfo:{}", orgWechatMap);
            if (orgWechatMap != null) {
                Object wechatInfo = orgWechatMap.get("info");
                detailVO.setBingPageUrl((String)orgWechatMap.get("bingPageUrl"));
                if (wechatInfo != null) {
                    detailVO.setWechat((BindingInfoDto)wechatInfo);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("[detail]Error In getWechatBindingInfo,orgId:{},authToken:{}", (Object)roomBaseVO.getOrgId(), (Object)authToken);
        }
        return detailVO;
    }

    @Override
    public int update(Integer orgId, FieldUpdateVO updateVO) {
        TxVZhiBoRoomFieldEnums fieldEnums = TxVZhiBoRoomFieldEnums.parse(updateVO.getField());
        if (fieldEnums == null) {
            return -1;
        }
        HashMap updateCondtion = Maps.newHashMap();
        updateCondtion.put(fieldEnums.getName(), updateVO.getValue());
        ArrayList updateProps = Lists.newArrayList();
        updateProps.add(fieldEnums.getName());
        if (TxVZhiBoRoomFieldEnums.AVATAR.equals((Object)fieldEnums) && updateVO.getExt() != null && NumberUtils.isDigits((String)updateVO.getExt().toString())) {
            updateCondtion.put("storageId", updateVO.getExt());
            updateProps.add("storageId");
        }
        updateCondtion.put("orgId", orgId);
        return this.txVZhiBoRoomDao.update((Map)updateCondtion, updateProps.toArray(new String[updateProps.size()]));
    }

    private Map<String, Object> getWechatBindingInfo(Integer orgId, String authToken) throws UnsupportedEncodingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        log.info("[getWechatBindingInfo]orgId:{}", (Object)orgId);
        BindingInfoDto dto = this.bindingInfoService.getBindingInfo(orgId);
        log.info("[getWechatBindingInfo]BindingInfoDto:{}", (Object)dto);
        map.put("info", dto);
        if (dto == null && StringUtils.isNotBlank((CharSequence)authToken)) {
            String urlPrefix = WechatProperties.getBindPageUrlPrefix();
            StringBuilder redirectBuilder = new StringBuilder();
            redirectBuilder.append(urlPrefix).append("wechat/bind.do?").append("&auth_token=").append(authToken).append("&from=").append(URLEncoder.encode(urlPrefix, "utf8"));
            String bingPageUrl = urlPrefix + "view/weixin/forward.html?redirect=" + URLEncoder.encode(redirectBuilder.toString(), "utf8");
            map.put("bingPageUrl", bingPageUrl);
        }
        return map;
    }

    @Override
    public TxVZhiBoRoomBaseVO getBaseInfo(int fieldValue, OrgFieldTypeEnums fieldType) {
        OrgAccount orgAccount = null;
        orgAccount = OrgFieldTypeEnums.NUMBER.equals((Object)fieldType) ? this.orgAccountService.getOrgAccountByNumber(Integer.valueOf(fieldValue)) : this.orgAccountService.getOrgAccountById(Integer.valueOf(fieldValue));
        if (orgAccount == null) {
            return null;
        }
        TxVZhiBoRoomBaseVO vZhiBoRoomBaseVO = new TxVZhiBoRoomBaseVO();
        HashMap condition = Maps.newHashMap();
        if (OrgFieldTypeEnums.NUMBER.equals((Object)fieldType)) {
            condition.put(fieldType.getName(), orgAccount.getNumber());
        } else {
            condition.put(fieldType.getName(), orgAccount.getId());
        }
        List txVZhiBoRooms = this.txVZhiBoRoomDao.queryByCondition((Map)condition, new PageDto(), new String[0]);
        OrgInfoSimpleDto simpleDto = null;
        try {
            simpleDto = this.orgInfoService.getOrgInfo(new Long(orgAccount.getId().intValue()));
        }
        catch (Exception e) {
            log.error("Error In orgInfoService.getMOrgInfo,orgId:{}", (Object)e, (Object)orgAccount.getId());
        }
        if (simpleDto == null) {
            return null;
        }
        vZhiBoRoomBaseVO.setOrgId(simpleDto.getOrgId());
        if (CollectionUtils.isEmpty((Collection)txVZhiBoRooms)) {
            TxVZhiBoRoom vZhiBoRoom = new TxVZhiBoRoom();
            vZhiBoRoom.setOrgId(orgAccount.getId());
            vZhiBoRoom.setOrgNumber(Integer.valueOf(simpleDto.getOrgNumber().intValue()));
            vZhiBoRoom.setDescription(simpleDto.getIntroduce());
            vZhiBoRoom.setName(simpleDto.getShortName() + "\u7684\u76f4\u64ad\u95f4");
            this.txVZhiBoRoomDao.save((Object)vZhiBoRoom, new String[0]);
            vZhiBoRoomBaseVO.setId(vZhiBoRoom.getOrgId());
            vZhiBoRoomBaseVO.setDescription(simpleDto.getIntroduce());
            vZhiBoRoomBaseVO.setName(simpleDto.getShortName());
            vZhiBoRoomBaseVO.setOrgNumber(simpleDto.getOrgNumber().intValue());
            vZhiBoRoomBaseVO.setAvatar(simpleDto.getLogo());
        } else {
            TxVZhiBoRoom vZhiBoRoom = (TxVZhiBoRoom)txVZhiBoRooms.get(0);
            if (StringUtils.isNotBlank((CharSequence)vZhiBoRoom.getDescription())) {
                vZhiBoRoomBaseVO.setDescription(vZhiBoRoom.getDescription());
            } else {
                vZhiBoRoomBaseVO.setDescription(simpleDto.getIntroduce());
            }
            if (StringUtils.isNotBlank((CharSequence)vZhiBoRoom.getName())) {
                vZhiBoRoomBaseVO.setName(vZhiBoRoom.getName());
            } else {
                vZhiBoRoomBaseVO.setName(simpleDto.getShortName() + "\u7684\u76f4\u64ad\u95f4");
            }
            if (StringUtils.isNotBlank((CharSequence)vZhiBoRoom.getAvatar())) {
                vZhiBoRoomBaseVO.setAvatar(vZhiBoRoom.getAvatar());
            } else {
                vZhiBoRoomBaseVO.setAvatar(simpleDto.getLogo());
            }
            vZhiBoRoomBaseVO.setOrgNumber((int)vZhiBoRoom.getOrgNumber());
            vZhiBoRoomBaseVO.setId(vZhiBoRoom.getId().intValue());
        }
        return vZhiBoRoomBaseVO;
    }

    @Override
    public Map<String, Object> create(Integer orgId) {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(orgId);
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "token is invalid!");
        }
        HashMap returnMap = Maps.newHashMap();
        returnMap.put("welcomeUrl", this.WELCOME_URL);
        returnMap.put("roomUrl", this.ROOM_DETAIL_URL + orgAccount.getNumber().toString());
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        List txVZhiBoRooms = this.txVZhiBoRoomDao.queryByCondition((Map)condition, new PageDto(), new String[0]);
        if (CollectionUtils.isEmpty((Collection)txVZhiBoRooms)) {
            TxVZhiBoRoom vZhiBoRoom = new TxVZhiBoRoom();
            vZhiBoRoom.setOrgId(orgId);
            vZhiBoRoom.setOrgNumber(orgAccount.getNumber());
            OrgInfoSimpleDto simpleDto = null;
            try {
                simpleDto = this.orgInfoService.getOrgInfo(new Long(orgAccount.getId().intValue()));
            }
            catch (Exception e) {
                log.error("Error In orgInfoService.getMOrgInfo,orgId:{}", (Object)e, (Object)orgAccount.getId());
            }
            if (simpleDto != null) {
                log.info("[create]simpleDto:{}", (Object)simpleDto);
                if (StringUtils.isBlank((CharSequence)simpleDto.getIntroduce())) {
                    vZhiBoRoom.setDescription(this.ROOM_DEFAULT_DESCRIPTION);
                } else {
                    vZhiBoRoom.setDescription(simpleDto.getIntroduce());
                }
                vZhiBoRoom.setName(simpleDto.getShortName() + "\u7684\u76f4\u64ad\u95f4");
            }
            vZhiBoRoom.setDescription(simpleDto.getIntroduce());
            vZhiBoRoom.setAvatar(simpleDto.getLogo());
            this.txVZhiBoRoomDao.save((Object)vZhiBoRoom, new String[0]);
            returnMap.put("roomId", vZhiBoRoom.getId());
            returnMap.put("name", vZhiBoRoom.getName());
        } else {
            returnMap.put("roomId", ((TxVZhiBoRoom)txVZhiBoRooms.get(0)).getId());
            returnMap.put("name", ((TxVZhiBoRoom)txVZhiBoRooms.get(0)).getName());
        }
        return returnMap;
    }

    @Override
    public ShareDataVO getShareData(TxVZhiBoRoomBaseVO baseVO) {
        ShareDataVO dataVO = new ShareDataVO();
        dataVO.setTitle(baseVO.getName());
        if (StringUtils.isBlank((CharSequence)baseVO.getDescription())) {
            OrgInfoSimpleDto simpleDto = null;
            try {
                simpleDto = this.orgInfoService.getOrgInfo(new Long(baseVO.getOrgId().intValue()));
            }
            catch (Exception e) {
                log.error("Error In orgInfoService.getMOrgInfo,orgId:{}", (Object)e, (Object)baseVO.getOrgId());
            }
            if (simpleDto == null || StringUtils.isBlank((CharSequence)simpleDto.getIntroduce())) {
                dataVO.setContent(this.ROOM_DEFAULT_DESCRIPTION);
            } else {
                dataVO.setContent(simpleDto.getIntroduce());
            }
        } else {
            dataVO.setContent(baseVO.getDescription());
        }
        dataVO.setImageUrl(baseVO.getAvatar());
        dataVO.setShareUrl(this.ROOM_DETAIL_URL + baseVO.getOrgNumber());
        return dataVO;
    }

    @Override
    public ShareDataVO getShareData(int roomId) {
        TxVZhiBoRoom boRoom = (TxVZhiBoRoom)this.txVZhiBoRoomDao.getById((Serializable)Integer.valueOf(roomId), new String[0]);
        if (boRoom == null) {
            return null;
        }
        ShareDataVO dataVO = new ShareDataVO();
        dataVO.setTitle(boRoom.getName());
        if (StringUtils.isBlank((CharSequence)boRoom.getDescription())) {
            OrgInfoSimpleDto simpleDto = null;
            try {
                simpleDto = this.orgInfoService.getOrgInfo(new Long(boRoom.getOrgId().intValue()));
            }
            catch (Exception e) {
                log.error("Error In orgInfoService.getMOrgInfo,orgId:{}", (Object)e, (Object)boRoom.getOrgId());
            }
            if (StringUtils.isBlank((CharSequence)simpleDto.getIntroduce())) {
                dataVO.setContent(this.ROOM_DEFAULT_DESCRIPTION);
            } else {
                dataVO.setContent(simpleDto.getIntroduce());
            }
        } else {
            dataVO.setContent(boRoom.getDescription());
        }
        dataVO.setImageUrl(boRoom.getAvatar());
        dataVO.setShareUrl(this.ROOM_DETAIL_URL + boRoom.getOrgNumber());
        return dataVO;
    }

    @Override
    public TxVZhiBoRoom getById(Integer roomId) {
        if (roomId == null) {
            return null;
        }
        return (TxVZhiBoRoom)this.txVZhiBoRoomDao.getById((Serializable)roomId, new String[0]);
    }
}

