/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.constant.OrderEnums;
import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoMessageDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoMessage;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.AreaTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.MessageTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.OrderTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoEventType;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoUserType;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoEventLogService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoMessageService;
import com.baijia.tianxiao.sal.vzhibo.util.WebSocketUtil;
import com.baijia.tianxiao.sal.vzhibo.vo.LessonDetailVO;
import com.baijia.tianxiao.sal.vzhibo.vo.MessageInfo;
import com.baijia.tianxiao.sal.vzhibo.vo.MessageListVO;
import com.baijia.tianxiao.sal.vzhibo.vo.MessageVO;
import com.baijia.tianxiao.sal.vzhibo.vo.UploadInfo;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="txVZhiBoMessageService")
public class TxVZhiBoMessageServiceImpl
implements TxVZhiBoMessageService {
    private static final Logger log = LoggerFactory.getLogger(TxVZhiBoMessageServiceImpl.class);
    @Autowired
    TxVZhiBoMessageDao txVZhiBoMessageDao;
    @Autowired
    RedisTemplate<String, String> redisTemplate;
    @Autowired
    FansService fansService;
    @Autowired
    TxVZhiBoLessonService txVZhiBoLessonService;
    @Autowired
    TxVZhiBoEventLogService txVZhiBoEventLogService;
    public static final int MSG_FREQUENT_LIMIT = 5000;
    public static final int MSG_FREQUENT_COUNT_LIMIT = 3;
    @Value(value="${student_default_avatar}")
    String STUDENT_DEFAULT_AVATAR;
    @Value(value="${cc_server_url}")
    String ccServerUrl;
    @Value(value="${msg_queue_pos}")
    String MSG_QUEUE_POS;
    @Value(value="${process_count}")
    String PROCESS_COUNT;
    private static final String VISIT_COUNT_INIT = "1";

    @Override
    public String send(MessageInfo messageInfo, Set<Object> deviceIds) {
        log.info("[send]msg:{}", (Object)messageInfo.toString());
        Integer lessonId = messageInfo.getLessonId();
        if (lessonId == null) {
            return null;
        }
        if (!this.txVZhiBoLessonService.checkLessonMessageStatus(lessonId)) {
            log.info("[send]checkLessonMessageStatus result false!!");
            return null;
        }
        MessageTypeEnums typeEnums = MessageTypeEnums.parse(messageInfo.getMsgType());
        return this.porcessMsg(messageInfo, typeEnums, deviceIds);
    }

    private String porcessMsg(MessageInfo messageInfo, MessageTypeEnums typeEnums, Set<Object> deviceIds) {
        Integer lessonId = messageInfo.getLessonId();
        this.redisTemplate.opsForSet().add((Object)RedisKeyEnums.VZB.MSG_QUEUE_LIVE_LESSONIDS.getRedisKey(), (Object[])new String[]{lessonId.toString()});
        switch (typeEnums) {
            case PIC: {
                return this.porcessMediaMsg(messageInfo, deviceIds);
            }
            case VOICE: {
                return this.porcessMediaMsg(messageInfo, deviceIds);
            }
            case TEXT: {
                return this.processTextMsg(messageInfo, deviceIds);
            }
        }
        return null;
    }

    private MessageVO initCommonMsg(MessageInfo messageInfo) {
        MessageVO msg = new MessageVO();
        msg.setMsgType(messageInfo.getMsgType());
        msg.setAreaType(messageInfo.getAreaType());
        msg.setContent(messageInfo.getContent());
        msg.setLessonId(messageInfo.getLessonId());
        msg.setOpenId(messageInfo.getOpenId());
        msg.setCreateTime(System.currentTimeMillis());
        msg.setFile(messageInfo.getFile());
        UUID uniqueId = UUID.randomUUID();
        msg.setUniqueId(uniqueId.toString());
        try {
            this.initUserInfo(msg, messageInfo);
            return msg;
        }
        catch (Exception e) {
            log.error("Error In initMsg", (Throwable)e);
            return null;
        }
    }

    private boolean processCommonMsg(MessageVO messageVO, Set<Object> deviceIds) {
        AreaTypeEnums areaTypeEnums = AreaTypeEnums.parse(messageVO.getAreaType());
        String msgQuqueKey = areaTypeEnums.getPrefix() + messageVO.getLessonId();
        try {
            Boolean hasKey = this.redisTemplate.hasKey((Object)msgQuqueKey);
            if (!hasKey.booleanValue()) {
                Long expireTime = this.txVZhiBoLessonService.getExpireTime(messageVO.getLessonId());
                log.info("[processTextMsg]expireTime:{}", (Object)expireTime);
                if (expireTime < 0L) {
                    return false;
                }
                this.redisTemplate.opsForList().rightPush((Object)msgQuqueKey, (Object)JacksonUtil.obj2Str((Object)messageVO));
                this.redisTemplate.expire((Object)msgQuqueKey, expireTime / 1000L, TimeUnit.SECONDS);
            } else {
                this.redisTemplate.opsForList().rightPush((Object)msgQuqueKey, (Object)JacksonUtil.obj2Str((Object)messageVO));
            }
        }
        catch (Exception e) {
            log.error("Error In processTextMsg", (Throwable)e);
            return false;
        }
        MessageVO newMessageNotice = new MessageVO();
        newMessageNotice.setMsgType(messageVO.getMsgType());
        newMessageNotice.setAreaType(messageVO.getAreaType());
        newMessageNotice.setContent(messageVO.getContent());
        newMessageNotice.setLessonId(messageVO.getLessonId());
        log.info("[processTextMsg] deviceIds:{}", deviceIds);
        if (CollectionUtils.isNotEmpty(deviceIds)) {
            WebSocketUtil.sendBatchWsMessage(newMessageNotice, deviceIds);
        }
        return true;
    }

    private String processTextMsg(MessageInfo messageInfo, Set<Object> deviceIds) {
        MessageVO msg = this.initCommonMsg(messageInfo);
        if (msg == null) {
            log.info("Error In initMsg,messageInfo:{}", (Object)messageInfo);
            return null;
        }
        boolean flag = this.processCommonMsg(msg, deviceIds);
        return flag ? msg.getUniqueId() : null;
    }

    private void initUserInfo(MessageVO msg, MessageInfo messageInfo) throws ExecutionException {
        Fans fans;
        if (messageInfo.getOrgId() != null) {
            LessonDetailVO detailVO = null;
            try {
                detailVO = this.txVZhiBoLessonService.getOnlyDetailById(messageInfo.getLessonId());
                if (detailVO != null) {
                    msg.setAvatar(detailVO.getTeacherAvatar());
                    msg.setNickname(detailVO.getTeacherName());
                }
            }
            catch (Exception e) {
                log.info("Error in getDetailById", (Throwable)e);
            }
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{messageInfo.getOpenId()}) && (fans = this.fansService.getFans(messageInfo.getOpenId())) != null) {
            if (StringUtils.isBlank((CharSequence)fans.getHeadImgUrl())) {
                msg.setAvatar(this.STUDENT_DEFAULT_AVATAR);
            } else {
                msg.setAvatar(fans.getHeadImgUrl());
            }
            msg.setNickname(fans.getNick());
        }
    }

    private String porcessMediaMsg(MessageInfo messageInfo, Set<Object> deviceIds) {
        MessageVO msg = this.initCommonMsg(messageInfo);
        if (msg == null) {
            log.info("Error In initMsg,messageInfo:{}", (Object)messageInfo);
            return null;
        }
        boolean flag = this.processCommonMsg(msg, deviceIds);
        return flag ? msg.getUniqueId() : null;
    }

    @Override
    public MessageListVO get(long lessonId, long index, long count, int areaType, int order) {
        AreaTypeEnums areaTypeEnums = AreaTypeEnums.parse(areaType);
        if (areaTypeEnums == null) {
            return new MessageListVO();
        }
        String msgQuqueKey = areaTypeEnums.getPrefix() + lessonId;
        Long length = this.redisTemplate.opsForList().size((Object)msgQuqueKey);
        List messages = null;
        if (count <= 0L) {
            count = length;
        }
        if (index < 0L) {
            index = 0L;
        }
        if (order == 0) {
            long end = index + count - 1L;
            if (end < 0L) {
                end = 0L;
            }
            log.info("[get]rest.range msgQuqueKey:{},start:{},end:{}", new Object[]{msgQuqueKey, index, end});
            messages = this.redisTemplate.opsForList().range((Object)msgQuqueKey, index, end);
        } else {
            long end;
            long start = index - count - 1L;
            if (start < 0L) {
                start = 0L;
            }
            if ((end = index - 2L) < 0L) {
                end = 0L;
            }
            log.info("[get]rest.range msgQuqueKey:{},start:{},end:{}", new Object[]{msgQuqueKey, index, end});
            messages = this.redisTemplate.opsForList().range((Object)msgQuqueKey, start, end);
        }
        MessageListVO listVO = new MessageListVO();
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return listVO;
        }
        List infos = this.convert2MessageVO(messages);
        this.initMsgId(infos, index, order, count);
        if (areaType == AreaTypeEnums.DISCUSS.getCode()) {
            infos = Lists.reverse(infos);
        }
        listVO.setMessages(infos);
        listVO.setTotal(length);
        return listVO;
    }

    private void initMsgId(List<MessageVO> infos, long index, int order, long count) {
        for (int i = 0; i < infos.size(); ++i) {
            MessageVO messageVO = infos.get(i);
            if (order == OrderTypeEnums.POSITIVE.getCode()) {
                messageVO.setId(index + (long)i + 1L);
                continue;
            }
            if ((long)infos.size() == count) {
                messageVO.setId(index - count + (long)i);
                continue;
            }
            messageVO.setId((long)i + 1L);
        }
    }

    @Override
    public MessageListVO latest(long lessonId, int areaType, int count) {
        AreaTypeEnums areaTypeEnums = AreaTypeEnums.parse(areaType);
        if (areaTypeEnums == null) {
            return new MessageListVO();
        }
        TxVZhiBoLesson boLesson = this.txVZhiBoLessonService.getById(lessonId);
        if (boLesson == null) {
            return new MessageListVO();
        }
        MessageListVO listVO = new MessageListVO();
        if (TxVZhiBoLessonStatusEnums.DONE.getCode() == boLesson.getStatus().intValue()) {
            listVO = this.getLatestMsgFromDB(areaTypeEnums, lessonId, count);
        } else if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == boLesson.getStatus().intValue()) {
            listVO = this.getLatestMsgFromRedis(areaTypeEnums, lessonId, count);
        }
        return listVO;
    }

    private MessageListVO getLatestMsgFromDB(AreaTypeEnums areaTypeEnums, long lessonId, int count) {
        MessageListVO listVO = new MessageListVO();
        HashMap countCondition = Maps.newHashMap();
        countCondition.put("areaType", areaTypeEnums.getCode());
        countCondition.put("lesson_id", lessonId);
        int total = this.txVZhiBoMessageDao.countByCondition((Map)countCondition, "id", true);
        if (total == 0) {
            return listVO;
        }
        listVO.setTotal(total);
        countCondition.put("count", count);
        List boMessages = this.txVZhiBoMessageDao.getLatestMsgFromDB(lessonId, count, areaTypeEnums.getCode());
        List<MessageVO> infos = this.convertMsg2MessageVO(boMessages);
        listVO.setMessages(infos);
        return listVO;
    }

    private List<MessageVO> convertMsg2MessageVO(List<TxVZhiBoMessage> boMessages) {
        if (CollectionUtils.isEmpty(boMessages)) {
            return null;
        }
        ArrayList messageVOs = Lists.newArrayListWithExpectedSize((int)boMessages.size());
        for (TxVZhiBoMessage message : boMessages) {
            MessageVO messageVO = this.convert2MessageVO(message);
            messageVOs.add(messageVO);
        }
        return messageVOs;
    }

    private MessageVO convert2MessageVO(TxVZhiBoMessage message) {
        MessageVO messageVO = new MessageVO();
        messageVO.setAreaType(message.getAreaType());
        messageVO.setContent(message.getContent());
        if (message.getCreateTime() != null) {
            messageVO.setCreateTime(message.getCreateTime().getTime());
        }
        messageVO.setId(message.getId());
        messageVO.setLessonId(message.getLessonId());
        messageVO.setMsgType(message.getMsgType());
        messageVO.setOpenId(message.getOpenid());
        messageVO.setStudentId(message.getStudentId());
        messageVO.setUniqueId(message.getUniqueId());
        messageVO.setAvatar(message.getAvatar());
        messageVO.setNickname(message.getNickname());
        if (MessageTypeEnums.PIC.getCode() == message.getMsgType().intValue() || MessageTypeEnums.VOICE.getCode() == message.getMsgType().intValue()) {
            UploadInfo uploadInfo = new UploadInfo();
            uploadInfo.setDuration(message.getDuration());
            uploadInfo.setHeight(message.getHeight());
            uploadInfo.setStorageId(message.getStorageId());
            uploadInfo.setUrl(message.getUrl());
            uploadInfo.setWidth(message.getWidth());
            messageVO.setFile(uploadInfo);
        }
        return messageVO;
    }

    private MessageListVO getLatestMsgFromRedis(AreaTypeEnums areaTypeEnums, long lessonId, int count) {
        String msgQuqueKey = areaTypeEnums.getPrefix() + lessonId;
        Long length = this.redisTemplate.opsForList().size((Object)msgQuqueKey);
        long index = length - (long)count;
        if (index < 0L) {
            index = 0L;
        }
        List messages = this.redisTemplate.opsForList().range((Object)msgQuqueKey, index, length.longValue());
        MessageListVO listVO = new MessageListVO();
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return listVO;
        }
        List infos = this.convert2MessageVO(messages);
        this.initId(infos, length);
        if (AreaTypeEnums.DISCUSS.equals((Object)areaTypeEnums)) {
            infos = Lists.reverse(infos);
        }
        listVO.setMessages(infos);
        listVO.setTotal(length);
        return listVO;
    }

    private List<MessageVO> convert2MessageVO(List<String> messages) {
        ArrayList messageVOs = Lists.newArrayListWithExpectedSize((int)messages.size());
        for (String message : messages) {
            try {
                messageVOs.add(JacksonUtil.str2Obj((String)message, MessageVO.class));
            }
            catch (IOException e) {
                log.error("Error In convert2MessageVO,message:{}", (Object)message);
            }
        }
        return messageVOs;
    }

    private void initId(List<MessageVO> infos, Long length) {
        if (CollectionUtils.isEmpty(infos)) {
            return;
        }
        Long index = length - (long)infos.size() + 1L;
        for (int i = 0; i < infos.size(); ++i) {
            MessageVO vo = infos.get(i);
            vo.setId(index + (long)i);
        }
    }

    @Override
    public String getCCUrl(Integer lessonId, Integer txCascadeId, Integer orgId, String deviceId) {
        TxVZhiBoLesson txVZhiBoLesson = this.txVZhiBoLessonService.getById(lessonId.intValue());
        if (txVZhiBoLesson == null || TxVZhiBoLessonStatusEnums.DONE.getCode() == txVZhiBoLesson.getStatus().intValue()) {
            return "";
        }
        String token = WebSocketUtil.getUserToken(lessonId.intValue(), deviceId);
        log.info("[getWSKey]lessonId:{},token:{}", (Object)lessonId, (Object)token);
        if (orgId != null) {
            Integer uId = txCascadeId;
            TxVZhiBoUserType userType = TxVZhiBoUserType.CASCADE_ACCOUNT;
            if (txCascadeId == null) {
                uId = orgId;
                userType = TxVZhiBoUserType.JIGOU;
            }
            this.txVZhiBoEventLogService.saveEvent(lessonId, uId, userType, TxVZhiBoEventType.ENTER);
        }
        return this.ccServerUrl + token;
    }

    @Override
    public List<TxVZhiBoMessage> pagingByLessonIdAndAreaType(Long lessonId, int areaType, PageDto pageDto) {
        HashMap condition = Maps.newHashMap();
        condition.put("lessonId", lessonId);
        condition.put("areaType", areaType);
        return this.txVZhiBoMessageDao.queryByCondition((Map)condition, pageDto, new String[]{"lessonId", "areaType"});
    }

    @Override
    public int getCountByLessonIdAndAreaType(Long lessonId, int areaType) {
        HashMap condition = Maps.newHashMap();
        condition.put("lessonId", lessonId);
        condition.put("areaType", areaType);
        return this.txVZhiBoMessageDao.countByCondition((Map)condition, "id", false);
    }

    @Override
    public void batchSave(List<MessageVO> messagesList) {
        if (CollectionUtils.isEmpty(messagesList)) {
            return;
        }
        List vZhiBoMessages = Lists.transform(messagesList, (Function)new Function<MessageVO, TxVZhiBoMessage>(){

            public TxVZhiBoMessage apply(MessageVO input) {
                TxVZhiBoMessage message = TxVZhiBoMessageServiceImpl.this.convert2Message(input);
                return message;
            }
        });
        this.txVZhiBoMessageDao.saveAll(vZhiBoMessages, new String[0]);
    }

    protected TxVZhiBoMessage convert2Message(MessageVO input) {
        TxVZhiBoMessage message = new TxVZhiBoMessage();
        message.setAreaType(Integer.valueOf(input.getAreaType()));
        message.setContent(input.getContent());
        message.setCreateTime(new Date(input.getCreateTime()));
        UploadInfo file = input.getFile();
        if (file != null) {
            message.setHeight(file.getHeight());
            message.setStorageId(file.getStorageId());
            message.setWidth(file.getWidth());
            message.setUrl(file.getUrl());
            message.setDuration(file.getDuration());
        }
        message.setLessonId(input.getLessonId());
        message.setMsgType(Integer.valueOf(input.getMsgType()));
        message.setOpenid(input.getOpenId());
        message.setStudentId(input.getStudentId());
        message.setUniqueId(input.getUniqueId());
        message.setAvatar(input.getAvatar());
        message.setNickname(input.getNickname());
        return message;
    }

    @Override
    public List<MessageVO> history(long lessonId, long id, int count, int areaType) {
        List messages = this.txVZhiBoMessageDao.history(Long.valueOf(lessonId), Long.valueOf(id), Integer.valueOf(count), Integer.valueOf(areaType), Integer.valueOf(OrderEnums.DESC.getCode()));
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return Lists.newArrayList();
        }
        List<MessageVO> messageVOs = this.convertMsg2MessageVO(messages);
        return messageVOs;
    }

    @Override
    public boolean visitFrequentCheck(String openid) {
        String redisKey = RedisKeyEnums.VZB.STUDENT_LATEST_VISIT.getRedisKey() + openid;
        String redisCountKey = RedisKeyEnums.VZB.STUDENT_LATEST_VISIT_COUNT.getRedisKey() + openid;
        Boolean hasKey = this.redisTemplate.hasKey((Object)redisKey);
        if (!hasKey.booleanValue()) {
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)String.valueOf(System.currentTimeMillis()));
            this.redisTemplate.expire((Object)redisKey, 120L, TimeUnit.MINUTES);
            this.redisTemplate.opsForValue().set((Object)redisCountKey, (Object)VISIT_COUNT_INIT);
            this.redisTemplate.expire((Object)redisKey, 120L, TimeUnit.MINUTES);
            return true;
        }
        String lastVisitStr = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isBlank((CharSequence)lastVisitStr)) {
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)String.valueOf(System.currentTimeMillis()));
            this.redisTemplate.expire((Object)redisKey, 120L, TimeUnit.MINUTES);
            this.redisTemplate.opsForValue().set((Object)redisCountKey, (Object)VISIT_COUNT_INIT);
            this.redisTemplate.expire((Object)redisKey, 120L, TimeUnit.MINUTES);
            return true;
        }
        Long lastVisit = Long.parseLong(lastVisitStr);
        long currentTime = System.currentTimeMillis();
        log.info("[visitFrequentCheck]lastVisit:{},currentTime:{}", (Object)lastVisit, (Object)currentTime);
        if (lastVisit == null || lastVisit == -1L) {
            return true;
        }
        Boolean hasRedisCountKey = this.redisTemplate.hasKey((Object)redisCountKey);
        if (!hasRedisCountKey.booleanValue()) {
            this.redisTemplate.opsForValue().set((Object)redisCountKey, (Object)VISIT_COUNT_INIT);
            this.redisTemplate.expire((Object)redisKey, 120L, TimeUnit.MINUTES);
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)String.valueOf(currentTime));
            return true;
        }
        if (currentTime - lastVisit < 5000L) {
            String lastVisitCountStr = (String)this.redisTemplate.opsForValue().get((Object)redisCountKey);
            log.info("[visitFrequentCheck]lastVisitCount:{}", (Object)lastVisitCountStr);
            Integer lastestVistCount = Integer.parseInt(lastVisitCountStr);
            if (lastestVistCount < 3) {
                lastestVistCount = lastestVistCount + 1;
                this.redisTemplate.opsForValue().set((Object)redisCountKey, (Object)(lastestVistCount + ""));
                return true;
            }
            return false;
        }
        this.redisTemplate.opsForValue().set((Object)redisCountKey, (Object)VISIT_COUNT_INIT);
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)String.valueOf(currentTime));
        return true;
    }

    @Override
    public int persistMessage(int lessonId) {
        int zhiboCount = this.doPersistentMsg(this.redisTemplate, AreaTypeEnums.ZHIBO.getPrefix() + lessonId);
        log.info("[persistMessage]persist msg in [{}] count:{}", (Object)lessonId, (Object)zhiboCount);
        int discussCount = this.doPersistentMsg(this.redisTemplate, AreaTypeEnums.DISCUSS.getPrefix() + lessonId);
        log.info("[persistMessage]persist msg in [{}] count:{}", (Object)lessonId, (Object)discussCount);
        return zhiboCount + discussCount;
    }

    private int doPersistentMsg(RedisTemplate<String, String> redisTemplate, String key) {
        long lastPos = 0L;
        String pos = (String)redisTemplate.opsForValue().get((Object)(key + this.MSG_QUEUE_POS));
        lastPos = StringUtils.isBlank((CharSequence)pos) ? 0L : Long.parseLong(pos);
        long length = redisTemplate.opsForList().size((Object)key);
        long end = lastPos + (long)Integer.parseInt(this.PROCESS_COUNT);
        if (end > length) {
            end = length;
        }
        log.info("[persistentMsg]key:{},lastPos:{},end:{}", new Object[]{key, lastPos, end});
        if (lastPos == end) {
            return 0;
        }
        List messages = redisTemplate.opsForList().range((Object)key, lastPos, end);
        if (CollectionUtils.isNotEmpty((Collection)messages)) {
            List<MessageVO> messagesList = this.convert2Message(messages);
            this.batchSave(messagesList);
            redisTemplate.opsForValue().set((Object)(key + this.MSG_QUEUE_POS), (Object)(end + ""));
            return messages.size();
        }
        log.info("[doPersistentMsg]msg queue is empty!");
        return 0;
    }

    private List<MessageVO> convert2Message(List<String> messages) {
        ArrayList messagesList = Lists.newArrayListWithExpectedSize((int)messages.size());
        for (String messageStr : messages) {
            try {
                MessageVO message = (MessageVO)JacksonUtil.str2Obj((String)messageStr, MessageVO.class);
                messagesList.add(message);
            }
            catch (Exception e) {
                log.error("error to parse Object ,message :{}", (Object)messageStr);
            }
        }
        return messagesList;
    }

    @Override
    public List<MessageVO> historyByUniqueId(Integer lessonId, String uniqueId, Integer count, Integer areaType) {
        TxVZhiBoMessage boMessage = this.getByUniqueId(uniqueId);
        if (boMessage == null) {
            return null;
        }
        return this.history(lessonId.intValue(), boMessage.getId(), count, areaType);
    }

    @Override
    public TxVZhiBoMessage getByUniqueId(String uniqueId) {
        if (StringUtils.isBlank((CharSequence)uniqueId)) {
            return null;
        }
        return this.txVZhiBoMessageDao.getByUniqueId(uniqueId);
    }

    @Override
    public List<MessageVO> history(Long lessonId, Long id, Integer count, Integer areaType, Integer order) {
        List messages = this.txVZhiBoMessageDao.history(lessonId, id, count, areaType, order);
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return Lists.newArrayList();
        }
        List<MessageVO> messageVOs = this.convertMsg2MessageVO(messages);
        return messageVOs;
    }

    @Override
    public List<MessageVO> historyByUniqueId(Long lessonId, String uniqueId, Integer count, Integer areaType, Integer order) {
        TxVZhiBoMessage boMessage = this.getByUniqueId(uniqueId);
        if (boMessage == null) {
            return null;
        }
        return this.history(lessonId, boMessage.getId(), count, areaType, order);
    }
}

