/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonStudentService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TxVZhiBoLessonStudentServiceImpl
implements TxVZhiBoLessonStudentService {
    private static final Logger log = LoggerFactory.getLogger(TxVZhiBoLessonStudentServiceImpl.class);
    @Autowired
    TxVZhiBoLessonStudentDao txVZhiBoLessonStudentDao;
    @Autowired
    TxVZhiBoLessonService txVZhiBoLessonService;
    @Autowired
    RedisTemplate<String, String> redisTemplate;

    @Override
    public Map<Integer, Integer> statStudentCountByRoomId(Integer roomId) {
        log.info("[statStudentCountByRoomId]roomId:{}", (Object)roomId);
        HashMap resutlMap = Maps.newHashMap();
        if (roomId == null) {
            return resutlMap;
        }
        List<TxVZhiBoLesson> lessons = this.txVZhiBoLessonService.getByRoomId(roomId);
        if (CollectionUtils.isEmpty(lessons)) {
            return resutlMap;
        }
        ArrayList doneLessonIds = Lists.newArrayList();
        for (TxVZhiBoLesson boLesson : lessons) {
            if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == boLesson.getStatus().intValue()) {
                long count = this.getStudentCountbyLessonId(boLesson.getId().intValue(), TxVZhiBoLessonStatusEnums.LIVE.getCode());
                resutlMap.put(boLesson.getId().intValue(), (int)count);
                continue;
            }
            doneLessonIds.add(boLesson.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)doneLessonIds)) {
            HashMap countCondition = Maps.newHashMap();
            countCondition.put("lessonId", doneLessonIds);
            Map resutlMapDone = this.txVZhiBoLessonStudentDao.groupCount((Map)countCondition, "open_id", "lesson_id", true, Integer.class);
            if (resutlMap != null && resutlMapDone.size() > 0) {
                resutlMap.putAll(resutlMapDone);
            }
        }
        return resutlMap;
    }

    @Override
    public List<TxVZhiBoLessonStudent> getAllByLessonId(Integer lessonId) {
        return this.txVZhiBoLessonStudentDao.getAllByLessonId(lessonId);
    }

    @Override
    public TxVZhiBoLessonStudent getByOpenId(String openId, Integer lessonId) {
        TxVZhiBoLessonStudent data = this.txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
        return data;
    }

    @Override
    public void saveStudent(TxVZhiBoLessonStudent student) {
        this.txVZhiBoLessonStudentDao.saveOrUpdate((Object)student, new String[0]);
    }

    @Override
    public long getStudentCountbyLessonId(Integer lessonId, int status) {
        if (lessonId == null) {
            return 0L;
        }
        if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == status) {
            return this.redisTemplate.opsForSet().size((Object)(RedisKeyEnums.VZB.STUDENT_COUNT_PREFFIX.getRedisKey() + lessonId));
        }
        List openIdList = this.txVZhiBoLessonStudentDao.queryStudentOpenIdByLessonId(lessonId);
        if (CollectionUtils.isEmpty((Collection)openIdList)) {
            return 0L;
        }
        HashSet openIdSet = new HashSet();
        openIdSet.addAll(openIdList);
        return openIdSet.size();
    }

    @Override
    public long entryLesson(Integer lessonId, String openid) {
        if (lessonId == null) {
            return 0L;
        }
        TxVZhiBoLesson lesson = this.txVZhiBoLessonService.getById(lessonId.intValue());
        if (lesson == null) {
            return 0L;
        }
        if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == lesson.getStatus().intValue()) {
            String redisKey = RedisKeyEnums.VZB.STUDENT_COUNT_PREFFIX.getRedisKey() + lessonId;
            Set openIds = this.redisTemplate.opsForSet().members((Object)redisKey);
            if (CollectionUtils.isEmpty((Collection)openIds)) {
                log.debug("[entryLesson]key:{},members is empty!", (Object)redisKey);
                List openIdList = this.txVZhiBoLessonStudentDao.queryStudentOpenIdByLessonId(lessonId);
                if (CollectionUtils.isEmpty((Collection)openIdList)) {
                    return 0L;
                }
                log.debug("[entryLesson]openIdList:{}", (Object)openIdList);
                openIds.addAll(openIdList);
                long result = this.redisTemplate.opsForSet().add((Object)redisKey, (Object[])openIds.toArray(new String[openIds.size()]));
                log.debug("[entryLesson]result:{}", (Object)result);
                Calendar calendar = Calendar.getInstance();
                if (lesson.getStartTime() != null) {
                    calendar.setTimeInMillis(lesson.getStartTime().getTime());
                } else {
                    calendar.setTimeInMillis(System.currentTimeMillis());
                }
                calendar.add(5, 7);
                calendar.add(11, 2);
                boolean flag = this.redisTemplate.expireAt((Object)redisKey, calendar.getTime());
                log.debug("[entryLesson]expireAt:{}", (Object)flag);
            }
            if (StringUtils.isBlank((CharSequence)openid) || openIds.contains(openid)) {
                return openIds.size();
            }
            this.redisTemplate.opsForSet().add((Object)redisKey, (Object[])new String[]{openid});
            return openIds.size() + 1;
        }
        return this.getStudentCountbyLessonId(lessonId, lesson.getStatus());
    }

    @Override
    public List<TxVZhiBoLessonStudent> getByLessonId(Integer lessonId, Integer lastId, Integer pageSize) {
        return this.txVZhiBoLessonStudentDao.getByLessonId(lessonId, lastId, pageSize);
    }
}

