/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoEventLogDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoEventLog;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.Constant;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoEventType;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoUserType;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoEventLogService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TxVZhiBoEventLogServiceImpl
implements TxVZhiBoEventLogService {
    @Autowired
    private TxVZhiBoEventLogDao txVZhiBoEventLogDao;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Override
    public void saveEvent(int lessonId, int uId, TxVZhiBoUserType userType, TxVZhiBoEventType eventType) {
        TxVZhiBoEventLog eventLog = new TxVZhiBoEventLog();
        eventLog.setCreateTime(new Date());
        eventLog.setEvent(Integer.valueOf(eventType.getCode()));
        eventLog.setLessonId(Integer.valueOf(lessonId));
        eventLog.setUId(Integer.valueOf(uId));
        eventLog.setUType(Integer.valueOf(userType.getCode()));
        this.txVZhiBoEventLogDao.save((Object)eventLog, new String[0]);
    }

    @Override
    public void markEvent(Integer uId, Integer uType, Integer lessonId, String openId) {
        StringBuilder sb = new StringBuilder();
        sb.append(RedisKeyEnums.VZB.EVENT_KEY_PREFIX.getRedisKey()).append(lessonId).append("_").append(uId).append("_").append(uType).append("_").append(openId);
        final String key = sb.toString();
        this.redisTemplate.opsForList().leftPush((Object)RedisKeyEnums.VZB.EVENT_KEY.getRedisKey(), (Object)key);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setEx(key.getBytes(), Constant.TIME_OUT.longValue(), String.valueOf(System.currentTimeMillis()).getBytes());
                return true;
            }
        });
    }
}

