/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.biz.consult.user.dto.request.ConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.dto.DBResultDto;
import com.baijia.tianxiao.sal.vzhibo.constant.OrgFieldTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoEventType;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoUserType;
import com.baijia.tianxiao.sal.vzhibo.service.AudienceService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoEventLogService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonStudentService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoRoomService;
import com.baijia.tianxiao.sal.vzhibo.vo.AudienceDto;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoRoomDetailVO;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AudienceServiceImpl
implements AudienceService {
    private static final Logger log = LoggerFactory.getLogger(AudienceServiceImpl.class);
    @Autowired
    private ConsulterAPIService consultAPIService;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private TxVZhiBoLessonStudentService txVZhiBoLessonStudentService;
    @Autowired
    private ConsultUserService consultUserService;
    @Autowired
    private TxVZhiBoEventLogService txVZhiBoEventLogService;
    @Autowired
    private TxVZhiBoRoomService txVZhiBoRoomService;

    @Override
    public AudienceDto getAudienceDetail(String openId, Integer orgNumber, Integer lessonId) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountByNumber(orgNumber, new String[0]);
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        Fans fans = this.fansDao.getByOpenId(openId);
        if (fans == null) {
            try {
                TimeUnit.SECONDS.sleep(3L);
                fans = this.fansDao.getByOpenId(openId);
                if (fans == null) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u90e8\u5206\u4fe1\u606f\u52a0\u8f7d\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u5f53\u524d\u9875\u9762");
                }
            }
            catch (InterruptedException e) {
                log.error("wait fans data save to db error!", (Throwable)e);
            }
        }
        AudienceDto data = new AudienceDto();
        data.setIcon(fans.getHeadImgUrl());
        data.setOpenId(openId);
        OrgStudent orgStudent = null;
        List orgStudents = this.orgStudentDao.getStudentByOpenIdAndOrgId(Long.valueOf(orgAccount.getId().longValue()), openId, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgStudents)) {
            orgStudent = (OrgStudent)orgStudents.get(0);
        }
        if (orgStudent != null) {
            OrgStorage storage;
            data.setId(orgStudent.getId());
            data.setMobile(orgStudent.getMobile());
            data.setName(orgStudent.getName());
            data.setType(TxVZhiBoUserType.STUDENT.getCode());
            data.setMobile(orgStudent.getMobile());
            Long storageId = orgStudent.getAvatar();
            if (storageId != null && storageId > 0L && (storage = (OrgStorage)this.orgStorageDao.getById((Serializable)storageId, new String[0])) != null) {
                data.setIcon(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
            }
        }
        TxConsultUser consult = null;
        List consultUsers = this.consultUserDao.lookByWeixinOpenId(Long.valueOf(orgAccount.getId().longValue()), openId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)consultUsers)) {
            consult = new TxConsultUser();
            consult.setOrgId(Long.valueOf(orgAccount.getId().longValue()));
            consult.setWeixinOpenId(openId);
            consult.setWeixinNickName(fans.getNick());
            consult.setName(fans.getNick());
            consult.setConsultSource(Integer.valueOf(MessageSource.VZHIBO.getValue()));
            DBResultDto resultDto = this.consultAPIService.saveOrUpdateByWechatOpenId(consult);
            consult.setId(((TxConsultUser)resultDto.getData()).getId());
        } else {
            consult = (TxConsultUser)consultUsers.get(0);
        }
        if (orgStudent == null) {
            data.setId(consult.getId());
            data.setMobile(consult.getMobile());
            if (consult.getIsConsulter() != null && consult.getIsConsulter().intValue() == Flag.FALSE.getInt()) {
                data.setName(fans.getNick());
                data.setType(TxVZhiBoUserType.CONSULT.getCode());
            } else {
                data.setName(consult.getName());
                data.setType(TxVZhiBoUserType.CLUE.getCode());
            }
        }
        this.txVZhiBoEventLogService.saveEvent(lessonId, data.getId().intValue(), TxVZhiBoUserType.getUserTypeByCode(data.getType()), TxVZhiBoEventType.ENTER);
        TxVZhiBoLessonStudent txVZhiBoLessonStudent = this.txVZhiBoLessonStudentService.getByOpenId(openId, lessonId);
        if (txVZhiBoLessonStudent == null) {
            TxVZhiBoRoomDetailVO txVZhiBoRoom = this.txVZhiBoRoomService.detail(orgNumber, OrgFieldTypeEnums.NUMBER, null);
            txVZhiBoLessonStudent = new TxVZhiBoLessonStudent();
            txVZhiBoLessonStudent.setCreateTime(new Date());
            txVZhiBoLessonStudent.setLessonId(lessonId);
            txVZhiBoLessonStudent.setRoomId(txVZhiBoRoom.getId());
            txVZhiBoLessonStudent.setOpenId(openId);
            txVZhiBoLessonStudent.setUpdateTime(new Date());
            this.txVZhiBoLessonStudentService.saveStudent(txVZhiBoLessonStudent);
        }
        return data;
    }

    @Override
    public List<AudienceDto> getAllAudienceByCourseId(Integer lessonId, Integer orgId, Integer lastId, Integer pageSize, List<AudienceDto> tempData) {
        List<AudienceDto> data = this.getAudienceByLessonId(lessonId, orgId, lastId, pageSize, false, tempData);
        return data;
    }

    @Override
    public void transConsultToClue(String openId, Integer orgId, Integer cascadeAccountId) {
        List exists;
        List consultUsers = this.consultUserDao.lookByWeixinOpenId(Long.valueOf(orgId.longValue()), openId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)consultUsers)) {
            return;
        }
        TxConsultUser consultUser = (TxConsultUser)consultUsers.get(0);
        if (StringUtils.isNotBlank((CharSequence)consultUser.getMobile()) && (exists = this.consultUserDao.lookByMobile(Long.valueOf(orgId.longValue()), consultUser.getMobile(), new String[0])).size() > 1) {
            for (TxConsultUser exist : exists) {
                if (exist.getIsConsulter().intValue() != Flag.TRUE.getInt()) continue;
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6b64\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728\u4e8e\u7ebf\u7d22\u4e2d");
            }
        }
        if (cascadeAccountId != null && cascadeAccountId > 0) {
            consultUser.setCascadeId(Long.valueOf(cascadeAccountId.longValue()));
        }
        consultUser.setConsultSource(Integer.valueOf(MessageSource.VZHIBO.getValue()));
        ConsulterRequestDto consulterParam = ConsulterRequestDto.convertToRequestParam((TxConsultUser)consultUser);
        consulterParam.setStudentName(consultUser.getName());
        try {
            Long consultUserId = this.consultUserService.saveConsultUser(Long.valueOf(orgId.longValue()), consulterParam, null);
            log.info("TransConsultToClue success! openId:{},orgId:{},cascadeAccountId:{},consultUserId:{}", new Object[]{openId, orgId, cascadeAccountId, consultUserId});
        }
        catch (ParameterException e) {
            throw new BussinessException(e.getErrorCode(), e.getMessage());
        }
    }

    @Override
    public void transConsultToStudent(String openId, Integer orgId, Integer cascadeAccountId) {
        List consultUsers = this.consultUserDao.lookByWeixinOpenId(Long.valueOf(orgId.longValue()), openId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)consultUsers)) {
            return;
        }
        TxConsultUser consultUser = (TxConsultUser)consultUsers.get(0);
        try {
            cascadeAccountId = cascadeAccountId == null ? 0 : cascadeAccountId;
            Long studentId = this.consultUserService.convertToStudent(Long.valueOf(orgId.longValue()), Long.valueOf(cascadeAccountId.longValue()), consultUser.getId(), Integer.valueOf(0));
            log.info("TransConsultToStudent success! openId:{},orgId:{},cascadeAccountId:{},studentId:{}", new Object[]{openId, orgId, cascadeAccountId, studentId});
        }
        catch (ParameterException e) {
            throw new BussinessException(e.getErrorCode(), e.getMessage());
        }
    }

    @Override
    public void transClueToStudent(String openId, Integer orgId, Integer cascadeAccountId) {
        List consultUsers = this.consultUserDao.lookByWeixinOpenId(Long.valueOf(orgId.longValue()), openId, new String[0]);
        if (CollectionUtils.isEmpty((Collection)consultUsers)) {
            return;
        }
        TxConsultUser consultUser = (TxConsultUser)consultUsers.get(0);
        try {
            cascadeAccountId = cascadeAccountId == null ? 0 : cascadeAccountId;
            Long studentId = this.consultUserService.convertToStudent(Long.valueOf(orgId.longValue()), Long.valueOf(cascadeAccountId.longValue()), consultUser.getId(), Integer.valueOf(0));
            log.info("TransConsultToStudent success! openId:{},orgId:{},cascadeAccountId:{},studentId:{}", new Object[]{openId, orgId, cascadeAccountId, studentId});
        }
        catch (ParameterException e) {
            throw new BussinessException(e.getErrorCode(), e.getMessage());
        }
    }

    @Override
    public void saveConsultMobile(String openId, String mobile, Integer orgId) {
        OrgStudent orgStudent;
        TxConsultUser consultUser;
        List consultUsers = this.consultUserDao.lookByWeixinOpenId(Long.valueOf(orgId.longValue()), openId, new String[0]);
        List orgStudents = this.orgStudentDao.getStudentByOpenIdAndOrgId(Long.valueOf(orgId.longValue()), openId, new String[0]);
        mobile = mobile.replaceAll("-", "");
        if (CollectionUtils.isNotEmpty((Collection)consultUsers) && StringUtils.isBlank((CharSequence)(consultUser = (TxConsultUser)consultUsers.get(0)).getMobile())) {
            consultUser.setMobile(mobile);
            this.consultUserDao.saveOrUpdate((Object)consultUser, new String[0]);
        }
        if (CollectionUtils.isNotEmpty((Collection)orgStudents) && StringUtils.isBlank((CharSequence)(orgStudent = (OrgStudent)orgStudents.get(0)).getMobile())) {
            orgStudent.setMobile(mobile);
            this.orgStudentDao.saveOrUpdate((Object)orgStudent, new String[0]);
        }
    }

    @Override
    public List<AudienceDto> getAudienceHadMobileByCourseId(Integer lessonId, Integer orgId, Integer lastId, Integer pageSize, List<AudienceDto> tempData) {
        List<AudienceDto> data = this.getAudienceByLessonId(lessonId, orgId, lastId, pageSize, true, tempData);
        return data;
    }

    private List<AudienceDto> getAudienceByLessonId(Integer lessonId, Integer orgId, Integer lastId, Integer pageSize, boolean hasMobile, List<AudienceDto> tempData) {
        List<TxVZhiBoLessonStudent> txVZhiBoLessonStudents = this.txVZhiBoLessonStudentService.getByLessonId(lessonId, lastId, pageSize);
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(txVZhiBoLessonStudents)) {
            return list;
        }
        ArrayList openIds = Lists.newArrayList();
        HashMap lessonStudentMap = Maps.newHashMap();
        for (TxVZhiBoLessonStudent lessonStudent : txVZhiBoLessonStudents) {
            openIds.add(lessonStudent.getOpenId());
            lessonStudentMap.put(lessonStudent.getOpenId(), lessonStudent);
        }
        Map fansMap = this.fansDao.mapKeyOpenIdValueFans((List)openIds);
        Map consultUsersMap = this.consultUserDao.mapKeyOpenIdValueId(orgId, (List)openIds);
        Map studentsMap = Maps.newHashMap();
        Map mobileStudentMap = Maps.newHashMap();
        if (!consultUsersMap.isEmpty()) {
            studentsMap = this.orgStudentDao.getStudentByOpenIdAndOrgIdMap(orgId, new ArrayList(consultUsersMap.keySet()));
            ArrayList mobiles = Lists.newArrayList();
            for (TxConsultUser txConsultUser : consultUsersMap.values()) {
                if (!StringUtils.isNotBlank((CharSequence)txConsultUser.getMobile())) continue;
                mobiles.add(txConsultUser.getMobile());
            }
            if (CollectionUtils.isNotEmpty((Collection)mobiles)) {
                mobileStudentMap = this.orgStudentDao.getStudentByMobilesAndOrgIdMap(orgId, (List)mobiles);
            }
        }
        for (String openId : openIds) {
            OrgStorage storage;
            Long storageId;
            AudienceDto dto = new AudienceDto();
            Fans fans = (Fans)fansMap.get(openId);
            TxConsultUser consultUser = (TxConsultUser)consultUsersMap.get(openId);
            OrgStudent student = (OrgStudent)studentsMap.get(openId);
            if (fans == null) continue;
            if (StringUtils.isNotBlank((CharSequence)fans.getHeadImgUrl())) {
                dto.setIcon(fans.getHeadImgUrl());
            } else {
                dto.setIcon(AvatarUtil.getUserAvatar((long)fans.getId().intValue()));
            }
            if (consultUser == null && student == null) continue;
            TxVZhiBoLessonStudent lessonStudent = (TxVZhiBoLessonStudent)lessonStudentMap.get(openId);
            dto.setOpenId(openId);
            dto.setId(lessonStudent.getId().longValue());
            if (student != null) {
                dto.setMobile(student.getMobile());
                dto.setName(student.getName());
                dto.setType(TxVZhiBoUserType.STUDENT.getCode());
                storageId = student.getAvatar();
                if (storageId != null && storageId > 0L && (storage = (OrgStorage)this.orgStorageDao.getById((Serializable)storageId, new String[0])) != null) {
                    dto.setIcon(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
                }
            } else if (StringUtils.isNotBlank((CharSequence)consultUser.getMobile()) && mobileStudentMap.get(consultUser.getMobile()) != null) {
                student = (OrgStudent)mobileStudentMap.get(consultUser.getMobile());
                dto.setMobile(student.getMobile());
                dto.setName(student.getName());
                dto.setType(TxVZhiBoUserType.STUDENT.getCode());
                storageId = student.getAvatar();
                if (storageId != null && storageId > 0L && (storage = (OrgStorage)this.orgStorageDao.getById((Serializable)storageId, new String[0])) != null) {
                    dto.setIcon(StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()));
                }
            } else {
                dto.setMobile(consultUser.getMobile());
                if (consultUser.getIsConsulter().intValue() == Flag.FALSE.getInt()) {
                    dto.setName(fans.getNick());
                    dto.setType(TxVZhiBoUserType.CONSULT.getCode());
                } else {
                    dto.setName(consultUser.getName());
                    dto.setType(TxVZhiBoUserType.CLUE.getCode());
                }
            }
            if (hasMobile) {
                if (!StringUtils.isNotBlank((CharSequence)dto.getMobile())) continue;
                list.add(dto);
                continue;
            }
            list.add(dto);
        }
        if (hasMobile) {
            if (tempData != null) {
                tempData.addAll(list);
                if (tempData.size() < pageSize) {
                    this.getAudienceByLessonId(lessonId, orgId, ((TxVZhiBoLessonStudent)lessonStudentMap.get(openIds.get(openIds.size() - 1))).getId(), pageSize, hasMobile, tempData);
                }
            } else if (list.size() < pageSize) {
                this.getAudienceByLessonId(lessonId, orgId, ((TxVZhiBoLessonStudent)lessonStudentMap.get(openIds.get(openIds.size() - 1))).getId(), pageSize, hasMobile, list);
            }
        }
        return list;
    }

    @Override
    public Map<String, Integer> getAudienceCountBylessonId(Integer lessonId, Integer orgId) {
        List orgStudents;
        List<TxVZhiBoLessonStudent> txVZhiBoLessonStudents = this.txVZhiBoLessonStudentService.getAllByLessonId(lessonId);
        if (CollectionUtils.isEmpty(txVZhiBoLessonStudents)) {
            return Maps.newHashMap();
        }
        ArrayList openIds = Lists.newArrayList();
        for (TxVZhiBoLessonStudent lessonStudent : txVZhiBoLessonStudents) {
            openIds.add(lessonStudent.getOpenId());
        }
        List list = this.consultUserDao.getListByOpenids(orgId, (List)openIds);
        int hasMobileCount = 0;
        ArrayList studentIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (TxConsultUser txConsultUser : list) {
                if (StringUtils.isNotBlank((CharSequence)txConsultUser.getMobile())) {
                    ++hasMobileCount;
                    continue;
                }
                if (txConsultUser.getStudentId() == null || txConsultUser.getStudentId() <= 0L) continue;
                studentIds.add(txConsultUser.getStudentId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)studentIds) && CollectionUtils.isNotEmpty((Collection)(orgStudents = this.orgStudentDao.getByIds((Collection)studentIds, new String[0])))) {
            for (OrgStudent orgStudent : orgStudents) {
                if (!StringUtils.isNotBlank((CharSequence)orgStudent.getMobile())) continue;
                ++hasMobileCount;
            }
        }
        HashMap countData = Maps.newHashMap();
        countData.put("all_audience_key", list.size());
        countData.put("has_mobile_audience_key", hasMobileCount);
        return countData;
    }
}

