/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.connect.route.api.enums.DeviceDomainEnum;
import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.vzhibo.vo.MessageVO;
import com.baijia.tianxiao.sal.vzhibo.vo.MsgInfoDto;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @title WebSocketUtil
 * @desc TODO 
 * @author he11o
 * @date 2016年11月23日
 * @version 1.0
 */
@Slf4j
public class WebSocketUtil {
    
    private static final String WS_SERVER;
    
    private static final String BIZTYPE = "tx:cccr:vzhibo";
    
    private static final String DEVICEDOMAIN = DeviceDomainEnum.MOBILE.getCode();
    
    private static final String UID_PREFIX = "vzhibo_";
    
    static{
        WS_SERVER = PropertiesReader.getValue("config", "WS_SERVER");
//        BIZTYPE = PropertiesReader.getValue("config", "BIZTYPE");
//        DEVICEDOMAIN = PropertiesReader.getValue("config", "DEVICEDOMAIN");
//        UID_PREFIX = PropertiesReader.getValue("config", "UID_PREFIX");
    }
    
    public static String sendWsMessage(MessageVO message, String deviceId) {
        Map<String,Object> map = Maps.newHashMap();
        map.put("bizType", BIZTYPE);
        map.put("deviceType", DeviceType.APP.getCode()+"");
        map.put("deviceDomain", DEVICEDOMAIN);
        map.put("uid", UID_PREFIX+message.getLessonId());
        if(deviceId != null){
        	map.put("deviceId", deviceId);
        }
        MsgInfoDto msgInfo = new MsgInfoDto();
        msgInfo.setMsgType(message.getMsgType());
        msgInfo.setContent(message);
        msgInfo.setAreaType(message.getAreaType());
        map.put("message", JacksonUtil.safeObj2Str(msgInfo));

//        log.debug("[sendWsMessage]params:{}",map);
        return HttpRetryUtil.retryPost(WS_SERVER, map);
    }
    
	public static String sendBatchWsMessage(MessageVO message, Set<Object> deviceIds) {
		Map<String, Object> map = Maps.newHashMap();
		map.put("bizType", BIZTYPE);
		map.put("deviceType", DeviceType.APP.getCode() + "");
		map.put("deviceDomain", DEVICEDOMAIN);
		map.put("uid", UID_PREFIX + message.getLessonId());
		StringBuilder deviceIdsStr = new StringBuilder();
		for(Object object : deviceIds){
			deviceIdsStr.append(object.toString()).append(",");
		}
		map.put("deviceIds", deviceIdsStr.deleteCharAt(deviceIdsStr.length()-1).toString());
		MsgInfoDto msgInfo = new MsgInfoDto();
		msgInfo.setMsgType(message.getMsgType());
		msgInfo.setContent(message);
		msgInfo.setAreaType(message.getAreaType());
		map.put("message", JacksonUtil.safeObj2Str(msgInfo));

		// log.debug("[sendWsMessage]params:{}",map);
		return HttpRetryUtil.retryPost(WS_SERVER, map);
	}
 
    /**
     * @param liveId
     * @param deviceId 学员为openid，子账号为orgid_cascadeid，主账号为orgid，游客一个随机串
     * @return
     */
    public static String getUserToken(long liveId, String deviceId){
        try {
        	PushTokenConfig token = new PushTokenConfig();
        	token.setBiz_type(BIZTYPE);
        	token.setDevice_domain(Integer.valueOf(DEVICEDOMAIN));
        	token.setDeviceId(deviceId);
        	token.setDeviceType(DeviceType.APP.getCode());
        	token.setUser_id(UID_PREFIX+liveId);
            return EncryptUtils.pushTokenEncode(token);
//            return EncryptUtils.wsEncode(BIZTYPE, UID_PREFIX+liveId, Integer.valueOf(DEVICEDOMAIN));
        } catch (Exception e) {
            log.error("error in getUserToken",e);
        }
        return null;
    } 
    
}
