/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.async.Callback;
import com.mashape.unirest.http.exceptions.UnirestException;

import lombok.extern.slf4j.Slf4j;

/**
 * @title HttpRetryUtil
 * @desc TODO
 * @author he11o
 * @date 2016年11月23日
 * @version 1.0
 */
@Slf4j
public class HttpRetryUtil {

    private static final int retry_times = 3;

    public static String retryPost(String url, Map<String, Object> map) {
        try {
            Future<HttpResponse<JsonNode>> future = Unirest.post(url).fields(map).asJsonAsync(new Callback<JsonNode>() {

                public void completed(HttpResponse<JsonNode> response) {
                    int code = response.getStatus();
                    JsonNode body = response.getBody();
                }

                public void failed(UnirestException e) {
                	log.error("send msg to cr error!", e);
                    System.out.println("The request has failed");
                }
                public void cancelled() {
                    System.out.println("The request has been cancelled");
                }
            });
        } catch (Exception e) {
        	log.error("send msg to cr error!", e);
            e.printStackTrace();
        }
        return "";
    }
}
