/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.enums.RedisKeyEnums;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonStudentService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @title TxVZhiBoLessonStudentServiceImpl
 * @desc TODO 
 * @author fubaokui
 * @date 2016年11月29日
 * @version 1.0
 */
@Slf4j
@Service
public class TxVZhiBoLessonStudentServiceImpl implements TxVZhiBoLessonStudentService {

    @Autowired
    TxVZhiBoLessonStudentDao txVZhiBoLessonStudentDao;
 
    @Autowired
    TxVZhiBoLessonService txVZhiBoLessonService;
    
    /* (non-Javadoc)
     * “直播中”的直播间，学生人数从redis取，其他的从数据库取
     */
    @Override
    public Map<Integer, Integer> statStudentCountByRoomId(Integer roomId) {
        log.info("[statStudentCountByRoomId]roomId:{}",roomId);
        Map<Integer, Integer> resutlMap = Maps.newHashMap();
        if(roomId == null){
            return resutlMap;
        }
        //1.获取直播间下面所有直播课
        List<TxVZhiBoLesson> lessons = txVZhiBoLessonService.getByRoomId(roomId);
        if(CollectionUtils.isEmpty(lessons)){
            return resutlMap;
        }
        //2.获取直播中的直播课的学生人数
        List<Long> doneLessonIds = Lists.newArrayList();
        for(TxVZhiBoLesson boLesson : lessons){
            if(TxVZhiBoLessonStatusEnums.LIVE.getCode() == boLesson.getStatus()){
                long count = getStudentCountbyLessonId(boLesson.getId().intValue(),TxVZhiBoLessonStatusEnums.LIVE.getCode());
                resutlMap.put(boLesson.getId().intValue(), (int)count);
            }else{
                doneLessonIds.add(boLesson.getId());
            }
        }
        if(CollectionUtils.isNotEmpty(doneLessonIds)){
            //3.获取直播结束的直播课的学生人数
            Map<String,Object> countCondition = Maps.newHashMap();
            countCondition.put("lessonId", doneLessonIds);
            Map<Integer, Integer> resutlMapDone =  txVZhiBoLessonStudentDao.groupCount(countCondition, "open_id", "lesson_id", true, Integer.class);
            if(resutlMap != null && resutlMapDone.size() > 0){
                resutlMap.putAll(resutlMapDone);
            }
        }
        return resutlMap;
    }
    
	@Override
	public List<TxVZhiBoLessonStudent> getAllByLessonId(Integer lessonId) {
		return txVZhiBoLessonStudentDao.getAllByLessonId(lessonId);
	}

	@Override
	public TxVZhiBoLessonStudent getByOpenId(String openId, Integer lessonId) {
		TxVZhiBoLessonStudent data = txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
		return data;
	}

	@Override
	public void saveStudent(TxVZhiBoLessonStudent student) {
		txVZhiBoLessonStudentDao.saveOrUpdate(student);
	}
	
	@Autowired
	RedisTemplate<String, String> redisTemplate;
	
    @Override
    public long getStudentCountbyLessonId(Integer lessonId,int status) {
        //直播中的取redis，直播结束的取数据库
        if(lessonId == null){
            return 0;
        }
        //直播中的，进入redis
        if(TxVZhiBoLessonStatusEnums.LIVE.getCode() == status){
            return redisTemplate.opsForSet().size(RedisKeyEnums.VZB.STUDENT_COUNT_PREFFIX.getRedisKey() + lessonId);
        }else{
            List<String> openIdList = txVZhiBoLessonStudentDao.queryStudentOpenIdByLessonId(lessonId);
            if(CollectionUtils.isEmpty(openIdList)){
                return 0;
            }
            Set<String> openIdSet = new HashSet<String>(); 
            openIdSet.addAll(openIdList);
            return openIdSet.size();
        }
    }
    
    @Override
    public long entryLesson(Integer lessonId,String openid){
        if(lessonId == null){
            return 0;
        }
        TxVZhiBoLesson lesson = txVZhiBoLessonService.getById(lessonId);
        if(lesson == null){
            return 0;
        }
        //直播中的，进入redis
        if(TxVZhiBoLessonStatusEnums.LIVE.getCode() == lesson.getStatus()){
            String redisKey = RedisKeyEnums.VZB.STUDENT_COUNT_PREFFIX.getRedisKey() + lessonId;
            Set<String> openIds = redisTemplate.opsForSet().members(redisKey);
            if(CollectionUtils.isEmpty(openIds)){
                log.debug("[entryLesson]key:{},members is empty!",redisKey);
                //redis重启后数据可能丢失，需要从数据库同步一下数据
                List<String> openIdList = txVZhiBoLessonStudentDao.queryStudentOpenIdByLessonId(lessonId);
                if(CollectionUtils.isEmpty(openIdList)){
                    return 0;
                }
                log.debug("[entryLesson]openIdList:{}",openIdList);
                openIds.addAll(openIdList);
                long result = redisTemplate.opsForSet().add(redisKey, openIds.toArray(new String[openIds.size()]));
                log.debug("[entryLesson]result:{}",result);
                //当openIds为空时，为key设置过期时间
                Calendar calendar = Calendar.getInstance();
                if(lesson.getStartTime() != null){
                    calendar.setTimeInMillis(lesson.getStartTime().getTime());
                }else{
                    calendar.setTimeInMillis(System.currentTimeMillis());
                }
                calendar.add(Calendar.DAY_OF_MONTH, 7);
                calendar.add(Calendar.HOUR_OF_DAY, 2);
                boolean flag= redisTemplate.expireAt(redisKey, calendar.getTime());
                log.debug("[entryLesson]expireAt:{}",flag);
            }
            if(StringUtils.isBlank(openid) || openIds.contains(openid)){
                return openIds.size();
            }else{
                redisTemplate.opsForSet().add(redisKey, openid);
                return openIds.size() + 1;
            }
        }else{
            return getStudentCountbyLessonId(lessonId,lesson.getStatus());
        }
    }

	@Override
	public List<TxVZhiBoLessonStudent> getByLessonId(Integer lessonId, Integer lastId, Integer pageSize) {
		return txVZhiBoLessonStudentDao.getByLessonId(lessonId,lastId,pageSize);
	}

	
}
