package com.baijia.tianxiao.sal.vzhibo.service.impl;

import java.util.Date;

import com.baijia.tianxiao.enums.RedisKeyEnums;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoEventLogDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoEventLog;
import com.baijia.tianxiao.sal.vzhibo.constant.Constant;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoEventType;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoUserType;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoEventLogService;

@Service
public class TxVZhiBoEventLogServiceImpl implements TxVZhiBoEventLogService {

	@Autowired
	private TxVZhiBoEventLogDao txVZhiBoEventLogDao;
	@Autowired
	private StringRedisTemplate redisTemplate;

	@Override
	public void saveEvent(int lessonId, int uId, TxVZhiBoUserType userType, TxVZhiBoEventType eventType) {
		TxVZhiBoEventLog eventLog = new TxVZhiBoEventLog();
		eventLog.setCreateTime(new Date());
		eventLog.setEvent(eventType.getCode());
		eventLog.setLessonId(lessonId);
		eventLog.setUId(uId);
		eventLog.setUType(userType.getCode());
		txVZhiBoEventLogDao.save(eventLog);
	}

	@Override
	public void markEvent(final Integer uId, final Integer uType, final Integer lessonId, final String openId) {
		StringBuilder sb = new StringBuilder();
		sb.append(RedisKeyEnums.VZB.EVENT_KEY_PREFIX.getRedisKey()).append(lessonId).append(Constant.EVENT_KEY_SEP).append(uId).append(Constant.EVENT_KEY_SEP)
				.append(uType).append(Constant.EVENT_KEY_SEP).append(openId);
		final String key = sb.toString();
		redisTemplate.opsForList().leftPush(RedisKeyEnums.VZB.EVENT_KEY.getRedisKey(), key);
		redisTemplate.execute(new RedisCallback<Boolean>() {

			@Override
			public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
				connection.setEx(key.getBytes(), Constant.TIME_OUT, String.valueOf(System.currentTimeMillis()).getBytes());
				return true;
			}
		});
	}

}
