/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.constant;

/**
 * @title ContentTypeEnums
 * @desc 文件类型
 * @author he11o
 * @date 2016年6月1日
 * @version 1.0
 */
public enum FileTypeEnums {
    PIC(1, "png"),
    VOICE(2, "mp3"); //

    private int code;

    private String name;

    FileTypeEnums(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static final FileTypeEnums parse(Integer code) {
        if (null == code) {
            return null;
        }
        for (FileTypeEnums enums : FileTypeEnums.values()) {
            if (enums.getCode() == code) {
                return enums;
            }
        }
        return null;
    }

}
