/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.constant;

import com.baijia.tianxiao.enums.RedisKeyEnums;

/**
 * @title ContentTypeEnums
 * @desc 文件类型
 * @author he11o
 * @date 2016年6月1日
 * @version 1.0
 */
public enum AreaTypeEnums {
    ZHIBO(0, RedisKeyEnums.VZB.ZHIBO.getRedisKey()),   //主播区域
    DISCUSS(1,RedisKeyEnums.VZB.DISCUSS.getRedisKey()); //讨论区

    private String prefix;
    
    private int code;

    AreaTypeEnums(int code,String prefix) {
        this.code = code;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public static final AreaTypeEnums parse(Integer code) {
        if (null == code) {
            return null;
        }
        for (AreaTypeEnums enums : AreaTypeEnums.values()) {
            if (enums.getCode() == code) {
                return enums;
            }
        }
        return null;
    }

}
