/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title MessageVO
 * @desc 消息包装类 
 * @author he11o
 * @date 2016年11月25日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class MessageVO  implements MsgContent {

    private Long id;

    private String uniqueId;
    
    private Integer lessonId;    //直播间id
    
    private String openId;  //TODO 微信
    
    private Long studentId; //天校学员id
    
    private int msgType;    //消息类型 ，文本、图片 or 语音
    
    private int areaType;   //消息区域，直播区 or 讨论区
    
    private String content; //消息内容，文本 or url

    private UploadInfo file;
    
    private long createTime;
    
    private String nickname;//消息发送者的昵称
    
    private String avatar;  //消息发送者的头像
    
    private long studentCount = 0;
    
}
