/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.vo;

import java.io.IOException;

import org.apache.commons.lang3.StringUtils;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.sal.vzhibo.constant.AreaTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.MessageTypeEnums;

import lombok.extern.slf4j.Slf4j;

/**
 * @title UploadInfo
 * @desc TODO 
 * @author he11o
 * @date 2016年11月22日
 * @version 1.0
 */
@Slf4j
public class MessageInfo {

    private Integer lessonId;       //直播课id
    
    private Long studentId;     //学员id
    
    private String openId;        //微信openid
    
    private Integer msgType = MessageTypeEnums.TEXT.getCode();    //消息类型
    
    private Integer areaType = AreaTypeEnums.DISCUSS.getCode();   //消息区域类型
    
    private String content;     //消息类型为文本消息时的内容

    private String file;
    
    private Integer orgId;          //机构id
    
    private Integer txCascadeId;    //子账号id

    @Override
    public String toString() {
        return "MessageInfo [lessonId=" + lessonId + ", studentId=" + studentId + ", openId=" + openId + ", msgType="
            + msgType + ", areaType=" + areaType + ", content=" + content + ", file=" + file + ", orgId=" + orgId
            + ", txCascadeId=" + txCascadeId + "]";
    }

    public Integer getLessonId() {
        return lessonId;
    }

    public void setLessonId(Integer lessonId) {
        this.lessonId = lessonId;
    }

    public Long getStudentId() {
        return studentId;
    }

    public void setStudentId(Long studentId) {
        this.studentId = studentId;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public Integer getMsgType() {
        return msgType;
    }

    public void setMsgType(Integer msgType) {
        this.msgType = msgType;
    }

    public Integer getAreaType() {
        return areaType;
    }

    public void setAreaType(Integer areaType) {
        this.areaType = areaType;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public UploadInfo getFile() {
        if(StringUtils.isNoneBlank(file)){
            try {
                return JacksonUtil.str2Obj(file, UploadInfo.class);
            } catch (IOException e) {
                log.warn("Error in str2Obj",e);
            }
        }
        return null;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Integer getOrgId() {
        return orgId;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public Integer getTxCascadeId() {
        return txCascadeId;
    }

    public void setTxCascadeId(Integer txCascadeId) {
        this.txCascadeId = txCascadeId;
    }
    
    public boolean isValidate(){
        if(MessageTypeEnums.TEXT.getCode() == this.msgType){
            String textMaxLengthConfig = PropertiesReader.getValue("config-common", "text_max_length");
            int textMaxLength = 1000;
            if(StringUtils.isNoneBlank(textMaxLengthConfig)){
                textMaxLength = Integer.parseInt(textMaxLengthConfig);
            }
            if(StringUtils.isBlank(content) || (content.length() > textMaxLength)){
                return false;
            }
        }
        return true;
    }
    
}
