package com.baijia.tianxiao.sal.vzhibo.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.consult.user.dto.request.ConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.image.AvatarUtil;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.dto.DBResultDto;
import com.baijia.tianxiao.sal.vzhibo.constant.Constant;
import com.baijia.tianxiao.sal.vzhibo.constant.OrgFieldTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoEventType;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoUserType;
import com.baijia.tianxiao.sal.vzhibo.service.AudienceService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoEventLogService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonStudentService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoRoomService;
import com.baijia.tianxiao.sal.vzhibo.vo.AudienceDto;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoRoomDetailVO;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class AudienceServiceImpl implements AudienceService {

	@Autowired
	private ConsulterAPIService consultAPIService;
	@Autowired
	private TxConsultUserDao consultUserDao;
	@Autowired
	private FansDao fansDao;
	@Autowired
	private OrgAccountDao orgAccountDao;
	@Autowired
	private OrgStudentDao orgStudentDao;
	@Autowired
	private OrgStorageDao orgStorageDao;
	@Autowired
	private TxVZhiBoLessonStudentService txVZhiBoLessonStudentService;
	@Autowired
	private ConsultUserService consultUserService;
	@Autowired
	private TxVZhiBoEventLogService txVZhiBoEventLogService;
	@Autowired
	private TxVZhiBoRoomService txVZhiBoRoomService;

	@Override
	public AudienceDto getAudienceDetail(String openId, Integer orgNumber, Integer lessonId) {
		OrgAccount orgAccount = orgAccountDao.getAccountByNumber(orgNumber);
		if (orgAccount == null) {
			throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "账号不存在");
		}
		Fans fans = fansDao.getByOpenId(openId);
		if (fans == null) {
			try {
				TimeUnit.SECONDS.sleep(3L);
				fans = fansDao.getByOpenId(openId);
				if (fans == null) {
					throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "部分信息加载超时，请刷新当前页面");
				}
			} catch (InterruptedException e) {
				log.error("wait fans data save to db error!", e);
			}
		}
		AudienceDto data = new AudienceDto();
		data.setIcon(fans.getHeadImgUrl());
		data.setOpenId(openId);

		OrgStudent orgStudent = null;
		// 再看是否已经是学员
		List<OrgStudent> orgStudents = orgStudentDao.getStudentByOpenIdAndOrgId(orgAccount.getId().longValue(), openId);
		if (CollectionUtils.isNotEmpty(orgStudents)) {
			orgStudent = orgStudents.get(0);
		}
		if (orgStudent != null) {
			data.setId(orgStudent.getId());
			data.setMobile(orgStudent.getMobile());
			data.setName(orgStudent.getName());
			data.setType(TxVZhiBoUserType.STUDENT.getCode());
			data.setMobile(orgStudent.getMobile());
			Long storageId = orgStudent.getAvatar();
			if (storageId != null && storageId > 0) {
				OrgStorage storage = orgStorageDao.getById(storageId);
				if (storage != null) {
					data.setIcon(StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType()));
				}
			}
		}

		// 先查是否已经是咨询,不是给初始化
		TxConsultUser consult = null;
		List<TxConsultUser> consultUsers = consultUserDao.lookByWeixinOpenId(orgAccount.getId().longValue(), openId);
		if (CollectionUtils.isEmpty(consultUsers)) {
			consult = new TxConsultUser();
			consult.setOrgId(orgAccount.getId().longValue());
			consult.setWeixinOpenId(openId);
			consult.setWeixinNickName(fans.getNick());
			consult.setName(fans.getNick());
			consult.setConsultSource(MessageSource.VZHIBO.getValue());
			DBResultDto<TxConsultUser> resultDto = consultAPIService.saveOrUpdateByWechatOpenId(consult);
			consult.setId(resultDto.getData().getId());
		} else {
			consult = consultUsers.get(0);
		}
		if (orgStudent == null) {

			// 0-不是线索 1-线索 没找到常量
			data.setId(consult.getId());
			data.setMobile(consult.getMobile());
			if (consult.getIsConsulter() != null && consult.getIsConsulter() == Flag.FALSE.getInt()) {
				data.setName(fans.getNick());
				data.setType(TxVZhiBoUserType.CONSULT.getCode());
			} else {
				data.setName(consult.getName());
				data.setType(TxVZhiBoUserType.CLUE.getCode());
			}
		}
		// 记录进入教室事件
		txVZhiBoEventLogService.saveEvent(lessonId, data.getId().intValue(),
				TxVZhiBoUserType.getUserTypeByCode(data.getType()), TxVZhiBoEventType.ENTER);
		TxVZhiBoLessonStudent txVZhiBoLessonStudent = txVZhiBoLessonStudentService.getByOpenId(openId, lessonId);
		if (txVZhiBoLessonStudent == null) {
			TxVZhiBoRoomDetailVO txVZhiBoRoom = txVZhiBoRoomService.detail(orgNumber, OrgFieldTypeEnums.NUMBER, null);
			txVZhiBoLessonStudent = new TxVZhiBoLessonStudent();
			txVZhiBoLessonStudent.setCreateTime(new Date());
			txVZhiBoLessonStudent.setLessonId(lessonId);
			txVZhiBoLessonStudent.setRoomId(txVZhiBoRoom.getId());
			txVZhiBoLessonStudent.setOpenId(openId);
			txVZhiBoLessonStudent.setUpdateTime(new Date());
			txVZhiBoLessonStudentService.saveStudent(txVZhiBoLessonStudent);
		}
		return data;
	}

	@Override
	public List<AudienceDto> getAllAudienceByCourseId(Integer lessonId, Integer orgId, Integer lastId, Integer pageSize,
			List<AudienceDto> tempData) {
		List<AudienceDto> data = getAudienceByLessonId(lessonId, orgId, lastId, pageSize, false, tempData);
		return data;
	}

	@Override
	public void transConsultToClue(String openId, Integer orgId, Integer cascadeAccountId) {
		List<TxConsultUser> consultUsers = consultUserDao.lookByWeixinOpenId(orgId.longValue(), openId);
		if (CollectionUtils.isEmpty(consultUsers)) {
			return;
		}
		TxConsultUser consultUser = consultUsers.get(0);
		if (StringUtils.isNotBlank(consultUser.getMobile())) {
			List<TxConsultUser> exists = consultUserDao.lookByMobile(orgId.longValue(), consultUser.getMobile());
			if (exists.size() > 1) {
				for (TxConsultUser exist : exists) {
					if (exist.getIsConsulter() == Flag.TRUE.getInt()) {
						throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "此手机号已经存在于线索中");
					}
				}
			}

		}
		if (cascadeAccountId != null && cascadeAccountId > 0) {
			consultUser.setCascadeId(cascadeAccountId.longValue());
		}
		consultUser.setConsultSource(MessageSource.VZHIBO.getValue());
		ConsulterRequestDto consulterParam = ConsulterRequestDto.convertToRequestParam(consultUser);
		consulterParam.setStudentName(consultUser.getName());
		try {
			Long consultUserId = consultUserService.saveConsultUser(orgId.longValue(), consulterParam, null);
			log.info("TransConsultToClue success! openId:{},orgId:{},cascadeAccountId:{},consultUserId:{}", openId,
					orgId, cascadeAccountId, consultUserId);
			;
		} catch (ParameterException e) {
			throw new BussinessException(e.getErrorCode(), e.getMessage());
		}
	}

	@Override
	public void transConsultToStudent(String openId, Integer orgId, Integer cascadeAccountId) {
		List<TxConsultUser> consultUsers = consultUserDao.lookByWeixinOpenId(orgId.longValue(), openId);
		if (CollectionUtils.isEmpty(consultUsers)) {
			return;
		}
		TxConsultUser consultUser = consultUsers.get(0);
		try {
			cascadeAccountId = cascadeAccountId == null ? 0 : cascadeAccountId;
			// 参数说明见
			// http://git.baijiahulian.com/yunying/tianxiao/wikis/consulter/convert
			Long studentId = consultUserService.convertToStudent(orgId.longValue(), cascadeAccountId.longValue(),
					consultUser.getId(), 0);
			log.info("TransConsultToStudent success! openId:{},orgId:{},cascadeAccountId:{},studentId:{}", openId,
					orgId, cascadeAccountId, studentId);
		} catch (ParameterException e) {
			throw new BussinessException(e.getErrorCode(), e.getMessage());
		}

	}

	@Override
	public void transClueToStudent(String openId, Integer orgId, Integer cascadeAccountId) {
		List<TxConsultUser> consultUsers = consultUserDao.lookByWeixinOpenId(orgId.longValue(), openId);
		if (CollectionUtils.isEmpty(consultUsers)) {
			return;
		}
		TxConsultUser consultUser = consultUsers.get(0);
		try {
			cascadeAccountId = cascadeAccountId == null ? 0 : cascadeAccountId;
			// 参数说明见
			// http://git.baijiahulian.com/yunying/tianxiao/wikis/consulter/convert
			Long studentId = consultUserService.convertToStudent(orgId.longValue(), cascadeAccountId.longValue(),
					consultUser.getId(), 0);
			log.info("TransConsultToStudent success! openId:{},orgId:{},cascadeAccountId:{},studentId:{}", openId,
					orgId, cascadeAccountId, studentId);
		} catch (ParameterException e) {
			throw new BussinessException(e.getErrorCode(), e.getMessage());
		}
	}

	@Override
	public void saveConsultMobile(String openId, String mobile, Integer orgId) {
		List<TxConsultUser> consultUsers = consultUserDao.lookByWeixinOpenId(orgId.longValue(), openId);
		List<OrgStudent> orgStudents = orgStudentDao.getStudentByOpenIdAndOrgId(orgId.longValue(), openId);
		mobile = mobile.replaceAll("-", "");
		if (CollectionUtils.isNotEmpty(consultUsers)) {
			TxConsultUser consultUser = consultUsers.get(0);
			if (StringUtils.isBlank(consultUser.getMobile())) {
				consultUser.setMobile(mobile);
				consultUserDao.saveOrUpdate(consultUser);
			}
		}
		if (CollectionUtils.isNotEmpty(orgStudents)) {
			OrgStudent orgStudent = orgStudents.get(0);
			if (StringUtils.isBlank(orgStudent.getMobile())) {
				orgStudent.setMobile(mobile);
				orgStudentDao.saveOrUpdate(orgStudent);
			}
		}
	}

	@Override
	public List<AudienceDto> getAudienceHadMobileByCourseId(Integer lessonId, Integer orgId, Integer lastId,
			Integer pageSize, List<AudienceDto> tempData) {
		List<AudienceDto> data = getAudienceByLessonId(lessonId, orgId, lastId, pageSize, true, tempData);
		return data;
	}

	private List<AudienceDto> getAudienceByLessonId(Integer lessonId, Integer orgId, Integer lastId, Integer pageSize,
			boolean hasMobile, List<AudienceDto> tempData) {

		List<TxVZhiBoLessonStudent> txVZhiBoLessonStudents = txVZhiBoLessonStudentService.getByLessonId(lessonId,
				lastId, pageSize);
		List<AudienceDto> list = Lists.newArrayList();
		if (CollectionUtils.isEmpty(txVZhiBoLessonStudents)) {
			return list;
		}
		
		List<String> openIds = Lists.newArrayList();
		Map<String, TxVZhiBoLessonStudent> lessonStudentMap = Maps.newHashMap();
		for (TxVZhiBoLessonStudent lessonStudent : txVZhiBoLessonStudents) {
			openIds.add(lessonStudent.getOpenId());
			lessonStudentMap.put(lessonStudent.getOpenId(), lessonStudent);
		}
		Map<String, Fans> fansMap = fansDao.mapKeyOpenIdValueFans(openIds);
		Map<String, TxConsultUser> consultUsersMap = consultUserDao.mapKeyOpenIdValueId(orgId, openIds);

		Map<String, OrgStudent> studentsMap = Maps.newHashMap();
		Map<String, OrgStudent> mobileStudentMap = Maps.newHashMap();

		if (!consultUsersMap.isEmpty()) {
			studentsMap = orgStudentDao.getStudentByOpenIdAndOrgIdMap(orgId,
					new ArrayList<String>(consultUsersMap.keySet()));
			List<String> mobiles = Lists.newArrayList();
			for (TxConsultUser txConsultUser : consultUsersMap.values()) {
				if (StringUtils.isNotBlank(txConsultUser.getMobile())) {
					mobiles.add(txConsultUser.getMobile());
				}
			}
			if (CollectionUtils.isNotEmpty(mobiles)) {
				mobileStudentMap = orgStudentDao.getStudentByMobilesAndOrgIdMap(orgId, mobiles);
			}
		}
		for (String openId : openIds) {
			AudienceDto dto = new AudienceDto();
			Fans fans = fansMap.get(openId);
			TxConsultUser consultUser = consultUsersMap.get(openId);
			OrgStudent student = studentsMap.get(openId);
			if (fans == null) {
				continue;
			}
			if (StringUtils.isNotBlank(fans.getHeadImgUrl())) {
				dto.setIcon(fans.getHeadImgUrl());
			} else {
				dto.setIcon(AvatarUtil.getUserAvatar(fans.getId()));
			}
			if (consultUser == null && student == null) {
				continue;
			}
			TxVZhiBoLessonStudent lessonStudent = lessonStudentMap.get(openId);
			dto.setOpenId(openId);
			dto.setId(lessonStudent.getId().longValue());
			if (student != null) {
				dto.setMobile(student.getMobile());
				dto.setName(student.getName());
				dto.setType(TxVZhiBoUserType.STUDENT.getCode());
				Long storageId = student.getAvatar();
				if (storageId != null && storageId > 0) {
					OrgStorage storage = orgStorageDao.getById(storageId);
					if (storage != null) {
						dto.setIcon(StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType()));
					}
				}
			} else {
				if (StringUtils.isNotBlank(consultUser.getMobile())
						&& mobileStudentMap.get(consultUser.getMobile()) != null) {
					student = mobileStudentMap.get(consultUser.getMobile());
					dto.setMobile(student.getMobile());
					dto.setName(student.getName());
					dto.setType(TxVZhiBoUserType.STUDENT.getCode());
					Long storageId = student.getAvatar();
					if (storageId != null && storageId > 0) {
						OrgStorage storage = orgStorageDao.getById(storageId);
						if (storage != null) {
							dto.setIcon(
									StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType()));
						}
					}
				} else {
					dto.setMobile(consultUser.getMobile());
					if (consultUser.getIsConsulter() == Flag.FALSE.getInt()) {
						dto.setName(fans.getNick());
						dto.setType(TxVZhiBoUserType.CONSULT.getCode());
					} else {
						dto.setName(consultUser.getName());
						dto.setType(TxVZhiBoUserType.CLUE.getCode());
					}
				}
			}
			if (hasMobile) {
				if (StringUtils.isNotBlank(dto.getMobile())) {
					list.add(dto);
				}
			} else {
				list.add(dto);
			}
		}
		// 如果是取有手机号的，则需要凑足pageSize
		if (hasMobile) {
			// 递归过来的
			if (tempData != null) {
				tempData.addAll(list);
				if (tempData.size() < pageSize) {
					getAudienceByLessonId(lessonId, orgId,
							lessonStudentMap.get(openIds.get(openIds.size() - 1)).getId(), pageSize, hasMobile,
							tempData);
				}
			} else {
				// 第一次
				if (list.size() < pageSize) {
					getAudienceByLessonId(lessonId, orgId,
							lessonStudentMap.get(openIds.get(openIds.size() - 1)).getId(), pageSize, hasMobile, list);
				}
			}
		}
		return list;
	}

	@Override
	public Map<String, Integer> getAudienceCountBylessonId(Integer lessonId, Integer orgId) {
		List<TxVZhiBoLessonStudent> txVZhiBoLessonStudents = txVZhiBoLessonStudentService.getAllByLessonId(lessonId);
		if (CollectionUtils.isEmpty(txVZhiBoLessonStudents)) {
			return Maps.newHashMap();
		}
		List<String> openIds = Lists.newArrayList();
		for (TxVZhiBoLessonStudent lessonStudent : txVZhiBoLessonStudents) {
			openIds.add(lessonStudent.getOpenId());
		}
		List<TxConsultUser> list = consultUserDao.getListByOpenids(orgId, openIds);
		int hasMobileCount = 0;
		List<Long> studentIds = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(list)) {
			for (TxConsultUser txConsultUser : list) {
				if (StringUtils.isNotBlank(txConsultUser.getMobile())) {
					hasMobileCount++;
				} else {
					// 查虽然没有mobile，但有studentid，看学生是否有手机号，我日他day啊
					if (txConsultUser.getStudentId() != null && txConsultUser.getStudentId() > 0) {
						studentIds.add(txConsultUser.getStudentId());
					}
				}
			}
		}
		if (CollectionUtils.isNotEmpty(studentIds)) {
			List<OrgStudent> orgStudents = orgStudentDao.getByIds(studentIds);
			if (CollectionUtils.isNotEmpty(orgStudents)) {
				for (OrgStudent orgStudent : orgStudents) {
					if (StringUtils.isNotBlank(orgStudent.getMobile())) {
						hasMobileCount++;
					}
				}
			}
		}
		Map<String, Integer> countData = Maps.newHashMap();
		countData.put(Constant.ALL_AUDIENCE_KEY, list.size());
		countData.put(Constant.HAS_MOBILE_AUDIENCE_KEY, hasMobileCount);
		return countData;
	}
}
