/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.service;

import java.util.List;
import java.util.Set;

import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoMessage;
import com.baijia.tianxiao.sal.vzhibo.vo.MessageInfo;
import com.baijia.tianxiao.sal.vzhibo.vo.MessageListVO;
import com.baijia.tianxiao.sal.vzhibo.vo.MessageVO;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * @title MessageService
 * @desc TODO 
 * @author he11o
 * @date 2016年11月23日
 * @version 1.0
 */
public interface TxVZhiBoMessageService {

    String send(MessageInfo messageInfo, Set<Object> deviceIds) throws Exception;

    /**
     * 获取直播消息
     * @param lessonId 直播课id
     * @param index    基准消息的pos
     * @param count    要获取的消息数量
     * @param areaType 消息发布的区域
     * @param order    方式,0(正序)index,index+count,1(逆序)index-count,count
     * @return
     */
    MessageListVO get(long lessonId, long index, long count, int areaType, int order);

    /**
     * 获取最新的count条消息消息
     * @param lessonId
     * @param parseInt
     * @param count
     * @return
     */
    MessageListVO latest(long lessonId, int parseInt, int count);

    /**
     * 
     * @param liveId
     * @param areaType
     * @param pageDto
     * @return
     */
    List<TxVZhiBoMessage> pagingByLessonIdAndAreaType(Long liveId, int areaType, PageDto pageDto);
    
    int getCountByLessonIdAndAreaType(Long liveId, int areaType);

    /**
     * 批量持久化message
     * @param messagesList
     */
    void batchSave(List<MessageVO> messagesList);

    /**
     * 直播课回访获取消息接口
     * @param lessonId  直播课id
     * @param id        起始消息id
     * @param count     获取消息数量
     * @param areaType  消息区域
     * @return
     */
    List<MessageVO> history(long lessonId, long id, int count, int areaType);

    /**
     * 获取建立长链接的token
     * @param lessonId      直播间id
     * @param txCascadeId   子账号id
     * @param orgId         机构id    
     * @return
     */
    String getCCUrl(Integer lessonId, Integer txCascadeId, Integer orgId, String deviceId);

    /**
     * 消息频控，true：可以发消息，false:不能发送消息，时间间隔在频控范围内
     * @param openid
     * @return
     */
    boolean visitFrequentCheck(String openid);

    /**
     * 持久化redis消息
     * @param lessonId
     * @return
     */
    int persistMessage(int lessonId);
    
    /**
     * 通过uniqueId获取历史消息
     * @param lessonId
     * @param uniqueId
     * @param count
     * @param areaType
     * @return
     */
    List<MessageVO> historyByUniqueId(Integer lessonId, String uniqueId, Integer count, Integer areaType);

    TxVZhiBoMessage getByUniqueId(String uniqueId);

    List<MessageVO> history(Long lessonId, Long id, Integer count, Integer areaType, Integer order);

    List<MessageVO> historyByUniqueId(Long lessonId, String uniqueId, Integer count, Integer areaType, Integer order);
    
}

