/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.service;

import java.util.List;
import java.util.Map;

import org.apache.xmlbeans.UserType;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.vzhibo.constant.UserTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.vo.FieldUpdateVO;
import com.baijia.tianxiao.sal.vzhibo.vo.LessonDetailVO;
import com.baijia.tianxiao.sal.vzhibo.vo.ListRequestDto;
import com.baijia.tianxiao.sal.vzhibo.vo.ShareDataVO;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoLessonListVO;


/**
 * @title LiveService
 * @desc 直播间service 
 * @author he11o
 * @date 2016年11月25日
 * @version 1.0
 */
@Service
public interface TxVZhiBoLessonService{

    /**
     * 获取直播课授权url
     * @param orgId 机构id
     * @param redirectUrl 回调url
     * @return 直播课授权url
     */
    public String getLiveLessonUrl(Integer orgId, Integer lessonId);
 
    /**
     * 获取当前用户创建的直播课列表
     * @param roomId 直播间id
     * @param status 
     * @param dto   分页
     * @return
     */
    public List<TxVZhiBoLessonListVO> list(Integer roomId, Integer ownerId, int status, ListRequestDto dto);
    
    /**
     * 获取其他老师创建的直播课列表
     * @param roomId 直播间id
     * @param status 
     * @param dto   分页
     * @return
     */
    public List<TxVZhiBoLessonListVO> listOthers(Integer roomId, Integer ownerId, int status, ListRequestDto dto);

    /**
     * 创建直播课
     * @param orgId 机构id
     * @param txCascadeId   老师id
     * @param lessonCreateRequest   创建参数
     * @return PK 
     */
    public Long create(Integer orgId, Integer txCascadeId, TxVZhiBoLesson txVZhiBoLesson);

    /**
     * 获取直播间的结束时间，毫秒
     * @param lessonId
     * @param timeUnit
     * @return
     */
    public long getExpireTime(Integer lessonId);

    /**
     * 根据机构id,id获取直播课
     * @param orgId
     * @param lessonId
     * @return
     */
    public TxVZhiBoLesson getByOrgIdAndId(Integer orgId, int lessonId);

    /**
     * 结束直播课
     * @param orgId     机构id
     * @param lessonId  直播课id
     * @param i 
     * @return
     */
    public boolean end(Integer orgId, Integer tXCascadeId, int lessonId);

    /**
     * 通过主键获取直播课
     * @param lessonId
     * @return
     */
    public TxVZhiBoLesson getById(long lessonId);

    /**
     * 更新直播间的状态，
     * if : startTime + 7days + 2hours <= cunrrentTime;
     *     即：startTime <= cunrrentTime - 7days - 2hours;
     * 设置为"直播结束"
     * @return
     */
    public int syncLessonStatus();

    /**
     * 获取直播课分享数据
     * @param lessonId
     * @return
     */
    public ShareDataVO getShareData(int lessonId);

    /**
     * 获取直播课详细信息
     * @param lessonId
     * @return
     * @throws Exception 
     * @throws NumberFormatException 
     * @throws BussinessException 
     */
    public LessonDetailVO getDetailById(Integer lessonId) throws BussinessException, NumberFormatException, Exception;

    /**
     * 按字段更新直播间
     * @param orgId
     * @param updateVO
     * @return
     */
    public int update(Integer orgId, FieldUpdateVO updateVO);

    /**
     * 获取所有直播间列表
     * @param roomId
     * @param ownerId
     * @param lessonListType
     * @return
     */
    public Map<String, List<TxVZhiBoLessonListVO>> listAll(Integer roomId, Integer ownerId, int lessonListType);

    /**
     * 直播课简介url
     * @param id
     * @return
     */
    public String getDetailUrl(Long id);

    /**
     * 获取直播课状态
     * @param lessonId
     * @return
     */
    public int checkLessonStatus(long lessonId);

    /**
     * 删除直播课
     * @param orgId
     * @param parseInt
     * @return
     */
    boolean delete(Integer orgId, Integer txCascadeId, int lessonId);

    /**
     * 按照status统计直播间中直播课数量
     * @param roomId
     * @return
     */
    Map<String, Integer> countByStatus(Integer roomId);

    /**
     * 直播结束后移除消息列表
     * @param lessonId
     */
    void removeMessageQuque(int lessonId);

    /**
     * 检查直播课是否还可以发消息
     * @param lessonId
     * @return true-可以；false-不能再发消息啦
     */
    boolean checkLessonMessageStatus(Integer lessonId);

    /**
     * 判断当前用户角色
     * @param lessonId
     * @param orgId
     * @param txCascadeId
     * @param openId
     * @return
     */
    UserTypeEnums checkUserType(Integer lessonId, Integer orgId, Integer txCascadeId, String openId);

    /**
     * 通过直播间id,获取直播间信息，返回数据走覆盖索引仅包含直播课id，status，roomId 三个字段
     * @param roomId
     * @return
     */
    public List<TxVZhiBoLesson> getByRoomId(Integer roomId);

    public LessonDetailVO getOnlyDetailById(Integer lessonId) throws BussinessException, NumberFormatException, Exception;
}
