package com.baijia.tianxiao.sal.vzhibo.service;

import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.sal.vzhibo.vo.AudienceDto;

public interface AudienceService {

	/**
	 * 根据openId，查询当前观众身份 什么都查不到，生成咨询
	 * 
	 * @param openId
	 * @return
	 */
	public AudienceDto getAudienceDetail(String openId, Integer orgNumber, Integer lessonId);

	/**
	 * 查询直播课所有观众
	 * 
	 * @param orgId
	 * @param courseId
	 * @return
	 */
	public List<AudienceDto> getAllAudienceByCourseId(Integer lessonId, Integer orgId, Integer lastId, Integer pageSize, List<AudienceDto> tempData);

	/**
	 * 咨询转线索
	 * 
	 * @param openId
	 */
	public void transConsultToClue(String openId, Integer orgId, Integer cascadeAccountId);

	/**
	 * 咨询转学员 手机号存咨询
	 * 
	 * @param openId
	 */
	public void transConsultToStudent(String openId, Integer orgId, Integer cascadeAccountId);

	/**
	 * 线索转学员
	 * 
	 * @param openId
	 */
	public void transClueToStudent(String openId, Integer orgId, Integer cascadeAccountId);

	/**
	 * 保存匿名观众手机号
	 * 
	 * @param openId
	 * @param mobile
	 * @param orgId
	 */
	public void saveConsultMobile(String openId, String mobile, Integer orgId);

	/**
	 * 有手机号的学员 ╮(╯▽╰)╭
	 * 
	 * @param lessonId
	 * @param orgId
	 * @return
	 */
	public List<AudienceDto> getAudienceHadMobileByCourseId(Integer lessonId, Integer orgId, Integer lastId, Integer pageSize, List<AudienceDto> tempData);
	
	public Map<String, Integer> getAudienceCountBylessonId(Integer lessonId, Integer orgId);
}
