/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.constant;

/**
 * @title ContentTypeEnums
 * @desc 文件类型
 * @author he11o
 * @date 2016年6月1日
 * @version 1.0
 */
public enum UserTypeEnums {
    HACKER(-1),   //非法用户
    TEACHER(0),   //老师
    STUDENT(1),    //学生
    VISITOR(2);   //访客

    private int code;

    UserTypeEnums(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public static final UserTypeEnums parse(Integer code) {
        if (null == code) {
            return null;
        }
        for (UserTypeEnums enums : UserTypeEnums.values()) {
            if (enums.getCode() == code) {
                return enums;
            }
        }
        return null;
    }

}
