/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.constant;

/**
 * 
 * @title TxVZhiBoLessonListTypeEnums
 * @desc 获取直播课列表的类型 
 * @author fubaokui
 * @date 2016年11月29日
 * @version 1.0
 */
public enum TxVZhiBoLessonListTypeEnums {
    ALL(-1),          //所有的直播课
    OWN(0),          //我的直播课
    OTHERS(1);       //其他老师的直播课

    private int code;

    TxVZhiBoLessonListTypeEnums(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public static final TxVZhiBoLessonListTypeEnums parse(Integer code) {
        if (null == code) {
            return null;
        }
        for (TxVZhiBoLessonListTypeEnums enums : TxVZhiBoLessonListTypeEnums.values()) {
            if (enums.getCode() == code) {
                return enums;
            }
        }
        return null;
    }

}
