
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.upload.service;

import java.io.OutputStream;

import org.springframework.web.multipart.MultipartFile;

import com.baijia.tianxiao.sal.upload.dto.TaskStatus;

/**
 * @title UploadService
 * @desc TODO
 * @author cxm
 * @date 2016年3月15日
 * @version 1.0
 */
public interface CrmUploadService {
	
	/**
	 * @Description  : 下载文件模板
	 * @Author       : zhenyujian
	 * @Date         : 2016年7月9日 下午3:00:43 
	 *
	 * @Return       : void
	 */
	void downloadConsultImportTemplate(int uploadType, OutputStream os);
	
	
	
	/**
	 * @Description  : 对文件进行数据验证 
	 * @Author       : zhenyujian
	 * @Date         : 2016年7月6日 下午5:23:54 
	 *
	 * @Return       : String
	 */
	public String validateFile(final Long orgId, int uploadType, boolean override, MultipartFile file);
	
	
	/**
	 * @Description  : 下载 校验、上传结果
	 * @Author       : zhenyujian
	 * @Date         : 2016年7月7日 下午2:39:29 
	 *
	 * @Return       : String
	 */
	public void downloadVaildateResult(OutputStream os, Long orgId, String taskId);

	
	/**
	 * @Description  : 执行导入
	 * @Author       : zhenyujian
	 * @Date         : 2016年7月7日 下午4:34:20 
	 *
	 * @Return       : void
	 */
	public void doImport(Long orgId, String taskId);
	
	
	
	/**
	 * @Description  : 下载 导入结果
	 * @Author       : zhenyujian
	 * @Date         : 2016年7月7日 下午4:35:07 
	 *
	 * @Return       : void
	 */
	public void downloadImportResult(OutputStream os, Long orgId, String taskId);
	
	
	
    /**
     * 获取指定任务的执行状态
     * 
     * @param orgId
     * @param taskId
     * @return
     */
    public TaskStatus getTaskStatus(final Long orgId, final String taskId);


}
