
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package constant;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;


/**   
 * @title       : UploadType 
 * @description : 上传文件类型 
 * @author      : zhenyujian
 * @date        : 2016年7月13日 下午4:52:37 
 */
public enum DataUploadType {

    CRM_CLUE(2, "CRM 线索导入"),
    CRM_STUDENT(3, "CRM 学员导入"),
    ;

    
    
    private int type;
    private String desc;
    
    public static DataUploadType getByType(int type){
		for (DataUploadType duType : DataUploadType.values()) {
			if(duType.getType() == type){
				return duType;
			}
        }
    	return null;
    }

    private DataUploadType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
