/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.upload.service.impl;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.ExcelExporterUtils;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.upload.service.UploadFileReaderService;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUploadFileReaderServiceImpl
implements UploadFileReaderService {
    private static final Logger log = LoggerFactory.getLogger(ExcelUploadFileReaderServiceImpl.class);
    private MultipartFile excelFile;
    private int currentIndex = 1;
    private Sheet sheet;
    private Workbook wb;
    private boolean isComplete;
    private int count;
    private int headerCount;

    public ExcelUploadFileReaderServiceImpl(MultipartFile excelFile) {
        Preconditions.checkArgument((excelFile != null && !excelFile.isEmpty() ? 1 : 0) != 0, (Object)"excel file is not exist");
        this.excelFile = excelFile;
        this.initReader();
    }

    private synchronized void initReader() {
        if (this.sheet == null && !this.isComplete) {
            log.info("init to reader excel:{}", (Object)this.excelFile.getOriginalFilename());
            InputStream in = null;
            try {
                in = this.excelFile.getInputStream();
                this.wb = WorkbookFactory.create((InputStream)new PushbackInputStream(in, 8));
                this.sheet = this.wb.getSheetAt(1);
                this.count = this.sheet.getLastRowNum() + 1;
                log.info("init read excel:{} complete", (Object)this.excelFile);
            }
            catch (IllegalArgumentException e) {
                IOUtils.closeQuietly((Closeable)this.wb);
                IOUtils.closeQuietly((InputStream)in);
                log.warn("read excel catch exception:{}", (Throwable)e);
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "excel\u7248\u672c\u4e0d\u5339\u914d");
            }
            catch (Exception e) {
                IOUtils.closeQuietly((Closeable)this.wb);
                IOUtils.closeQuietly((InputStream)in);
                log.error("read excel catch exception:", (Throwable)e);
                throw new RuntimeException("read excel exception - ", e);
            }
        }
    }

    @Override
    public int getDataLength() throws IOException {
        if (this.count == 0 && !this.isComplete) {
            this.initReader();
            this.count = this.sheet.getLastRowNum() + 1;
        }
        return this.count;
    }

    @Override
    public synchronized Object[] readData() throws IOException {
        try {
            this.initReader();
            Row row = this.sheet.getRow(this.currentIndex);
            if (row == null || row.getFirstCellNum() < 0) {
                if (this.currentIndex <= this.sheet.getLastRowNum()) {
                    ++this.currentIndex;
                    Object[] objectArray = this.readData();
                    return objectArray;
                }
                return null;
            }
            if (this.headerCount == 0) {
                this.headerCount = row.getLastCellNum();
            }
            Object[] rowObj = new Object[this.headerCount];
            boolean hasValueRow = false;
            int c = row.getFirstCellNum();
            while (c < this.headerCount) {
                Cell cell = row.getCell(c);
                rowObj[c] = ExcelExporterUtils.getValueFromCell((Cell)cell);
                if (!hasValueRow && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rowObj[c].toString().trim()})) {
                    hasValueRow = true;
                }
                ++c;
            }
            ++this.currentIndex;
            if (this.currentIndex >= this.sheet.getLastRowNum()) {
                this.isComplete = true;
            }
            if (hasValueRow) {
                Object[] objectArray = rowObj;
                return objectArray;
            }
            --this.count;
            Object[] objectArray = this.readData();
            return objectArray;
        }
        catch (Exception e) {
            log.error("read data get error:", (Throwable)e);
            this.isComplete = true;
            throw e;
        }
        finally {
            if (this.isComplete) {
                IOUtils.closeQuietly((Closeable)this.wb);
            }
        }
    }

    @Override
    public List<Object[]> readDatas() throws IOException {
        List datas = ExcelExporterUtils.read((InputStream)this.excelFile.getInputStream(), (int)0);
        this.count = datas.size();
        return datas;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.wb);
    }
}

