/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.upload.service.impl;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.upload.service.UploadFileReaderService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class CsvUploadFileReaderServiceImpl
implements UploadFileReaderService {
    private static final Logger log = LoggerFactory.getLogger(CsvUploadFileReaderServiceImpl.class);
    private MultipartFile csvFile;
    private BufferedReader br;
    private boolean isComplete;
    private int count;
    private boolean useStream;
    private int index;
    private List<Object[]> datas;

    public CsvUploadFileReaderServiceImpl(MultipartFile csvFile, boolean useStream) {
        Preconditions.checkArgument((csvFile != null && !csvFile.isEmpty() ? 1 : 0) != 0, (Object)"csv file is not exist");
        this.csvFile = csvFile;
        this.useStream = useStream;
        this.initReader();
    }

    private synchronized void initReader() {
        block6: {
            if (this.br == null && !this.isComplete) {
                try {
                    this.br = new BufferedReader(new InputStreamReader(this.csvFile.getInputStream(), "GBK"));
                    if (this.useStream || this.datas != null) break block6;
                    try {
                        this.datas = this.readDatas();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("get data length error");
                    }
                }
                catch (FileNotFoundException e) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0a\u4f20\u7684\u6587\u4ef6\u9519\u8bef");
                }
                catch (IOException e) {
                    log.error("init csv reader catch error:", (Throwable)e);
                    IOUtils.closeQuietly((Reader)this.br);
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfb\u53d6\u6587\u4ef6\u4fe1\u606f\u9519\u8bef");
                }
            }
        }
    }

    @Override
    public int getDataLength() throws IOException {
        this.initReader();
        if (!this.isComplete) {
            throw new UnsupportedOperationException("can not get data length from csv file before read all data");
        }
        return this.count;
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized Object[] readData() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Object[]> readDatas() throws IOException {
        ArrayList results;
        block10: {
            block9: {
                results = Lists.newArrayList();
                this.initReader();
                if (this.datas == null) break block9;
                List<Object[]> list = this.datas;
                IOUtils.closeQuietly((Reader)this.br);
                return list;
            }
            try {
                String line = null;
                while ((line = this.br.readLine()) != null) {
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{line})) continue;
                    ++this.count;
                    results.add(StringUtils.splitPreserveAllTokens((String)line, (char)','));
                }
            }
            catch (FileNotFoundException e) {
                log.error("init reader error,", (Throwable)e);
                IOUtils.closeQuietly((Reader)this.br);
                break block10;
            }
            catch (Exception e) {
                try {
                    log.error("read data catch error:", (Throwable)e);
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.closeQuietly((Reader)this.br);
                }
            }
            IOUtils.closeQuietly((Reader)this.br);
        }
        this.isComplete = true;
        return results;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Reader)this.br);
    }

    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File("/Users/zhenyujian/Desktop/CRM-\u7ebf\u7d22\u5bfc\u5165\u6a21\u677f.xlsx")), "gbk"));
        String line = null;
        ArrayList datas = Lists.newArrayList();
        while ((line = br.readLine()) != null) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{line})) continue;
            String[] data = StringUtils.splitPreserveAllTokens((String)line, (char)',');
            System.out.println("line:" + line + " split data:" + ArrayUtils.toString((Object)data));
            datas.add(data);
        }
        System.out.println(datas);
        br.close();
    }
}

