/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.upload.service.impl;

import com.baijia.tianxiao.common.service.ImportDataProcessService;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.upload.dao.TxUploadRecordsDao;
import com.baijia.tianxiao.dal.upload.po.TxUploadRecords;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.upload.dto.TaskStatus;
import com.baijia.tianxiao.sal.upload.service.CrmUploadService;
import com.baijia.tianxiao.sal.upload.service.UploadFileReaderService;
import com.baijia.tianxiao.sal.upload.service.impl.CsvUploadFileReaderServiceImpl;
import com.baijia.tianxiao.sal.upload.service.impl.ExcelUploadFileReaderServiceImpl;
import com.baijia.tianxiao.util.SerializeUtil;
import com.baijia.tianxiao.util.bean.BizDateThreadLocalUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CrmUploadServiceImpl
implements CrmUploadService,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CrmUploadServiceImpl.class);
    private Map<Integer, ImportDataProcessService> dataProcessServiceMap;
    private ApplicationContext context;
    @Autowired
    private TxUploadRecordsDao txUploadRecordsDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private ExecutorService uploadTaskExecutor = Executors.newFixedThreadPool(10, new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "UPLOAD_TASK_" + this.threadNumber.getAndIncrement());
            return t;
        }
    });

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.dataProcessServiceMap = Maps.newHashMap();
        Map serviceMap = this.context.getBeansOfType(ImportDataProcessService.class);
        for (ImportDataProcessService service : serviceMap.values()) {
            this.dataProcessServiceMap.put(service.getProcessType().getType(), service);
        }
    }

    String getCacheDataKey(String taskId) {
        return "data_" + taskId;
    }

    String getCacheTaskStatusKey(String taskId) {
        return "task_" + taskId;
    }

    Integer getCacheExpireTime() {
        return 1800;
    }

    private void cacheData(final String taskId, final Collection<ImportDataProcessService.SingleSaveErrorResult> data) {
        try {
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Collection<ImportDataProcessService.SingleSaveErrorResult>>(){

                public Collection<ImportDataProcessService.SingleSaveErrorResult> doInRedis(RedisConnection connection) throws DataAccessException {
                    String key = CrmUploadServiceImpl.this.getCacheDataKey(taskId);
                    connection.set(key.getBytes(), SerializeUtil.serialize((Object)JacksonUtil.obj2Str((Object)data)));
                    connection.expire(key.getBytes(), (long)CrmUploadServiceImpl.this.getCacheExpireTime().intValue());
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("cacheData - exception:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f13\u5b58\u6570\u636e\u4fe1\u606f\u5931\u8d25");
        }
    }

    private Collection<ImportDataProcessService.SingleSaveErrorResult> getData(final String taskId) {
        try {
            return (Collection)this.redisTemplate.execute((RedisCallback)new RedisCallback<Collection<ImportDataProcessService.SingleSaveErrorResult>>(){

                public Collection<ImportDataProcessService.SingleSaveErrorResult> doInRedis(RedisConnection connection) throws DataAccessException {
                    byte[] value;
                    Object obj;
                    String key = CrmUploadServiceImpl.this.getCacheDataKey(taskId);
                    if (connection.exists(key.getBytes()).booleanValue() && (obj = SerializeUtil.unserialize((byte[])(value = connection.get(key.getBytes())))) != null) {
                        try {
                            return JacksonUtil.str2List((String)obj.toString(), ImportDataProcessService.SingleSaveErrorResult.class);
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("getData exception:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u7f13\u5b58\u6570\u636e\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void cacheTaskStatus(final String taskId, final TaskStatus taskStatus) {
        try {
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    String key = CrmUploadServiceImpl.this.getCacheTaskStatusKey(taskId);
                    connection.set(key.getBytes(), SerializeUtil.serialize((Object)taskStatus));
                    try {
                        log.info("Set redis expired time.key={}", (Object)key);
                        connection.expire(key.getBytes(), (long)CrmUploadServiceImpl.this.getCacheExpireTime().intValue());
                    }
                    catch (Exception e) {
                        log.error("Redis exception.", (Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("cacheTaskStatus - exception:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f13\u5b58\u6267\u884c\u8fdb\u5ea6\u5931\u8d25");
        }
    }

    private TaskStatus getTaskStatus(final String taskId) {
        try {
            return (TaskStatus)this.redisTemplate.execute((RedisCallback)new RedisCallback<TaskStatus>(){

                public TaskStatus doInRedis(RedisConnection connection) throws DataAccessException {
                    String key = CrmUploadServiceImpl.this.getCacheTaskStatusKey(taskId);
                    if (connection.exists(key.getBytes()).booleanValue()) {
                        byte[] value = connection.get(key.getBytes());
                        Object obj = SerializeUtil.unserialize((byte[])value);
                        if (obj != null) {
                            return (TaskStatus)obj;
                        }
                        return null;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("cacheTaskStatus - exception:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u6267\u884c\u8fdb\u5ea6\u5931\u8d25");
        }
    }

    @Override
    public void downloadConsultImportTemplate(int uploadType, OutputStream os) {
        ImportDataProcessService processService = this.dataProcessServiceMap.get(uploadType);
        processService.downloadImportTemplate(os);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public String validateFile(final Long orgId, final int uploadType, final boolean override, final MultipartFile file) {
        Preconditions.checkNotNull((Object)uploadType, (Object)"upload type can not be null");
        Preconditions.checkArgument((file != null && !file.isEmpty() ? 1 : 0) != 0, (Object)"upload file is null");
        final Integer cascadeId = TianxiaoPCContext.getTXCascadeId();
        final String taskId = UUID.randomUUID().toString();
        final UploadFileReaderService service = this.getUploadFileService(file);
        this.uploadTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                block30: {
                    TianxiaoPCContext.setTXCascadeId((Integer)cascadeId);
                    TianxiaoPCContext.setOrgId((Integer)orgId.intValue());
                    log.info("start to execute upload task:{}", (Object)taskId);
                    ImportDataProcessService processService = (ImportDataProcessService)CrmUploadServiceImpl.this.dataProcessServiceMap.get(uploadType);
                    ArrayList<ImportDataProcessService.SingleSaveErrorResult> dataList = new ArrayList<ImportDataProcessService.SingleSaveErrorResult>();
                    TaskStatus taskStatus = new TaskStatus();
                    taskStatus.setUploadType(uploadType);
                    taskStatus.setFileName(file.getOriginalFilename());
                    taskStatus.setOverride(override);
                    CrmUploadServiceImpl.this.cacheTaskStatus(taskId, taskStatus);
                    try {
                        Object[] lineData = null;
                        int headerLineNum = 0;
                        int maxHeaderCheckNum = 1;
                        List headers = null;
                        boolean validateHeaders = false;
                        try {
                            while ((lineData = service.readData()) != null && headerLineNum < maxHeaderCheckNum) {
                                lineData = Arrays.copyOfRange(lineData, 1, lineData.length);
                                try {
                                    headers = CrmUploadServiceImpl.this.tranHeader(lineData);
                                }
                                catch (Exception e) {
                                    log.info("", (Throwable)e);
                                }
                                if (DataProcType.ORG_STUDENT.getType() == uploadType || DataProcType.CONSULT.getType() == uploadType) {
                                    if (processService.validateHeader(headers, orgId)) {
                                        taskStatus.setHeaders(headers);
                                        validateHeaders = true;
                                        break;
                                    }
                                } else if (processService.validateHeader(headers)) {
                                    taskStatus.setHeaders(headers);
                                    validateHeaders = true;
                                    break;
                                }
                                ++headerLineNum;
                            }
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                        if (!validateHeaders) {
                            throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCEL_TEMPLATE_VALIDATE_FAIL, "\u4e0a\u4f20\u6587\u4ef6\u7684\u8868\u5934\u4fe1\u606f\u4e0d\u6b63\u786e!");
                        }
                        int lineNum = 0;
                        while ((lineData = service.readData()) != null) {
                            lineData = Arrays.copyOfRange(lineData, 1, lineData.length);
                            dataList.add(new ImportDataProcessService.SingleSaveErrorResult(lineData));
                        }
                        if (dataList.size() == 0) {
                            taskStatus.setException((Exception)((Object)new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a!")));
                            CrmUploadServiceImpl.this.cacheTaskStatus(taskId, taskStatus);
                            return;
                        }
                        try {
                            taskStatus.setTotalCount(dataList.size());
                            CrmUploadServiceImpl.this.cacheTaskStatus(taskId, taskStatus);
                            BizDateThreadLocalUtil.clear();
                            for (ImportDataProcessService.SingleSaveErrorResult result : dataList) {
                                try {
                                    result = processService.validate(orgId, Long.valueOf(TianxiaoPCContext.getTXCascadeId() == null ? 0L : TianxiaoPCContext.getTXCascadeId().longValue()), headers, result, dataList, override);
                                    if (result.isSuccess()) {
                                        taskStatus.increaseSuccessCount();
                                    } else {
                                        taskStatus.increaseFailCount();
                                    }
                                }
                                catch (Exception e) {
                                    log.warn("vaildate data:{} ,catch error:{}", (Object)ToStringBuilder.reflectionToString((Object)lineData), (Object)e.getMessage());
                                    log.error("vaildate data catch error:", (Throwable)e);
                                    taskStatus.increaseFailCount();
                                }
                                if (++lineNum % 10 != 0) continue;
                                CrmUploadServiceImpl.this.cacheTaskStatus(taskId, taskStatus);
                            }
                            BizDateThreadLocalUtil.clear();
                            if (!override) {
                                processService.validateResult(dataList);
                                int succNum = 0;
                                int failNum = 0;
                                for (ImportDataProcessService.SingleSaveErrorResult s : dataList) {
                                    if (s.isSuccess()) {
                                        ++succNum;
                                        continue;
                                    }
                                    ++failNum;
                                }
                                taskStatus.setSuccessCount(succNum);
                                taskStatus.setFailCount(failNum);
                            }
                            taskStatus.setCompleteCount(taskStatus.getTotalCount());
                            CrmUploadServiceImpl.this.cacheData(taskId, dataList);
                        }
                        catch (BussinessException be) {
                            if (be.getErrorCode() == CrmErrorCode.EXCEL_TEMPLATE_VALIDATE_FAIL) {
                                taskStatus.setException((Exception)((Object)new BussinessException((UniverseErrorCode)CrmErrorCode.EXCEL_TEMPLATE_VALIDATE_FAIL, be.getMessage())));
                                break block30;
                            }
                            taskStatus.setException((Exception)((Object)new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, be.getMessage())));
                        }
                        catch (Exception e) {
                            log.warn("read data catch error:", (Throwable)e);
                            taskStatus.setException((Exception)((Object)new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef")));
                        }
                    }
                    finally {
                        CrmUploadServiceImpl.this.cacheTaskStatus(taskId, taskStatus);
                        service.close();
                    }
                }
            }
        });
        return taskId;
    }

    @Override
    public void downloadVaildateResult(OutputStream os, Long orgId, String taskId) {
        TaskStatus taskStatus = this.getTaskStatus(taskId);
        Collection<ImportDataProcessService.SingleSaveErrorResult> data = this.getData(taskId);
        if (data == null) {
            try {
                os.write("\u6587\u4ef6\u5df2\u5931\u6548\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002".getBytes());
                return;
            }
            catch (Exception exception) {
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        ImportDataProcessService processService = this.dataProcessServiceMap.get(taskStatus.getUploadType());
        processService.downloadValidateResult(os, orgId, taskId, data);
    }

    public static void main(String[] args) {
        Object[] lineData = new Object[]{1, 2};
        ImportDataProcessService.SingleSaveErrorResult saveResult = new ImportDataProcessService.SingleSaveErrorResult();
        saveResult.setLineData(lineData);
        lineData = null;
        System.out.println(saveResult.getLineData().length);
    }

    @Override
    public void doImport(final Long orgId, final String taskId) {
        final TaskStatus taskStatus = this.getTaskStatus(taskId);
        final Collection<ImportDataProcessService.SingleSaveErrorResult> validateData = this.getData(taskId);
        final Integer cascadeId = TianxiaoPCContext.getTXCascadeId();
        final Integer uploadType = taskStatus.getUploadType();
        final TxUploadRecords uploadRecord = new TxUploadRecords();
        uploadRecord.setFileName(taskStatus.getFileName());
        uploadRecord.setOrgId(orgId);
        uploadRecord.setStatus(0);
        uploadRecord.setUploadType(uploadType.intValue());
        this.txUploadRecordsDao.save((Object)uploadRecord, new String[0]);
        this.uploadTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                TianxiaoPCContext.setTXCascadeId((Integer)cascadeId);
                TianxiaoPCContext.setOrgId((Integer)orgId.intValue());
                ImportDataProcessService processService = (ImportDataProcessService)CrmUploadServiceImpl.this.dataProcessServiceMap.get(uploadType);
                LinkedHashMap<String, ImportDataProcessService.SingleSaveErrorResult> dataMap = new LinkedHashMap<String, ImportDataProcessService.SingleSaveErrorResult>();
                taskStatus.clear();
                taskStatus.setTotalCount(validateData.size());
                CrmUploadServiceImpl.this.cacheTaskStatus(taskId, taskStatus);
                ArrayList importData = new ArrayList();
                CrmUploadServiceImpl.this.cacheData(taskId, importData);
                BizDateThreadLocalUtil.clear();
                try {
                    try {
                        Object[] lineData = null;
                        ImportDataProcessService.SingleSaveErrorResult saveResult2 = null;
                        int lineNum = 0;
                        boolean isExistedPublicClue = false;
                        for (ImportDataProcessService.SingleSaveErrorResult saveResult2 : validateData) {
                            try {
                                lineData = saveResult2.getLineData();
                                saveResult2 = processService.saveSingleData(orgId, Long.valueOf(TianxiaoPCContext.getTXCascadeId() == null ? 0L : TianxiaoPCContext.getTXCascadeId().longValue()), taskStatus.getHeaders(), lineData, taskStatus.isOverride());
                                saveResult2.setLineData(lineData);
                                dataMap.put(String.valueOf(lineNum), saveResult2);
                                if (saveResult2.isPublicClue()) {
                                    isExistedPublicClue = true;
                                }
                                if (saveResult2.isSuccess()) {
                                    taskStatus.increaseSuccessCount();
                                } else {
                                    taskStatus.increaseFailCount();
                                }
                            }
                            catch (DuplicateKeyException e) {
                                log.warn("save data:{} ,is repeat", (Object)ToStringBuilder.reflectionToString((Object)lineData));
                                taskStatus.increaseRepeatCount();
                            }
                            catch (Exception e) {
                                log.warn("save data:{} ,catch error:{}", (Object)ToStringBuilder.reflectionToString((Object)lineData), (Object)e.getMessage());
                                log.error("save data catch error:", (Throwable)e);
                                taskStatus.increaseFailCount();
                            }
                            if (++lineNum % 10 != 0 || taskStatus.getCompleteCount() >= taskStatus.getTotalCount()) continue;
                            CrmUploadServiceImpl.this.processResultStore(uploadRecord, taskStatus, null, false);
                            CrmUploadServiceImpl.this.cacheTaskStatus(taskId, taskStatus);
                        }
                        BizDateThreadLocalUtil.clear();
                        if (taskStatus.getCompleteCount() == 0) {
                            taskStatus.setException((Exception)((Object)new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a")));
                        } else if (isExistedPublicClue) {
                            processService.afterComplete();
                        }
                        CrmUploadServiceImpl.this.cacheData(taskId, dataMap.values());
                        CrmUploadServiceImpl.this.processResultStore(uploadRecord, taskStatus, null, true);
                    }
                    catch (Exception e) {
                        log.warn("read data catch error:", (Throwable)e);
                        taskStatus.setException((Exception)((Object)new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef")));
                        CrmUploadServiceImpl.this.cacheTaskStatus(taskId, taskStatus);
                    }
                }
                finally {
                    CrmUploadServiceImpl.this.cacheTaskStatus(taskId, taskStatus);
                }
            }
        });
    }

    @Override
    public void downloadImportResult(OutputStream os, Long orgId, String taskId) {
        TaskStatus taskStatus = this.getTaskStatus(taskId);
        Collection<ImportDataProcessService.SingleSaveErrorResult> data = this.getData(taskId);
        if (data == null) {
            try {
                os.write("\u6587\u4ef6\u5df2\u5931\u6548\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002".getBytes());
                return;
            }
            catch (Exception exception) {
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        ImportDataProcessService processService = this.dataProcessServiceMap.get(taskStatus.getUploadType());
        processService.downloadImportResult(os, orgId, taskId, data);
    }

    @Override
    public TaskStatus getTaskStatus(Long orgId, String taskId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((taskId != null ? 1 : 0) != 0, (Object)"taskId is illegal");
        TaskStatus taskStatus = this.getTaskStatus(taskId);
        if (taskStatus == null) {
            TaskStatus status = new TaskStatus(null, 0);
            return status;
        }
        taskStatus.getCompleteRate();
        return taskStatus;
    }

    private void processResultStore(TxUploadRecords uploadRecord, TaskStatus taskStatus, String fileUrl, boolean isComplete) {
        uploadRecord.setFailCount(taskStatus.getFailCount());
        uploadRecord.setRepeatCount(taskStatus.getRepeatCount());
        uploadRecord.setSuccessCount(taskStatus.getSuccessCount());
        uploadRecord.setTotalCount(taskStatus.getTotalCount() - 1);
        if (isComplete) {
            String errorFileUrl = fileUrl == null ? "" : fileUrl;
            uploadRecord.setErrorFileUrl(errorFileUrl);
            taskStatus.setErrorFileUrl(errorFileUrl);
            uploadRecord.setStatus(1);
        }
        this.txUploadRecordsDao.update((Object)uploadRecord, new String[0]);
    }

    private List<String> tranHeader(Object[] headerObjs) {
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])headerObjs), (Object)"\u5934\u4fe1\u606f\u4e3a\u7a7a");
        ArrayList headers = Lists.newArrayList();
        int i = 0;
        while (i < headerObjs.length) {
            if (headerObjs[i] != null) {
                headers.add(headerObjs[i].toString());
            } else {
                headers.add("-");
            }
            ++i;
        }
        return headers;
    }

    private UploadFileReaderService getUploadFileService(MultipartFile file) {
        UploadFileReaderService service = null;
        String fileName = file.getOriginalFilename();
        if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
            service = new ExcelUploadFileReaderServiceImpl(file);
        } else if (fileName.toLowerCase().endsWith(".csv")) {
            service = new CsvUploadFileReaderServiceImpl(file, false);
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, String.valueOf(fileName) + "\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301,\u53ea\u652f\u6301CSV\u548cexcel\u6587\u4ef6");
        }
        return service;
    }
}

