
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.upload.dto;

import java.util.Date;

import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.upload.po.TxUploadRecords;
import com.google.common.base.Preconditions;

import lombok.Data;

/**
 * @title UploadRecordDto
 * @desc TODO
 * @author cxm
 * @date 2016年3月15日
 * @version 1.0
 */
@Data
public class UploadRecordDto {

    private Integer id;

    private Long orgId;

    private String orgName;

    private int uploadType;

    private String uploadTypeName;

    private int totalCount;

    private int successCount;

    private int repeatCount;

    private int failCount;

    private int status;

    private String statusStr;

    private Date createTime;

    private Date updateTime;

    public void setStatus(int status) {
        this.status = status;
        if (status == 1) {
            this.statusStr = "已完成";
        } else {
            this.statusStr = "导入中...";
        }
    }

    public void setUploadTypeEnum(DataProcType uploadTypeEnum) {
        if (uploadTypeEnum != null) {
            this.uploadType = uploadTypeEnum.getType();
            this.uploadTypeName = uploadTypeEnum.getNote();
        }
    }

    public static UploadRecordDto transfer(TxUploadRecords record, String orgName) {
        Preconditions.checkNotNull(record, "upload record is null");
        UploadRecordDto dto = new UploadRecordDto();
        dto.setCreateTime(record.getCreateTime());
        dto.setFailCount(record.getFailCount());
        dto.setId(record.getId());
        dto.setOrgId(record.getOrgId());
        dto.setOrgName(orgName);
        dto.setRepeatCount(record.getRepeatCount());
        dto.setStatus(record.getStatus());
        dto.setSuccessCount(record.getSuccessCount());
        dto.setTotalCount(record.getTotalCount());
        dto.setUpdateTime(record.getUpdateTime());
        dto.setUploadTypeEnum(DataProcType.getByType(record.getUploadType()));
        return dto;
    }

}
