/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.upload.service.impl;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.common.service.ImportDataProcessService;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.upload.dao.TxUploadRecordsDao;
import com.baijia.tianxiao.dal.upload.po.TxUploadRecords;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.excel.ExcelExporterUtils;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.upload.dto.TaskStatus;
import com.baijia.tianxiao.sal.upload.dto.UploadRecordDto;
import com.baijia.tianxiao.sal.upload.service.UploadFileReaderService;
import com.baijia.tianxiao.sal.upload.service.UploadService;
import com.baijia.tianxiao.sal.upload.service.impl.CsvUploadFileReaderServiceImpl;
import com.baijia.tianxiao.sal.upload.service.impl.ExcelUploadFileReaderServiceImpl;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.baijia.tianxiao.util.upload.FileUploadUtils;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UploadServiceImpl
implements UploadService,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(UploadServiceImpl.class);
    private Map<Integer, ImportDataProcessService> dataProcessServiceMap;
    private ApplicationContext context;
    @Autowired(required=false)
    private CacheManager cacheManager;
    private ExecutorService uploadTaskExecutor = Executors.newFixedThreadPool(10, new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "UPLOAD_TASK_" + this.threadNumber.getAndIncrement());
            return t;
        }
    });
    private Cache taskCache;
    @Resource
    private TxUploadRecordsDao txUploadRecordsDao;
    @Resource
    private OrgInfoDao orgInfoDao;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int uploadFile(final Long orgId, final int uploadType, final boolean override, MultipartFile file) throws IOException {
        Preconditions.checkNotNull((Object)uploadType, (Object)"upload type can not be null");
        Preconditions.checkArgument((file != null && !file.isEmpty() ? 1 : 0) != 0, (Object)"upload file is null");
        final TxUploadRecords uploadRecord = new TxUploadRecords();
        uploadRecord.setFileName(file.getOriginalFilename());
        uploadRecord.setOrgId(orgId);
        uploadRecord.setStatus(0);
        uploadRecord.setUploadType(uploadType);
        final Integer cascadeId = TianxiaoPCContext.getTXCascadeId();
        this.txUploadRecordsDao.save((Object)uploadRecord, new String[0]);
        final Integer taskId = uploadRecord.getId();
        final UploadFileReaderService service = this.getUploadFileService(file);
        this.uploadTaskExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TianxiaoPCContext.setTXCascadeId((Integer)cascadeId);
                TianxiaoPCContext.setOrgId((Integer)orgId.intValue());
                log.info("start to execute upload task:{}", (Object)taskId);
                ImportDataProcessService processService = (ImportDataProcessService)UploadServiceImpl.this.dataProcessServiceMap.get(uploadType);
                TaskStatus taskStatus = new TaskStatus();
                UploadServiceImpl.this.storeCache(taskId, taskStatus);
                try {
                    List headers = UploadServiceImpl.this.tranHeader(service.readData());
                    taskStatus.setHeaders(headers);
                    taskStatus.setTotalCount(service.getDataLength());
                    if (CollectionUtils.isEmpty((Collection)headers) || !processService.validateHeader(headers)) {
                        taskStatus.setException((Exception)new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0a\u4f20\u6587\u4ef6\u7684\u8868\u5934\u4fe1\u606f\u4e0d\u6b63\u786e!"));
                        log.warn("upload file header:{} is invalidate", (Object)taskStatus);
                        UploadServiceImpl.this.storeCache(taskId, taskStatus);
                        return;
                    }
                    Object[] lineData = null;
                    ImportDataProcessService.SingleSaveErrorResult saveResult = null;
                    List failDatas = Lists.newArrayList();
                    List repeatDatas = Lists.newArrayList();
                    int i = 0;
                    while ((lineData = service.readData()) != null) {
                        try {
                            saveResult = processService.saveSingleData(orgId, headers, lineData, override);
                            if (saveResult == null || !saveResult.isRepeat() && StringUtils.isBlank((CharSequence)saveResult.getErrorMsg()) || saveResult.isSuccess()) {
                                taskStatus.increaseSuccessCount();
                            } else if (saveResult.isRepeat()) {
                                taskStatus.increaseRepeatCount();
                                repeatDatas.add(lineData);
                            } else {
                                taskStatus.increaseFailCount();
                                failDatas.add(lineData);
                            }
                        }
                        catch (DuplicateKeyException e) {
                            log.warn("save data:{} ,is repeat", (Object)ToStringBuilder.reflectionToString((Object)lineData));
                            taskStatus.increaseRepeatCount();
                            repeatDatas.add(lineData);
                        }
                        catch (Exception e) {
                            log.warn("save data:{} ,catch error:{}", (Object)ToStringBuilder.reflectionToString((Object)lineData), (Object)e.getMessage());
                            failDatas.add(lineData);
                            log.error("save data catch error:", (Throwable)e);
                            taskStatus.increaseFailCount();
                        }
                        if (++i % 10 == 0 && taskStatus.getCompleteCount() < taskStatus.getTotalCount()) {
                            UploadServiceImpl.this.processResultStore(uploadRecord, taskStatus, null, false);
                        }
                        UploadServiceImpl.this.storeCache(taskId, taskStatus);
                    }
                    if (taskStatus.getCompleteCount() == 0) {
                        taskStatus.setException((Exception)new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a"));
                    } else {
                        processService.afterComplete();
                    }
                    taskStatus.setTotalCount(taskStatus.getCompleteCount());
                    UploadServiceImpl.this.processResultStore(uploadRecord, taskStatus, UploadServiceImpl.this.generateErrorExcel(orgId, headers, repeatDatas, failDatas), true);
                }
                catch (Exception e) {
                    log.warn("read data catch error:", (Throwable)e);
                    taskStatus.setException((Exception)new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef"));
                }
                finally {
                    UploadServiceImpl.this.storeCache(taskId, taskStatus);
                    service.close();
                }
            }
        });
        return taskId;
    }

    private void storeCache(Integer taskId, TaskStatus taskStatus) {
        try {
            this.taskCache.put((Object)taskId.toString(), (Object)JacksonUtil.obj2Str((Object)taskStatus));
        }
        catch (IOException e1) {
            log.error("serialize taskstatus catch exception:", (Throwable)e1);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5e8f\u5217\u5316\u8fdb\u5ea6\u4fe1\u606f\u5931\u8d25");
        }
    }

    private String generateErrorExcel(Long orgId, List<String> headers, List<Object[]> repeatDatas, List<Object[]> failDatas) throws IOException {
        String string;
        if (CollectionUtils.isEmpty(repeatDatas) && CollectionUtils.isEmpty(failDatas)) {
            return "";
        }
        SXSSFWorkbook workBook = null;
        FileOutputStream os = null;
        File excelFile = null;
        try {
            File execelFolder;
            Sheet sheet;
            workBook = new SXSSFWorkbook(100);
            HashMap cellStyleMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(repeatDatas)) {
                sheet = workBook.createSheet("\u91cd\u590d\u4fe1\u606f\u8868");
                ExcelExporterUtils.fillSheet((Sheet)sheet, headers, repeatDatas, (Map)cellStyleMap);
            }
            if (CollectionUtils.isNotEmpty(failDatas)) {
                sheet = workBook.createSheet("\u9519\u8bef\u4fe1\u606f\u8868");
                ExcelExporterUtils.fillSheet((Sheet)sheet, headers, failDatas, (Map)cellStyleMap);
            }
            if (!(execelFolder = new File("/tmp/tianxiao-export")).exists()) {
                execelFolder.mkdirs();
            }
            excelFile = new File(execelFolder, System.currentTimeMillis() + ".xlsx");
            excelFile.createNewFile();
            os = new FileOutputStream(excelFile);
            workBook.write((OutputStream)os);
            UploadResult.UploadFile uploadFile = FileUploadUtils.uploadToRemote((Long)orgId, (File)excelFile, (boolean)false);
            string = StorageUtil.constructUrl((UploadResult.UploadFile)uploadFile);
        }
        catch (IOException e) {
            try {
                log.error("write error data to excel catch error:", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly((Closeable)workBook);
                if (excelFile != null) {
                    excelFile.deleteOnExit();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((Closeable)workBook);
        if (excelFile != null) {
            excelFile.deleteOnExit();
        }
        return string;
    }

    private void processResultStore(TxUploadRecords uploadRecord, TaskStatus taskStatus, String fileUrl, boolean isComplete) {
        uploadRecord.setFailCount(taskStatus.getFailCount());
        uploadRecord.setRepeatCount(taskStatus.getRepeatCount());
        uploadRecord.setSuccessCount(taskStatus.getSuccessCount());
        uploadRecord.setTotalCount(taskStatus.getTotalCount() - 1);
        if (isComplete) {
            String errorFileUrl = fileUrl == null ? "" : fileUrl;
            uploadRecord.setErrorFileUrl(errorFileUrl);
            taskStatus.setErrorFileUrl(errorFileUrl);
            uploadRecord.setStatus(1);
        }
        this.txUploadRecordsDao.update((Object)uploadRecord, new String[0]);
    }

    private List<String> tranHeader(Object[] headerObjs) {
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])headerObjs), (Object)"\u5934\u4fe1\u606f\u4e3a\u7a7a");
        List headers = Lists.newArrayList();
        for (Object obj : headerObjs) {
            if (obj != null) {
                headers.add(obj.toString());
                continue;
            }
            headers.add("-");
        }
        return headers;
    }

    private UploadFileReaderService getUploadFileService(MultipartFile file) {
        UploadFileReaderService service = null;
        String fileName = file.getOriginalFilename();
        if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
            service = new ExcelUploadFileReaderServiceImpl(file);
        } else if (fileName.toLowerCase().endsWith(".csv")) {
            service = new CsvUploadFileReaderServiceImpl(file, false);
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, fileName + "\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301,\u53ea\u652f\u6301CSV\u548cexcel\u6587\u4ef6");
        }
        return service;
    }

    @Override
    public TaskStatus getUploadStatus(Long orgId, Integer taskId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((taskId != null && taskId > 0 ? 1 : 0) != 0, (Object)"taskId is illegal");
        Cache.ValueWrapper value = this.taskCache.get((Object)taskId.toString());
        if (value == null) {
            return new TaskStatus(null, 0);
        }
        TaskStatus taskStatus = null;
        try {
            taskStatus = (TaskStatus)JacksonUtil.str2Obj((String)((String)value.get()), TaskStatus.class);
            taskStatus.getCompleteRate();
        }
        catch (IOException e) {
            log.error("deserilize error:", (Throwable)e);
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        return taskStatus;
    }

    @Override
    public List<UploadRecordDto> listUploadTask(Long orgId, Date startTime, Date endTime, DataProcType uploadType, Integer status) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Integer type = uploadType != null ? Integer.valueOf(uploadType.getType()) : null;
        List records = this.txUploadRecordsDao.listUploadTask(orgId, startTime, endTime, type, status);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            return this.buildUploadRecordDto(records);
        }
        return Collections.emptyList();
    }

    private List<UploadRecordDto> buildUploadRecordDto(List<TxUploadRecords> records) {
        List result = Lists.newArrayList();
        Collection orgIds = CollectorUtil.collect(records, (Function)new Function<TxUploadRecords, Long>(){

            public Long apply(TxUploadRecords input) {
                return input.getOrgId();
            }
        });
        Map<Long, String> orgNameMap = this.queryOrgNameMap(orgIds);
        for (TxUploadRecords record : records) {
            result.add(UploadRecordDto.transfer(record, orgNameMap.get(record.getOrgId())));
        }
        return result;
    }

    private Map<Long, String> queryOrgNameMap(Collection<Long> orgIds) {
        List orgInfos = this.orgInfoDao.getByIds(orgIds, new String[]{"orgId", "shortName"});
        return CollectorUtil.collectMap((Collection)orgInfos, (Function)new Function<OrgInfo, Long>(){

            public Long apply(OrgInfo input) {
                return input.getOrgId().longValue();
            }
        }, (Function)new Function<OrgInfo, String>(){

            public String apply(OrgInfo input) {
                return input.getShortName();
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.dataProcessServiceMap = Maps.newHashMap();
        Map serviceMap = this.context.getBeansOfType(ImportDataProcessService.class);
        for (ImportDataProcessService service : serviceMap.values()) {
            this.dataProcessServiceMap.put(service.getProcessType().getType(), service);
        }
        if (this.cacheManager == null) {
            try {
                RedisTemplate template = (RedisTemplate)this.context.getBean(RedisTemplate.class);
                this.cacheManager = new RedisCacheManager((RedisOperations)template);
                this.taskCache = this.cacheManager.getCache("UPLOAD_TASK_CACHE");
                log.info("try to init cache by redis template");
            }
            catch (Exception e) {
                this.taskCache = new ConcurrentMapCache("UPLOAD_TASK_CACHE");
                log.info("use local cache because can not found redis config");
            }
        } else {
            this.taskCache = this.cacheManager.getCache("UPLOAD_TASK_CACHE");
            log.info("use cache manager bean");
        }
    }

    @Override
    public String getErrorFileUrl(Long orgId, Integer taskId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((taskId != null && taskId > 0 ? 1 : 0) != 0, (Object)"taskId is illegal");
        TxUploadRecords uploadRecord = (TxUploadRecords)this.txUploadRecordsDao.getById((Serializable)taskId, new String[]{"errorFileUrl"});
        return uploadRecord.getErrorFileUrl();
    }
}

