/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.upload.dto;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TaskStatus {
    private List<String> headers;
    private int totalCount;
    private int successCount;
    private int repeatCount;
    private int failCount;
    private int completeCount;
    private int completeRate;
    private String errorFileUrl;
    private Exception exception;

    public TaskStatus(List<String> headers2, int totalCount) {
        this.headers = headers2;
        this.totalCount = totalCount;
    }

    public TaskStatus() {
    }

    public void increaseSuccessCount() {
        this.increaseCompleteCount();
        ++this.successCount;
    }

    public void increaseRepeatCount() {
        this.increaseCompleteCount();
        ++this.repeatCount;
    }

    public void increaseFailCount() {
        this.increaseCompleteCount();
        ++this.failCount;
    }

    public void increaseCompleteCount() {
        ++this.completeCount;
    }

    public int getCompleteRate() {
        if (this.totalCount == 0) {
            return 0;
        }
        this.completeRate = this.completeCount == this.totalCount && (this.failCount > 0 || this.repeatCount > 0) && StringUtils.isBlank((CharSequence)this.errorFileUrl) ? 99 : new BigDecimal(this.completeCount).multiply(new BigDecimal(100)).divide(new BigDecimal(this.totalCount), RoundingMode.DOWN).intValue();
        return this.completeRate;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public int getCompleteCount() {
        return this.completeCount;
    }

    public String getErrorFileUrl() {
        return this.errorFileUrl;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setFailCount(int failCount) {
        this.failCount = failCount;
    }

    public void setCompleteCount(int completeCount) {
        this.completeCount = completeCount;
    }

    public void setCompleteRate(int completeRate) {
        this.completeRate = completeRate;
    }

    public void setErrorFileUrl(String errorFileUrl) {
        this.errorFileUrl = errorFileUrl;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskStatus)) {
            return false;
        }
        TaskStatus other = (TaskStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$headers = this.getHeaders();
        List<String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getSuccessCount() != other.getSuccessCount()) {
            return false;
        }
        if (this.getRepeatCount() != other.getRepeatCount()) {
            return false;
        }
        if (this.getFailCount() != other.getFailCount()) {
            return false;
        }
        if (this.getCompleteCount() != other.getCompleteCount()) {
            return false;
        }
        if (this.getCompleteRate() != other.getCompleteRate()) {
            return false;
        }
        String this$errorFileUrl = this.getErrorFileUrl();
        String other$errorFileUrl = other.getErrorFileUrl();
        if (this$errorFileUrl == null ? other$errorFileUrl != null : !this$errorFileUrl.equals(other$errorFileUrl)) {
            return false;
        }
        Exception this$exception = this.getException();
        Exception other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + this.getTotalCount();
        result = result * 59 + this.getSuccessCount();
        result = result * 59 + this.getRepeatCount();
        result = result * 59 + this.getFailCount();
        result = result * 59 + this.getCompleteCount();
        result = result * 59 + this.getCompleteRate();
        String $errorFileUrl = this.getErrorFileUrl();
        result = result * 59 + ($errorFileUrl == null ? 43 : $errorFileUrl.hashCode());
        Exception $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "TaskStatus(headers=" + this.getHeaders() + ", totalCount=" + this.getTotalCount() + ", successCount=" + this.getSuccessCount() + ", repeatCount=" + this.getRepeatCount() + ", failCount=" + this.getFailCount() + ", completeCount=" + this.getCompleteCount() + ", completeRate=" + this.getCompleteRate() + ", errorFileUrl=" + this.getErrorFileUrl() + ", exception=" + this.getException() + ")";
    }
}

