package com.baijia.tianxiao.sal.tuiguang.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.stereotype.Service;

import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.dal.advisory.dao.OrgStudentAdvisoryDao;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceStatisticsDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceStatistics;
import com.baijia.tianxiao.dal.course.dao.ClassCoursePhotoDao;
import com.baijia.tianxiao.dal.course.dao.ClassCourseScheduleDao;
import com.baijia.tianxiao.dal.course.dao.SubjectDao;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.dao.VideoCourseDao;
import com.baijia.tianxiao.dal.course.po.ClassCoursePhoto;
import com.baijia.tianxiao.dal.course.po.ClassCourseSchedule;
import com.baijia.tianxiao.dal.course.po.Subject;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.course.po.VideoCourse;
import com.baijia.tianxiao.dal.im.dao.ImMessageInfoDao;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClickLogDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseAccessDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPVDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClickLog;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPV;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.tuiguang.api.CourseAdvertiseService;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CourseDetailRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CoursePvRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CourseTransformRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CallResponse;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CategoryListResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CommonInfoResponse;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseDetailResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseListPageResponse;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseListResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CoursePvResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseTransformResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.DiscoveryResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.GalaxyCallResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.GalaxyTopSearchResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.OrgTransformResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.RefuseInfo;
import com.baijia.tianxiao.sal.tuiguang.dto.response.TopSearch;
import com.baijia.tianxiao.sal.tuiguang.dto.response.UserLevelResponseDto;
import com.baijia.tianxiao.sal.tuiguang.enums.Discovery;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.date.JodaDateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service("courseAdvertiseService")
public class CourseAdvertiseServiceImpl extends ApplicationObjectSupport implements CourseAdvertiseService {

    @Autowired
    OrgAccountDao orgAccountDao;

    @Autowired
    OrgInfoDao orgInfoDao;

    @Autowired
    SubjectDao subjectDao;

    @Autowired
    TeacherClassCourseDao teacherClassCourseDao;

    @Autowired
    OrgCourseDao orgCourseDao;

    @Autowired
    OrgCourseAccessDao orgCourseAccessDao;

    @Autowired
    CoursePurchaseDao coursePurchaseDao;

    @Autowired
    OrgStudentAdvisoryDao orgStudentAdvisoryDao;

    @Autowired
    MessageDao messageDao;

    @Autowired
    OrgPVDao orgPVDao;

    @Autowired
    ImMessageInfoDao imMessageInfoDao;

    @Autowired
    TeacherDao teacherDao;

    @Autowired
    VideoCourseDao videoCourseDao;

    @Autowired
    OrgClickLogDao orgClickLogDao;

    @Autowired
    ClassCourseScheduleDao classCourseScheduleDao;

    @Autowired
    CallServiceStatisticsDao callServiceStatisticsDao;

    @Autowired
    OrgClassLessonDao orgClassLessonDao;

    @Autowired
    ClassCoursePhotoDao classCoursePhotoDao;

    @Autowired
    StorageDao storageDao;

    @Autowired
    OrgCourseTeacherDao orgCourseTeacherDao;

    @Value("${galaxy.appid.config}")
    private String galaxyAppid;

    @Value("${galaxy.database.config}")
    private String galaxyDatabase;

    @Value("${galaxy.query.api}")
    private String galaxyQueryApi;

    @Value("${storage.server.url}")
    private String storageServerUrl;

    @Value("${teacher.course.url}")
    private String teacherCourseUrl;

    @Value("${org.course.url}")
    private String orgCourseUrl;

    @Value("${user.level.url}")
    private String userLevelUrl;

    @Value("${tianxiao.yingxiao.sendactivity}")
    private String sendActivityUrl;

    @Value("${tiaoxiao.yingxiao.promotion}")
    private String promotionUrl;

    @Value("${tiaoxiao.yingxiao.coupon}")
    private String couponUrl;

    @Value("${tiaoxiao.yingxiao.smartpromotion}")
    private String smartPromotionUrl;

    @Value("${tiaoxiao.yingxiao.displayitems}")
    private String displayItems;

    @Value("${tiaoxiao.yingxiao.rushroomurl}")
    private String rushSourceUrl;

    @Value("${tiaoxiao.yingxiao.rentroomurl}")
    private String rentRoomUrl;

    @Value("${tiaoxiao.yingxiao.drawUrl}")
    private String drawActivityUrl;

    @Value("${tiaoxiao.yingxiao.voteUrl}")
    private String voteActivityUrl;

    @Value("${tiaoxiao.yingxiao.groupSendUrl}")
    private String groupSendUrl;

    @Value("${tiaoxiao.yingxiao.discount}")
    private String discountUrl;

    @Value("${tiaoxiao.yingxiao.benefit}")
    private String benefitUrl;

    @Value("${tiaoxiao.yingxiao.referral}")
    private String referralActivityUrl;

    @Value("${tiaoxiao.yingxiao.article}")
    private String articleActivityUrl;

    /**
     * 获取推广列表
     */
    @Override
    public CourseListPageResponse getCourseList(int orgId, CourseListRequestDto courseListRequestDto) {

        int pageNum = courseListRequestDto.getPageNum();
        int pageSize = courseListRequestDto.getPageSize();
        int offset = (pageNum - 1) * pageSize;

        List<CourseListResponseDto> responseList = Lists.newArrayList();
        int totalCount = 0;

        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        int orgNumber = orgAccount.getNumber();
        int type = courseListRequestDto.getType();
        int sortOrder = courseListRequestDto.getSortOrder();
        String courseTypes = courseListRequestDto.getCourseType();
        String categoryIds = courseListRequestDto.getCategoryId();

        if (type == 1) {// 班课
            List<TeacherClassCourse> courseList =
                teacherClassCourseDao.getVisualTeacherCourseByOrgNumber(orgNumber, categoryIds, courseTypes, sortOrder);
            List<TeacherClassCourse> subList = ListUtil.getSubList(courseList, offset, pageSize);
            if (CollectionUtils.isNotEmpty(subList)) {
                totalCount = courseList.size();
                for (TeacherClassCourse teacherClassCourse : subList) {
                    CourseListResponseDto courseListResponseDto = new CourseListResponseDto();
                    courseListResponseDto.setCourseName(teacherClassCourse.getName());
                    courseListResponseDto.setPrior(teacherClassCourse.getExtendStatus());

                    if (teacherClassCourse.getExtendStatus() != null
                        && teacherClassCourse.getExtendStatus().intValue() == 1) {
                        teacherClassCourse =
                            teacherClassCourseDao.getTeacherClassCourse(orgNumber, teacherClassCourse.getNumber());
                        if (teacherClassCourse.getLastSetTime() != null) {
                            if (new Date().getTime() - teacherClassCourse.getLastSetTime().getTime() >= 7200000) {
                                courseListResponseDto.setPv(teacherClassCourse.getPageView());
                                courseListResponseDto.setTransform(teacherClassCourse.getTransform());
                            }
                        }
                    }

                    courseListResponseDto.setStar(teacherClassCourse.getRank());
                    courseListResponseDto.setType(type);
                    courseListResponseDto.setCourseNumber(teacherClassCourse.getNumber());
                    responseList.add(courseListResponseDto);
                }
            }

        } else if (type == 2) {// 微课
            List<OrgCourse> orgCourseList =
                orgCourseDao.getVisualOrgCourseByOrgNumber(orgNumber, categoryIds, sortOrder);
            List<OrgCourse> subList = ListUtil.getSubList(orgCourseList, offset, pageSize);
            if (CollectionUtils.isNotEmpty(subList)) {
                totalCount = orgCourseList.size();
                for (OrgCourse orgCourse : subList) {
                    CourseListResponseDto courseListResponseDto = new CourseListResponseDto();
                    courseListResponseDto.setCourseName(orgCourse.getName());
                    courseListResponseDto.setPrior(orgCourse.getExtendStatus());
                    courseListResponseDto.setStar(orgCourse.getRank());
                    if (orgCourse.getExtendStatus() != null && orgCourse.getExtendStatus().intValue() == 1) {
                        orgCourse = orgCourseDao.getOrgCourse(orgNumber, orgCourse.getNumber());
                        if (orgCourse.getLastSetTime() != null) {
                            if (new Date().getTime() - orgCourse.getLastSetTime().getTime() >= 7200000) {
                                courseListResponseDto.setPv(orgCourse.getPageView());
                                courseListResponseDto.setTransform(orgCourse.getTransform());
                            }
                        }
                    }
                    courseListResponseDto.setType(type);
                    courseListResponseDto.setCourseNumber(orgCourse.getNumber());
                    responseList.add(courseListResponseDto);
                }
            }
        } else if (type == 3) {// 视频课

            List<Teacher> teachers = teacherDao.getTeachersByOrgId(Long.valueOf(orgId), null);
            List<VideoCourse> videoCourseList = videoCourseDao.getTeacherVideoCourse(teachers, sortOrder, categoryIds);
            List<VideoCourse> subList = ListUtil.getSubList(videoCourseList, offset, pageSize);
            if (CollectionUtils.isNotEmpty(subList)) {
                totalCount = videoCourseList.size();
                for (VideoCourse videoCourse : subList) {
                    CourseListResponseDto courseListResponseDto = new CourseListResponseDto();
                    courseListResponseDto.setCourseName(videoCourse.getName());
                    courseListResponseDto.setPrior(0);
                    courseListResponseDto.setStar(0);
                    courseListResponseDto.setPv(videoCourse.getPageView());
                    courseListResponseDto.setTransform(videoCourse.getTransform());
                    courseListResponseDto.setType(type);
                    responseList.add(courseListResponseDto);
                }
            }
        }

        CourseListPageResponse courseListPageResponse = new CourseListPageResponse();
        courseListPageResponse.setList(responseList);
        courseListPageResponse.setTotalCount(totalCount);
        return courseListPageResponse;
    }

    @Override
    public List<RefuseInfo> getRejectReason(int orgId, long courseNumber, int type) {
        if (type == 1) {
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
            TeacherClassCourse classCourse =
                teacherClassCourseDao.getTeacherClassCourse(orgAccount.getNumber(), courseNumber);
            if (classCourse != null) {
                if (StringUtils.isNotBlank(classCourse.getReason())) {
                    try {
                        Gson gson = new Gson();
                        return gson.fromJson(classCourse.getReason(), new TypeToken<List<RefuseInfo>>() {
                        }.getType());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    /**
     * 获取课程类目
     */
    @Override
    public List<CategoryListResponseDto> getCategory(int orgId, int type) {
        List<CategoryListResponseDto> responseList = Lists.newArrayList();

        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        int orgNumber = orgAccount.getNumber();
        if (type == 1) {// 班课
            List<TeacherClassCourse> courseList =
                teacherClassCourseDao.getVisualTeacherCourseByOrgNumber(orgNumber, null, null, -1);

            Collection<Integer> collSet = new TreeSet<Integer>();
            for (TeacherClassCourse teacherClassCourse : courseList) {
                collSet.add(teacherClassCourse.getSubjectid().intValue());
            }
            if (CollectionUtils.isNotEmpty(collSet)) {
                List<Subject> subjectList = subjectDao.getByIds(collSet);
                if (CollectionUtils.isNotEmpty(subjectList)) {
                    for (Subject subject : subjectList) {
                        CategoryListResponseDto categoryListResponseDto = new CategoryListResponseDto();
                        categoryListResponseDto.setId(String.valueOf(subject.getId()));
                        categoryListResponseDto.setName(subject.getRemark_name());
                        responseList.add(categoryListResponseDto);
                    }
                }
            }
        } else if (type == 2) {// 微课
            List<OrgCourse> orgCourseList = orgCourseDao.getVisualOrgCourseByOrgNumber(orgNumber, null, -1);

            Collection<Integer> collSet = new TreeSet<Integer>();
            for (OrgCourse orgCourse : orgCourseList) {
                collSet.add(orgCourse.getSubjectId());
            }
            if (CollectionUtils.isNotEmpty(collSet)) {
                List<Subject> subjectList = subjectDao.getByIds(collSet);
                if (CollectionUtils.isNotEmpty(subjectList)) {
                    for (Subject subject : subjectList) {
                        CategoryListResponseDto categoryListResponseDto = new CategoryListResponseDto();
                        categoryListResponseDto.setId(String.valueOf(subject.getId()));
                        categoryListResponseDto.setName(subject.getRemark_name());
                        responseList.add(categoryListResponseDto);
                    }
                }
            }
        } else if (type == 3) {
            List<Teacher> teachers = teacherDao.getTeachersByOrgId(Long.valueOf(orgId), null);
            List<VideoCourse> videoCourseList = videoCourseDao.getTeacherVideoCourse(teachers, -1, null);
            if (CollectionUtils.isNotEmpty(videoCourseList)) {
                Set<String> collSet = new HashSet<String>();
                for (VideoCourse videoCourse : videoCourseList) {
                    if (collSet.contains(videoCourse.getSubjectId())) {
                        continue;
                    }

                    if (StringUtils.isNotEmpty(videoCourse.getSubjectId())) {
                        CategoryListResponseDto categoryListResponseDto = new CategoryListResponseDto();
                        categoryListResponseDto.setId(videoCourse.getSubjectId());
                        String name = videoCourse.getSubjectId();
                        name = StringUtils.substringAfterLast(name, ",");
                        categoryListResponseDto.setName(name);
                        responseList.add(categoryListResponseDto);
                        collSet.add(videoCourse.getSubjectId());
                    }
                }
            }
        }
        return responseList;
    }

    /**
     * 获取课程pv
     */
    @Override
    public CoursePvResponseDto getCoursePv(int orgId, CoursePvRequestDto coursePvRequestDto) {

        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        int orgNumber = orgAccount.getNumber();

        long courseNum = coursePvRequestDto.getCourseNumber();
        int type = coursePvRequestDto.getType();
        Date startDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 7));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 1));

        Integer courseTotalPv = null;
        Integer coursePeroidPv = null;
        boolean isAfterHours = false;

        if (type == 1) {
            TeacherClassCourse teacherClassCourse = teacherClassCourseDao.getTeacherClassCourse(orgNumber, courseNum);
            if (teacherClassCourse != null && teacherClassCourse.getExtendStatus() != null
                && teacherClassCourse.getExtendStatus() == 1 && teacherClassCourse.getPageView() != null) {
                if (teacherClassCourse.getLastSetTime() != null) {
                    if (new Date().getTime() - teacherClassCourse.getLastSetTime().getTime() >= 7200000) {
                        isAfterHours = true;
                        courseTotalPv = teacherClassCourse.getPageView();
                    }
                }
            }
        } else if (type == 2) {
            OrgCourse orgCourse = orgCourseDao.getOrgCourse(orgNumber, courseNum);
            if (orgCourse != null && orgCourse.getExtendStatus() != null && orgCourse.getExtendStatus() == 1
                && orgCourse.getPageView() != null) {
                if (orgCourse.getLastSetTime() != null) {
                    if (new Date().getTime() - orgCourse.getLastSetTime().getTime() >= 7200000) {
                        isAfterHours = true;
                        courseTotalPv = orgCourse.getPageView();
                    }
                }
            }
        }

        if (isAfterHours) {
            coursePeroidPv = orgCourseAccessDao.getCoursePeroidPv(courseNum, startDate, endDate);
            if (coursePeroidPv.intValue() > courseTotalPv.intValue()) {// 因为总pv更新可能有延迟，所以限定7天数据不能大于总数据
                coursePeroidPv = courseTotalPv;
            }
        }

        CoursePvResponseDto coursePvResponseDto = new CoursePvResponseDto();
        coursePvResponseDto.setPv(coursePeroidPv);
        coursePvResponseDto.setPvTotal(courseTotalPv);
        return coursePvResponseDto;
    }

    /**
     * 设置优先级
     */
    @Override
    public String setCoursePrior(int orgId, long courseNum, int type, int prior) {
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        int orgNumber = orgAccount.getNumber();
        if (prior == 1) {// 只有设置的时候才判断，取消的时候不判断
            int userLevel = getUserLevel(orgAccount.getNumber());// 1-普通，2-金卡，3-白金，4－钻石
            if (userLevel == 0 || userLevel == 1) {
                return "优先推广仅提供给机构会员，升级会员请联系您的师资顾问";
            }

            int priorCount = teacherClassCourseDao.getAdvertiseCourseCount(orgNumber)
                + orgCourseDao.getAdvertiseCourseCount(orgNumber);
            if (userLevel == 2 && priorCount >= 1) {
                return "金卡会员只能优先推广一门课程，升级会员请联系您的师资顾问";
            } else if (userLevel == 3 && priorCount >= 2) {
                return "白金卡会员只能优先推广两门课程，升级会员请联系您的师资顾问";
            } else if (userLevel == 4 && priorCount >= 3) {
                return "钻石卡会员只能优先推广三门课程，请关闭其他课程的优先推广";
            }
        }

        if (type == 1) {
            TeacherClassCourse teacherClassCourse = teacherClassCourseDao.getTeacherClassCourse(orgNumber, courseNum);
            teacherClassCourse.setExtendStatus(prior);
            if (prior == 1) {
                teacherClassCourse.setLastSetTime(new Date());
                teacherClassCourseDao.update(teacherClassCourse);
            } else {
                teacherClassCourse.setLastSetTime(null);
                teacherClassCourseDao.update(teacherClassCourse, true);
            }
        } else if (type == 2) {
            OrgCourse orgCourse = orgCourseDao.getOrgCourse(orgNumber, courseNum);
            orgCourse.setExtendStatus(prior);
            if (prior == 1) {
                orgCourse.setLastSetTime(new Date());
                orgCourseDao.update(orgCourse);
            } else {
                orgCourse.setLastSetTime(null);
                orgCourseDao.update(orgCourse, true);
            }

        }
        return null;
    }

    @Override
    public CourseTransformResponseDto getTransformData(int orgId, CourseTransformRequestDto courseTransformRequestDto) {

        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        int orgNumber = orgAccount.getNumber();

        int type = courseTransformRequestDto.getType();
        long courseNumber = courseTransformRequestDto.getCourseNumber();

        Date startDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 7));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 0));

        boolean isAfterHours = false;

        Integer reserverBill = null;
        Integer transTotal = null;
        Integer purchase = null;
        Integer callCount = null;

        // 留单
        if (type == 1) {

            TeacherClassCourse teacherClassCourse =
                teacherClassCourseDao.getTeacherClassCourse(orgNumber, courseNumber);
            if (teacherClassCourse != null && teacherClassCourse.getTransform() != null
                && teacherClassCourse.getExtendStatus() != null && teacherClassCourse.getExtendStatus() == 1) {
                if (teacherClassCourse.getLastSetTime() != null) {
                    if (new Date().getTime() - teacherClassCourse.getLastSetTime().getTime() >= 7200000) {
                        isAfterHours = true;
                        transTotal = teacherClassCourse.getTransform();
                        reserverBill =
                            orgStudentAdvisoryDao.getPeroidTeacherCourseAdvisory(courseNumber, startDate, endDate);
                    }
                }
            }
        } else if (type == 2) {

            OrgCourse orgCourse = orgCourseDao.getOrgCourse(orgNumber, courseNumber);
            if (orgCourse != null && orgCourse.getTransform() != null & orgCourse.getExtendStatus() != null
                && orgCourse.getExtendStatus() == 1) {
                if (orgCourse.getLastSetTime() != null) {
                    if (new Date().getTime() - orgCourse.getLastSetTime().getTime() >= 7200000) {
                        isAfterHours = true;
                        transTotal = orgCourse.getTransform();
                        reserverBill =
                            orgStudentAdvisoryDao.getPeroidOrgCourseAdvisory(courseNumber, startDate, endDate);
                    }
                }
            }
        }

        if (isAfterHours) {
            purchase = coursePurchaseDao.getCourseCountByTime(Long.valueOf(orgId), courseNumber, startDate, endDate);
            callCount = callServiceStatisticsDao.getPeroidStatistics(courseNumber, startDate, endDate);
        }

        // 电话，需要另外记录
        CourseTransformResponseDto courseTransformResponseDto = new CourseTransformResponseDto();
        courseTransformResponseDto.setCourseNumber(courseNumber);
        courseTransformResponseDto.setPurchase(purchase);
        courseTransformResponseDto.setReserverBill(reserverBill);
        courseTransformResponseDto.setPhone(callCount);
        courseTransformResponseDto.setTransTotal(transTotal);
        return courseTransformResponseDto;
    }

    @Override
    public CourseDetailResponseDto getCourseDetail(int orgId, CourseDetailRequestDto courseDetailRequestDto) {
        int type = courseDetailRequestDto.getType();
        long courseNumber = courseDetailRequestDto.getCourseNumber();

        // get orgNumber
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        int orgNumber = orgAccount.getNumber();

        CourseDetailResponseDto courseDetailResponseDto = new CourseDetailResponseDto();
        if (type == 1) {
            TeacherClassCourse teacherClassCourse =
                teacherClassCourseDao.getTeacherClassCourse(orgNumber, courseNumber);
            if (teacherClassCourse != null) {
                courseDetailResponseDto.setCourseName(teacherClassCourse.getName());
                if (teacherClassCourse.getLessonWay() == 2) {
                    courseDetailResponseDto.setPlace("在线授课");
                } else {
                    courseDetailResponseDto.setPlace(teacherClassCourse.getAddress());
                }
                courseDetailResponseDto.setPlan(teacherClassCourse.getArrangement());
                courseDetailResponseDto.setPrior(teacherClassCourse.getExtendStatus());
                courseDetailResponseDto.setStar(teacherClassCourse.getRank());
                courseDetailResponseDto.setCourseId(teacherClassCourse.getId());
                courseDetailResponseDto.setCourseNumber(teacherClassCourse.getNumber());
                courseDetailResponseDto.setCourseUrl(teacherCourseUrl + teacherClassCourse.getNumber());

                ClassCoursePhoto classCoursePhoto = classCoursePhotoDao.getById(teacherClassCourse.getCover());
                if (classCoursePhoto != null && classCoursePhoto.getStorageId() != null) {
                    courseDetailResponseDto.setCourseImg(getImageUrl(classCoursePhoto.getStorageId()));
                }

                if (teacherClassCourse.getSubjectid() != null) {
                    Subject subject = subjectDao.getById(teacherClassCourse.getSubjectid());
                    if (subject != null) {
                        courseDetailResponseDto.setCategoryName(subject.getRemark_name());
                    }
                }

                StringBuffer sb = new StringBuffer();

                Collection<Long> courseNumbers = new ArrayList<Long>();
                courseNumbers.add(courseNumber);
                Set<Long> userIdSet = new HashSet<Long>();
                List<ClassCourseSchedule> scheduleList =
                    classCourseScheduleDao.getCoursseSchedule(courseNumbers, null, Long.valueOf(orgNumber));
                if (CollectionUtils.isNotEmpty(scheduleList)) {
                    for (ClassCourseSchedule classCourseSchedule : scheduleList) {
                        Teacher teacher = teacherDao.getByUserId(classCourseSchedule.getTeacherId());
                        if (teacher != null) {
                            if (userIdSet.contains(classCourseSchedule.getTeacherId())) {
                                continue;
                            }
                            userIdSet.add(classCourseSchedule.getTeacherId());
                            int privateProtected = teacher.getPrivateProtected();
                            String privateStr = Integer.toBinaryString(privateProtected);
                            if (privateStr.substring(privateStr.length() - 1).equals("1")) {// 隐私
                                sb.append(teacher.getNickName()).append(",");
                            } else {
                                sb.append(teacher.getRealName()).append(",");
                            }
                        }
                    }
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                courseDetailResponseDto.setTeacher(sb.toString());

                // get suggest
                List<Integer> suggestions = getSuggest(type, teacherClassCourse.getRank(),
                    teacherClassCourse.getExtendStatus(), teacherClassCourse.getNumber(), orgId);
                courseDetailResponseDto.setSuggestions(suggestions);
            }
        } else if (type == 2) {
            OrgCourse orgCourse = orgCourseDao.getOrgCourse(orgNumber, courseNumber);
            if (orgCourse != null) {
                // get teacher
                List<Long> teachers = orgCourseTeacherDao.getTeacherIdsByCourseId(orgCourse.getId());
                Set<Long> userIdSet = new HashSet<Long>();
                StringBuffer sb = new StringBuffer();
                if (CollectionUtils.isNotEmpty(teachers)) {
                    for (Long userid : teachers) {
                        Teacher teacher = teacherDao.getByUserId(userid);
                        if (teacher != null) {
                            if (userIdSet.contains(userid)) {
                                continue;
                            }
                            userIdSet.add(userid);
                            int privateProtected = teacher.getPrivateProtected();
                            String privateStr = Integer.toBinaryString(privateProtected);
                            if (privateStr.substring(privateStr.length() - 1).equals("1")) {// 隐私
                                sb.append(teacher.getNickName()).append(",");
                            } else {
                                sb.append(teacher.getRealName()).append(",");
                            }
                        }
                    }
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                } else {
                    sb.append("待定");
                }
                courseDetailResponseDto.setTeacher(sb.toString());

                courseDetailResponseDto.setCourseName(orgCourse.getName());
                courseDetailResponseDto.setPlace(orgCourse.getAddress());
                if (StringUtils.isBlank(orgCourse.getLessonSummary())) {
                    courseDetailResponseDto.setPlan("待定");
                } else {
                    courseDetailResponseDto.setPlan(orgCourse.getLessonSummary());
                }

                courseDetailResponseDto.setPrior(orgCourse.getExtendStatus());
                courseDetailResponseDto.setStar(orgCourse.getRank());

                courseDetailResponseDto.setCourseId(orgCourse.getId());
                courseDetailResponseDto.setCourseNumber(orgCourse.getNumber());

                courseDetailResponseDto.setCourseUrl(orgCourseUrl + orgCourse.getNumber());
                courseDetailResponseDto
                    .setCourseImg(getImageUrl(orgCourse.getCover() == null ? null : orgCourse.getCover().longValue()));

                if (orgCourse.getSubjectId() != null) {
                    Subject subject = subjectDao.getById(orgCourse.getSubjectId());
                    if (subject != null) {
                        courseDetailResponseDto.setCategoryName(subject.getRemark_name());
                    }
                }

                List<Integer> suggestions =
                    getSuggest(type, orgCourse.getRank(), orgCourse.getExtendStatus(), orgCourse.getNumber(), orgId);
                courseDetailResponseDto.setSuggestions(suggestions);
            }
        }

        return courseDetailResponseDto;
    }

    private String getImageUrl(Long storageId) {
        String url = "";
        if (storageId == null) {
            return url;
        }
        Storage storage = storageDao.getById(storageId);
        if (storage != null) {
            String imgType = getImageType(storage.getMimetype());
            url = storageServerUrl + storage.getFid() + "_" + storage.getSn() + imgType;
        }

        return url;
    }

    private static String getImageType(String type) {
        if (StringUtils.isEmpty(type)) {
            return "";
        } else {
            if (type.contains("gif")) {
                return ".gif";
            } else if (type.contains("jpeg")) {
                return ".jpeg";
            } else if (type.contains("png")) {
                return ".png";
            } else if (type.contains("jpg")) {
                return ".jpg";
            } else {
                return "--";
            }
        }

    }

    /**
     * 获取优化建议 1.设置更有吸引力的标题 2. 使用图文 3. 让学生帮助推广
     * 
     * 4. 设置引流（点击调用接口） 5. 去排时间 6. 参加更多活动增加展示机会
     */
    private List<Integer> getSuggest(int type, Integer rank, Integer extendStatus, long courseNum, int orgId) {
        List<Integer> suggestList = new ArrayList<Integer>();
        if (rank == null || extendStatus == null) {
            return suggestList;
        }
        if (type == 1) {
            if (rank == 2) {
                suggestList.add(1);
                suggestList.add(2);
            } else if (rank == 3 || rank == 4 || rank == 5) {
                suggestList.add(1);
                suggestList.add(3);
                suggestList.add(4);
            }
        } else if (type == 2) {
            if (rank == 2) {
                suggestList.add(1);
                suggestList.add(5);
                suggestList.add(2);
            } else if (rank == 3 || rank == 4 || rank == 5) {
                suggestList.add(1);
                suggestList.add(3);
                suggestList.add(4);
            }
        }
        return suggestList;
    }

    @Override
    public Map<String, Object> getOrgPv(int orgId) {
        Map<String, Object> resultMap = Maps.newHashMap();
        // get orgNumber
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        long orgNumber = orgAccount.getNumber().longValue();

        Date startDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 30));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 0));

        List<OrgPV> pvList = orgPVDao.getOrgPv(orgNumber, startDate, endDate);

        Map<String, Integer> pvMap = new TreeMap<String, Integer>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtils.isNotEmpty(pvList)) {
            for (OrgPV orgPv : pvList) {
                String dateStr = sdf.format(orgPv.getDate());
                pvMap.put(dateStr, orgPv.getView());
            }
        }
        resultMap.put("lastDaysPv", pvMap);
        int pvTotal = orgPVDao.getOrgTotalPV(orgNumber);
        resultMap.put("pvTotal", pvTotal);
        return resultMap;
    }

    @Override
    public OrgTransformResponseDto getOrgTransform(int orgId) {
        // get orgNumber
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        long orgNumber = orgAccount.getNumber().longValue();

        Date startMonthDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 30));
        Date startWeekDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 7));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 0));

        // 电话咨询数
        int monthCall = messageDao.getPeroidOrgCall(orgNumber, startMonthDate, endDate);
        int weekCall = messageDao.getPeroidOrgCall(orgNumber, startWeekDate, endDate);
        int callTotal = messageDao.getOrgCallCount(orgNumber);

        // 留单量
        int monthLeaveBill = messageDao.getPeroidOrgLeaveBill(orgNumber, startMonthDate, endDate);
        int weekLeaveBill = messageDao.getPeroidOrgLeaveBill(orgNumber, startWeekDate, endDate);
        int leaveBillTotal = messageDao.getOrgLeaveBillCount(orgNumber);

        // 订单数
        int purchaseMonth = coursePurchaseDao.getOrgPuchaseByTime(Long.valueOf(orgId), startMonthDate, endDate);
        int purchaseWeek = coursePurchaseDao.getOrgPuchaseByTime(Long.valueOf(orgId), startWeekDate, endDate);
        int purchaseTotal = coursePurchaseDao.getTotalOrgPurchase(Long.valueOf(orgId));

        int messageMonth = imMessageInfoDao.getOrgMessageCount(orgNumber, startMonthDate, endDate);
        int messageWeek = imMessageInfoDao.getOrgMessageCount(orgNumber, startWeekDate, endDate);
        int messageTotal = imMessageInfoDao.getOrgMessageTotalCount(orgNumber);

        OrgTransformResponseDto orgTransformResponseDto = new OrgTransformResponseDto();
        orgTransformResponseDto.setLastWeekPurchase(purchaseWeek);
        orgTransformResponseDto.setLastMonthPurchase(purchaseMonth);
        orgTransformResponseDto.setPurchaseTotal(purchaseTotal);

        orgTransformResponseDto.setLastWeekReserverBill(weekLeaveBill);
        orgTransformResponseDto.setLastMonthReserverBill(monthLeaveBill);
        orgTransformResponseDto.setReserverBillTotal(leaveBillTotal);

        orgTransformResponseDto.setLastWeekPhone(weekCall);
        orgTransformResponseDto.setLastMonthPhone(monthCall);
        orgTransformResponseDto.setPhoneTotal(callTotal);

        orgTransformResponseDto.setLastWeekIm(messageWeek);
        orgTransformResponseDto.setLastMonthIm(messageMonth);
        orgTransformResponseDto.setImTotal(messageTotal);

        return orgTransformResponseDto;
    }

    /**
     * 计算pv和转化数据
     */
    @Override
    public synchronized void calculateCoursePv() {
        // 计算课程pv
        // 班课
        log.info("begin calculateCoursePv");
        int maxTeacherCourseId = teacherClassCourseDao.getMaxId();
        for (int i = 1; i <= maxTeacherCourseId; i++) {
            TeacherClassCourse teacherCourse = teacherClassCourseDao.getById(i);
            if (teacherCourse != null && teacherCourse.getOrganizationNumber() != null) {
                int pv = orgCourseAccessDao.getCourseTotalPv(teacherCourse.getNumber());
                int purchaseCount = coursePurchaseDao.getCourseTotalCount(teacherCourse.getNumber());
                int leaveBillCount = orgStudentAdvisoryDao.getTotalTeacherCourseAdvisory(Long.valueOf(i));
                int messageCount = callServiceStatisticsDao.getAllStatistics(teacherCourse.getNumber());
                int transform = purchaseCount + leaveBillCount + messageCount;
                teacherCourse.setPageView(pv);
                teacherCourse.setTransform(transform);
                teacherClassCourseDao.update(teacherCourse, "pageView", "transform");
            }
        }

        // 微课
        int maxOrgCourseId = orgCourseDao.getMaxId();
        for (int i = 1; i <= maxOrgCourseId; i++) {
            OrgCourse orgCourse = orgCourseDao.getById(i);
            if (orgCourse != null && orgCourse.getOrgNumber() != null) {
                int pv = orgCourseAccessDao.getCourseTotalPv(orgCourse.getNumber());
                int purchaseCount = coursePurchaseDao.getCourseTotalCount(orgCourse.getNumber());
                int leaveBillCount = orgStudentAdvisoryDao.getTotalOrgCourseAdvisory(Long.valueOf(i));
                int messageCount = callServiceStatisticsDao.getAllStatistics(orgCourse.getNumber());
                int transform = purchaseCount + leaveBillCount + messageCount;
                orgCourse.setPageView(pv);
                orgCourse.setTransform(transform);
                orgCourseDao.update(orgCourse, "pageView", "transform");
            }
        }

        // 视频课
        int maxVideoCourse = videoCourseDao.getMaxId();
        for (int i = 1; i <= maxVideoCourse; i++) {
            VideoCourse videoCourse = videoCourseDao.getById(i);
            if (videoCourse != null) {
                int pv = orgCourseAccessDao.getCourseTotalPv(videoCourse.getNumber());
                int purchaseCount = coursePurchaseDao.getCourseTotalCount(videoCourse.getNumber());
                int leaveBillCount = 0;
                int messageCount = callServiceStatisticsDao.getAllStatistics(videoCourse.getNumber());
                int transform = purchaseCount + leaveBillCount + messageCount;
                videoCourse.setPageView(pv);
                videoCourse.setTransform(transform);
                videoCourseDao.update(videoCourse, "pageView", "transform");
            }
        }
        log.info("end calculateCoursePv");
    }

    @Override
    public void calculateCourseCall() {
        log.info("begin calculateCourseCall");
        // 统计一天的电话数量
        Map<String, String> params = Maps.newHashMap();
        params.put("app_id", galaxyAppid);
        params.put("database", galaxyDatabase);

        String day = "";
        DateTime d = new DateTime(new Date().getTime());
        long ts = 0;
        if (d.getHourOfDay() == 0 || d.getHourOfDay() == 1) {// 0点-2点更新昨天一天的。
            day = JodaDateUtil.getDayBegin(new Date().getTime(), 1);
            ts = JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 1);
        } else {
            day = JodaDateUtil.getDayBegin(new Date().getTime(), 0);
            ts = JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 0);
        }

        day = StringUtils.replace(day, "-", "");

        Date currentDate = new Date(ts);

        StringBuilder sb = new StringBuilder();
        sb.append(
            "select request_path_key,count(request_path_key) total from click_ctr_real_log where location like '%consult%' and pt='");
        sb.append(day).append("' group by request_path_key");

        params.put("query", sb.toString());

        log.info("[calculateCourseCall]query string=" + sb.toString());

        String result = null;
        try {
            result = HttpClientUtils.doJsonPost(galaxyQueryApi, params, "UTF-8", 600000);
            log.info("result=" + result);
            GalaxyCallResponseDto galaxyCallResponseDto = JacksonUtil.str2Obj(result, GalaxyCallResponseDto.class);
            if (galaxyCallResponseDto.getCode() == 0) {
                List<CallResponse> callList = galaxyCallResponseDto.getRows();
                if (CollectionUtils.isNotEmpty(callList)) {
                    for (CallResponse callResponse : callList) {
                        Long courseNumber = callResponse.getRequest_path_key();
                        if (courseNumber == null) {
                            continue;
                        }
                        // saveOrUpdate
                        CallServiceStatistics callServiceStatistics =
                            callServiceStatisticsDao.getStatistics(courseNumber, currentDate);
                        if (callServiceStatistics != null) {
                            callServiceStatistics.setTotalCount(callResponse.getTotal());
                            callServiceStatistics.setUpdateAt(new Date());
                            callServiceStatisticsDao.update(callServiceStatistics);
                        } else {
                            CallServiceStatistics newStatistics = new CallServiceStatistics();
                            newStatistics.setCourseNumber(courseNumber);
                            newStatistics.setDay(currentDate);
                            newStatistics.setTotalCount(callResponse.getTotal());
                            newStatistics.setUpdateAt(new Date());
                            callServiceStatisticsDao.save(newStatistics, true);
                        }
                    }
                }

            }
        } catch (Exception e) {
            log.error("calculateCourseCall error", e);
            e.printStackTrace();
        }
        log.info("end calculateCourseCall");
    }

    @Override
    public void calculateRank() {
        log.info("begin calculateRank");

        // 获取排名前10的课程number
        Map<String, String> params = Maps.newHashMap();
        params.put("app_id", galaxyAppid);
        params.put("database", galaxyDatabase);

        String startDayStr = JodaDateUtil.getDayBegin(new Date().getTime(), 7).replaceAll("-", "");
        String endDayStr = JodaDateUtil.getDayBegin(new Date().getTime(), 0).replaceAll("-", "");

        StringBuilder sb = new StringBuilder("");

        // sb.append("select td.class_number classnumber, (sum(td.rank)+sum(td.offset)) ranksum ");
        sb.append("select td.class_number classnumber ");
        sb.append(" from search_course_data td ");
        sb.append(" where td.pt>='").append(startDayStr).append("' ");
        sb.append(" and td.pt<='").append(endDayStr).append("' ");
        sb.append(" and td.class_number!='' ");
        sb.append(" group by td.class_number having (sum(td.rank)+sum(td.offset))<=10");

        params.put("query", sb.toString());

        Set<Long> topSet = new HashSet<Long>();

        Set<TopSearch> topSearchSet = new HashSet<TopSearch>();
        String result = null;
        try {
            result = HttpClientUtils.doJsonPost(galaxyQueryApi, params, "UTF-8", 600000);
            GalaxyTopSearchResponseDto galaxyTopSearchResponseDto =
                JacksonUtil.str2Obj(result, GalaxyTopSearchResponseDto.class);
            topSearchSet = galaxyTopSearchResponseDto.getRows();
            if (CollectionUtils.isNotEmpty(topSearchSet)) {
                for (TopSearch topSearch : topSearchSet) {
                    topSet.add(topSearch.getClassnumber());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info(result);

        Date startDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 7));
        Date endDate = new Date(JodaDateUtil.getDayBeginTimeStamp(new Date().getTime(), 0));

        // 先计算班课星级
        int maxTeacherCourseId = teacherClassCourseDao.getMaxId();
        for (int i = 1; i <= maxTeacherCourseId; i++) {
            TeacherClassCourse teacherCourse = teacherClassCourseDao.getById(i);
            if (teacherCourse != null && teacherCourse.getOrganizationNumber() != null) {// 计算星级
                // 判断下线的和停招的暂停推广(end_time>now() and (status=2 or verify_status=2))
                if (teacherCourse.getEndTime() != null) {
                    if (teacherCourse.getEndTime().getTime() < System.currentTimeMillis()) {
                        teacherCourse.setExtendStatus(0);
                        teacherClassCourseDao.update(teacherCourse, "extendStatus");
                    }
                }
                if (teacherCourse.getStatus() != null && teacherCourse.getVerifyStatus() != null) {
                    if (!(teacherCourse.getStatus() == 2 || teacherCourse.getVerifyStatus() == 2)) {
                        teacherCourse.setExtendStatus(0);
                        teacherClassCourseDao.update(teacherCourse, "extendStatus");
                    }
                }
                Long courseNumber = teacherCourse.getNumber();
                Integer verifyStatus = teacherCourse.getVerifyStatus();
                List<String> blobList =
                    teacherClassCourseDao.getBlobString(teacherCourse.getOrganizationNumber(), courseNumber);
                String introduce = "";
                if (CollectionUtils.isNotEmpty(blobList)) {
                    introduce = blobList.get(0);
                }
                if (verifyStatus == 2) {// 审核拒绝的，一星级
                    teacherCourse.setRank(1);
                    teacherCourse.setExtendStatus(0);
                    teacherClassCourseDao.update(teacherCourse, "rank", "extendStatus");
                } else {
                    if (introduce == null || !introduce.contains("<img")) {
                        teacherCourse.setRank(2);
                        teacherCourse.setExtendStatus(0);
                        teacherClassCourseDao.update(teacherCourse, "rank", "extendStatus");
                    } else {
                        // 计算三四五星级
                        // 获取平均访问量
                        int coursePeroidPv = orgCourseAccessDao.getCoursePeroidPv(courseNumber, startDate, endDate);

                        boolean isContain = topSet.contains(courseNumber);
                        if (coursePeroidPv >= 14) {
                            if (isContain) {
                                teacherCourse.setRank(5);
                                teacherClassCourseDao.update(teacherCourse, "rank");
                            } else {
                                teacherCourse.setRank(4);
                                teacherClassCourseDao.update(teacherCourse, "rank");
                            }

                        } else {
                            teacherCourse.setRank(3);
                            teacherClassCourseDao.update(teacherCourse, "rank");
                        }

                    }

                }

            }
        }

        // 微课
        int maxOrgCourseId = orgCourseDao.getMaxId();
        for (int i = 1; i <= maxOrgCourseId; i++) {
            OrgCourse orgCourse = orgCourseDao.getById(i);
            if (orgCourse != null && orgCourse.getOrgNumber() != null) {
                Integer status = orgCourse.getStatus();
                if (status != null && status != 0) {
                    orgCourse.setExtendStatus(0);
                    orgCourseDao.update(orgCourse, "extendStatus");
                }
                Long courseNumber = orgCourse.getNumber();
                int coursePeroidPv = orgCourseAccessDao.getCoursePeroidPv(courseNumber, startDate, endDate);
                boolean isContainTop = topSet.contains(courseNumber);
                List<String> blobList = orgCourseDao.getBlobString(orgCourse.getOrgNumber(), courseNumber);
                String introduce = "";
                if (CollectionUtils.isNotEmpty(blobList)) {
                    introduce = blobList.get(0);
                }
                boolean isHasPic = false;
                boolean isArrangeClass = false;
                if (StringUtils.isNotBlank(introduce) && introduce.contains("<img")) {
                    isHasPic = true;
                }
                if (orgCourse.getBeginTime() != null || StringUtils.isNotBlank(orgCourse.getLessonSummary())) {
                    isArrangeClass = true;
                }

                if (isArrangeClass) {
                    if (isHasPic) {
                        if (coursePeroidPv >= 14) {
                            if (isContainTop) {
                                orgCourse.setRank(5);
                                orgCourseDao.update(orgCourse, "rank");
                            } else {
                                orgCourse.setRank(4);
                                orgCourseDao.update(orgCourse, "rank");
                            }
                        } else {
                            orgCourse.setRank(3);
                            orgCourseDao.update(orgCourse, "rank");
                        }
                    } else {
                        orgCourse.setRank(2);
                        orgCourse.setExtendStatus(0);
                        orgCourseDao.update(orgCourse, "rank", "extendStatus");
                    }
                } else {
                    orgCourse.setRank(2);
                    orgCourse.setExtendStatus(0);
                    orgCourseDao.update(orgCourse, "rank", "extendStatus");
                }

            }
        }

        log.info("end calculateRank");
    }

    @Override
    public void addClickRecord(int orgId, Long courseNumber, int type) {
        OrgClickLog orgClickLog = new OrgClickLog();
        orgClickLog.setOrgId(orgId);
        orgClickLog.setType(type);
        orgClickLog.setCourseNumber(courseNumber);
        orgClickLog.setCreateTime(new Date());
        orgClickLogDao.save(orgClickLog);
    }

    @Override
    public boolean hasClickRecord(int orgId, Long courseNumber, int type) {
        OrgClickLog orgClickLog = orgClickLogDao.getOrgCourseClick(orgId, courseNumber, type);
        if (orgClickLog == null) {
            return false;
        }
        return true;
    }

    @Override
    public int getUserLevel(long orgNumber) {

        Map<String, String> params = Maps.newHashMap();
        params.put("orgNumber", String.valueOf(orgNumber));

        String result = null;
        try {
            result = HttpClientUtils.doPost(userLevelUrl, params, "UTF-8");
            UserLevelResponseDto userLevelResponseDto = JacksonUtil.str2Obj(result, UserLevelResponseDto.class);
            return userLevelResponseDto.getData();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public CommonInfoResponse getCommonInfo(int orgId) {
        CommonInfoResponse commonInfoResponse = new CommonInfoResponse();
        commonInfoResponse.setId(orgId);
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
        if (orgInfo != null) {
            commonInfoResponse.setName(orgInfo.getName());
        }
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
        if (orgAccount != null) {
            commonInfoResponse.setLevel(getUserLevel(orgAccount.getNumber()));
        }
        return commonInfoResponse;
    }

    @Override
    public List<DiscoveryResponseDto> getDiscoveryInfo(boolean hasSmartPromote, String version) {
        List<DiscoveryResponseDto> respList = Lists.newArrayList();

        ApplicationContext application = this.getApplicationContext();
        CourseAdvertiseServiceImpl tmp = (CourseAdvertiseServiceImpl) application.getBean("courseAdvertiseService");

        for (Discovery discovery : Discovery.values()) {
            // 如果当前app的版本号比配置的要低，则不显示
            if (version.compareTo(String.valueOf(discovery.getVersion())) < 0) {
                continue;
            }
            DiscoveryResponseDto discoveryResponseDto = new DiscoveryResponseDto();
            discoveryResponseDto.setGroup(discovery.getGroup());
            discoveryResponseDto.setEvent(discovery.getEvent());
            discoveryResponseDto.setVersion(discovery.getVersion());
            discoveryResponseDto.setTitle(discovery.getTitle());
            discoveryResponseDto.setIcon(discovery.getIcon());

            try {
                String refUrl =
                    (String) FieldUtils.getField(CourseAdvertiseServiceImpl.class, discovery.getUrl(), true).get(tmp);
                discoveryResponseDto.setUrl(refUrl);
            } catch (Exception e) {
                e.printStackTrace();
            }

            discoveryResponseDto.setAuth(discovery.getAuth());
            if (StringUtils.isNotEmpty(displayItems) && displayItems.contains(discovery.getEvent())) {
                if (discovery.getEvent().equals("tx_event_smartpromotion")) {
                    if (hasSmartPromote) {
                        respList.add(discoveryResponseDto);
                    }
                } else {
                    respList.add(discoveryResponseDto);
                }
            }
        }
        return respList;
    }

}
