package com.baijia.tianxiao.sal.tuiguang.api;

import com.baijia.tianxiao.sal.tuiguang.dto.request.CourseDetailRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CourseListRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CoursePvRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.request.CourseTransformRequestDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CategoryListResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CommonInfoResponse;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseDetailResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseListPageResponse;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CoursePvResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.CourseTransformResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.DiscoveryResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.OrgTransformResponseDto;
import com.baijia.tianxiao.sal.tuiguang.dto.response.RefuseInfo;

import java.util.List;
import java.util.Map;

public interface CourseAdvertiseService {

    /**
     * 获取机构下面的所有类目
     * 
     * @param orgId
     * @param type
     * @return
     */
    public List<CategoryListResponseDto> getCategory(int orgId, int type);

    /**
     * 课程列表页面
     * 
     * @param courseListRequestDto
     * @return
     */
    public CourseListPageResponse getCourseList(int orgId, CourseListRequestDto courseListRequestDto);

    public List<RefuseInfo> getRejectReason(int orgId, long courseNumber, int type);

    public String setCoursePrior(int orgId, long courseNum, int type, int prior);

    public CoursePvResponseDto getCoursePv(int orgId, CoursePvRequestDto coursePvRequestDto);

    public CourseTransformResponseDto getTransformData(int orgId, CourseTransformRequestDto courseTransformRequestDto);

    public CourseDetailResponseDto getCourseDetail(int orgId, CourseDetailRequestDto courseDetailRequestDto);

    public Map<String, Object> getOrgPv(int orgId);

    public OrgTransformResponseDto getOrgTransform(int orgId);

    public void addClickRecord(int orgId, Long courseNumber, int type);
    
    public boolean hasClickRecord(int orgId, Long courseNumber, int type);

    public void calculateCoursePv();
    
    public void calculateCourseCall();

    public void calculateRank();
    
    public int getUserLevel(long orgNumber);
    
    public CommonInfoResponse getCommonInfo(int orgId);
    
    public List<DiscoveryResponseDto> getDiscoveryInfo(boolean hasSmartPromote,String version);
    
}
