
package com.baijia.tianxiao.sal.tuiguang.enums;


import com.baijia.tianxiao.sal.tuiguang.contants.TuiGuangConfig;

public enum Discovery {
    //group 需要按照顺序进行配置，event需要和app端协同配置
    TIANXIAO_YINGXIAO_SENDACTIVITY(1, "tx_event_send_activity", 1, "发活动", "https://imgs.genshuixue.com/5547884_7uagsbo4.png", "sendActivityUrl", 0),
    TIANXIAO_YINGXIAO_DRAW(1, "tx_event_draw", 1, "抽奖", "https://imgs.genshuixue.com/6331912_6je1x17v.png", "drawActivityUrl", 0),
    TIANXIAO_YINGXIAO_ARTICLE(1, "tx_event_article", TuiGuangConfig.LAST_APP_VERSION, "全网爆文", "https://imgs.genshuixue.com/9054917_4fc5hzuo.jpg", "articleActivityUrl", 0),
    TIANXIAO_YINGXIAO_VOTE(1, "tx_event_vote", 1.1f, "投票", "https://imgs.genshuixue.com/7092417_kt1et2o8.png", "voteActivityUrl", 0),
    TIANXIAO_YINGXIAO_REFERRAL(1, "tx_event_referral", 1.1f, "转介绍", "https://imgs.genshuixue.com/7641604_hirs6uoc.png", "referralActivityUrl", 0),

    TIANXIAO_YINGXIAO_COUPON(2, "tx_event_coupon", 1, "优惠券", "https://imgs.genshuixue.com/5547889_g0dieaqm.png", "couponUrl", 0),
    TIANXIAO_YINGXIAO_RUSHSOURCE(2, "tx_event_rushsource", 1, "抢生源", "https://imgs.genshuixue.com/5745210_3cxe27aj.png", "rushSourceUrl", 0),
    TIANXIAO_YINGXIAO_RENTROOM(2, "tx_event_rentroom", 1, "教室出租", "https://imgs.genshuixue.com/5745219_m30qh7vf.png", "rentRoomUrl", 0),
    TIANXIAO_YINGXIAO_DISCOUNT(2, "tx_event_discount", 1, "限时折扣", "https://imgs.genshuixue.com/7428086_4a5hr5uv.png", "discountUrl", 0),
    TIANXIAO_YINGXIAO_BENEFIT(2, "tx_event_benefit", 1, "联报优惠", "https://imgs.genshuixue.com/7417761_tetnmre6.png", "benefitUrl", 0),

    TIANXIAO_YINGXIAO_SMARTPROMOTION(3, "tx_event_smartpromotion", 1, "智能推广", "https://imgs.genshuixue.com/5548045_e6b1c6ma.png", "smartPromotionUrl", 0),
    TIANXIAO_YINGXIAO_PROMOTION(3, "tx_event_promotion", 1, "跟谁学推广", "https://imgs.genshuixue.com/5547886_kkrupv78.png", "promotionUrl", 0),

    TIANXIAO_GROUP_SEND(4, "tx_group_send_history", 1.1f, "群发消息", "https://imgs.genshuixue.com/7335431_r5ha0wtk.png", "groupSendUrl", 0);


    private int group;
    private String event;
    private float version;
    private String title;
    private String icon;
    private String url;
    private Integer auth;

    Discovery(int group, String event, float version, String title, String icon, String url, Integer auth) {
        this.group = group;
        this.event = event;
        this.version = version;
        this.title = title;
        this.icon = icon;
        this.url = url;
        this.auth = auth;
    }

    public int getGroup() {

        return group;
    }

    public void setGroup(int group) {

        this.group = group;
    }

    public String getEvent() {

        return event;
    }

    public void setEvent(String event) {

        this.event = event;
    }

    public String getTitle() {

        return title;
    }

    public void setTitle(String title) {

        this.title = title;
    }

    public String getIcon() {

        return icon;
    }

    public void setIcon(String icon) {

        this.icon = icon;
    }

    public float getVersion() {

        return version;
    }

    public void setVersion(float version) {

        this.version = version;
    }

    public String getUrl() {

        return url;
    }

    public void setUrl(String url) {

        this.url = url;
    }

    public Integer getAuth() {

        return auth;
    }

    public void setAuth(Integer auth) {

        this.auth = auth;
    }

}

    