/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.teacher.impl;

import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.teacher.api.TeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherResponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TeacherServiceImpl
implements TeacherService {
    private static final Logger logger = LoggerFactory.getLogger(TeacherServiceImpl.class);
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private StorageDao storageDao;

    @Override
    public List<OrgTeacherResponseDto> getOrgTeacherList(Long orgId, PageDto pageDto) {
        List teachers = this.teacherDao.getTeachersByOrgId(orgId, pageDto, new String[0]);
        String host = PropertiesReader.getValue((String)"wxm", (String)"gsx-m.server");
        return this.buildTeacherResponse(teachers, host);
    }

    private Map<Long, Storage> getAndCacheStorage(List<Teacher> teachers) {
        List ids = BaseUtils.getListFilter(teachers, (String)"avatar");
        Map cache = this.storageDao.getStorageMapByIds((Collection)ids);
        logger.debug("ids:{},cache:{}", (Object)ids, (Object)cache);
        return cache;
    }

    private Map<Long, User> getAndCachedUser(List<Teacher> teachers) {
        Map cache = null;
        try {
            List userIds = BaseUtils.getListFilter(teachers, (String)"userId");
            cache = this.userDao.getMapByIds((Collection)userIds, new String[0]);
            logger.debug("userIds:{},cache:{}", (Object)userIds, (Object)cache);
        }
        catch (Exception e) {
            logger.error("getAndCachedUser failed, e:{}", (Throwable)e);
        }
        return cache;
    }

    public String constructUrl(Storage storage, String imgServer) {
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = "";
        if (StringUtils.isNotBlank((String)storage.getMimetype())) {
            surfix = storage.getMimetype().contains("/") ? storage.getMimetype().split("/")[1] : storage.getMimetype();
        }
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    public OrgTeacherResponseDto getOrgTeacherDetail(Long orgId, Long userId) {
        User user;
        Teacher teacher = this.teacherDao.getByUserId(userId, new String[0]);
        OrgTeacherResponseDto dto = null;
        if (teacher != null && orgId != null && teacher.getOrgId() != null && teacher.getOrgId().longValue() == orgId.longValue() && (user = (User)this.userDao.getById((Serializable)userId, new String[0])) != null) {
            String host = PropertiesReader.getValue((String)"wxm", (String)"gsx-m.server");
            dto = new OrgTeacherResponseDto();
            Long storageId = teacher.getAvatar();
            if (storageId != null) {
                Storage storage = (Storage)this.storageDao.getById((Serializable)teacher.getAvatar(), new String[0]);
                if (storage != null) {
                    dto.setAvatar(StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
                }
            } else {
                dto.setAvatar("");
            }
            dto.setNumber(user.getNumber());
            dto.setTeacherName(teacher.getRealName());
            dto.setLink(host + "/" + user.getNumber());
            dto.setUserId(userId);
        }
        return dto;
    }

    @Override
    public List<OrgTeacherResponseDto> getOrgTeacherList(Long orgId, Collection<Long> userIds) {
        List teachers = this.teacherDao.getByTeacherIds(userIds, new String[0]);
        return this.buildTeacherResponse(teachers, null);
    }

    private List<OrgTeacherResponseDto> buildTeacherResponse(List<Teacher> teachers, String host) {
        ArrayList data = Lists.newArrayList();
        if (teachers != null && !teachers.isEmpty()) {
            Map<Long, Storage> storageCache = this.getAndCacheStorage(teachers);
            Map<Long, User> userCache = this.getAndCachedUser(teachers);
            OrgTeacherResponseDto dto = null;
            for (Teacher teacher : teachers) {
                dto = new OrgTeacherResponseDto();
                Long userId = teacher.getUserId();
                if (userCache != null && userCache.containsKey(userId)) {
                    User user = userCache.get(userId);
                    dto.setNumber(user.getNumber());
                    dto.setLink(host + "/" + user.getNumber());
                }
                dto.setTeacherName(teacher.getRealName() == null ? "\u5f85\u5b9a" : teacher.getRealName());
                Long storageId = teacher.getAvatar();
                if (storageId != null && storageCache.containsKey(storageId)) {
                    Storage storage = storageCache.get((long)storageId);
                    if (storage != null) {
                        dto.setAvatar(StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
                    }
                } else {
                    dto.setAvatar("");
                }
                dto.setUserId(teacher.getUserId());
                dto.setDescr(teacher.getShortIntroduce() == null ? "" : teacher.getShortIntroduce());
                dto.setOtherInfo(teacher.getOtherInfo() == null ? "" : teacher.getOtherInfo());
                data.add(dto);
            }
        }
        logger.info("getOrgTeacherList.data:{}", (Object)data);
        return data;
    }

    @Override
    public Map<Long, OrgTeacherResponseDto> getOrgTeacherMap(Long orgId, Collection<Long> userIds) {
        return CollectorUtil.collectMap(this.getOrgTeacherList(orgId, userIds), (Function)new Function<OrgTeacherResponseDto, Long>(){

            public Long apply(OrgTeacherResponseDto arg0) {
                return arg0.getUserId();
            }
        });
    }
}

