/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.teacher.impl;

import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.ClassHour;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.solr.dto.OrgTeacherDocument;
import com.baijia.tianxiao.dal.solr.enums.OrgTeacherMarkType;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.TeacherModifiedDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.TeacherModified;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ErpErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.elastic.service.FilterSoftDelTeacherService;
import com.baijia.tianxiao.sal.elastic.service.OrgTeacherDocumentImportService;
import com.baijia.tianxiao.sal.elastic.service.OrgTeacherDocumentQueryService;
import com.baijia.tianxiao.sal.push.constant.Config;
import com.baijia.tianxiao.sal.push.utils.RestUtil;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherInfoDto;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeachersDto;
import com.baijia.tianxiao.sal.teacher.dto.request.TeacherInfoRequest;
import com.baijia.tianxiao.sal.teacher.enums.OrgTeacherSource;
import com.baijia.tianxiao.sal.teacher.exception.MongoDbServerException;
import com.baijia.tianxiao.sal.teacher.util.OrgTeacherUtil;
import com.baijia.tianxiao.sal.teacher.util.TeacherErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HtmlUtils;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgTeacherServiceImpl
implements OrgTeacherService {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherServiceImpl.class);
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private TeacherModifiedDao teacherModifiedDao;
    @Autowired(required=false)
    private OrgTeacherDocumentQueryService orgTeacherDocumentQueryService;
    @Autowired
    private FilterSoftDelTeacherService filterSoftDelTeacherService;
    @Autowired
    private OrgTeacherDocumentImportService orgTeacherDocumentImportService;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;

    @Override
    public OrgTeacherInfoDto saveTeacher(Long orgId, TeacherInfoRequest request, Long szManagerId) {
        List temp;
        Preconditions.checkArgument((request.getName() != null && request.getName().length() <= 15 ? 1 : 0) != 0, (Object)"\u59d3\u540d\u5fc5\u586b,\u800c\u4e14\u4e0d\u80fd\u5927\u4e8e15\u4e2a\u5b57");
        OrgTeacher orgTeacher = null;
        if (request.getId() == null) {
            temp = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), Integer.valueOf(1), new String[0]);
            log.info("find all temp orgTeacher is :{} ", (Object)temp);
            if (temp != null && temp.size() > 0) {
                throw new BussinessException((UniverseErrorCode)TeacherErrorCode.MOBILE_DOUBLE);
            }
        } else {
            orgTeacher = (OrgTeacher)this.orgTeacherDao.getById((Serializable)request.getId(), new String[0]);
            if (!request.getMobile().equals(orgTeacher.getMobile()) && (temp = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), Integer.valueOf(1), new String[0])) != null && temp.size() > 0) {
                throw new BussinessException((UniverseErrorCode)TeacherErrorCode.MOBILE_DOUBLE);
            }
        }
        if (request.getId() == null) {
            orgTeacher = new OrgTeacher();
            orgTeacher.setType(Integer.valueOf(OrgTeacherSource.TIANXIAO.getStatus()));
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            if (orgAccount != null) {
                orgTeacher.setOrgNumber(orgAccount.getNumber());
            }
            orgTeacher.setOrgManagerId(szManagerId);
        }
        OrgTeacherServiceImpl.saveOrEditTeacher(orgTeacher, request, orgId);
        this.saveOrUpdateOrgTeacher(orgTeacher, request, orgId);
        this.saveOrUpdateOrgTeacher(orgId, Arrays.asList(orgTeacher.getUserId()));
        return this.detail(orgTeacher.getId());
    }

    private void saveOrUpdateOrgTeacher(Long orgId, List<Long> teacherUserIds) {
        Date beginDate = null;
        Date endDate = null;
        Date timestamp = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(timestamp);
        c.add(2, 1);
        Date time2 = c.getTime();
        Date time1 = timestamp;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-01 00:00:00");
        try {
            beginDate = format.parse(format.format(time1));
            endDate = format.parse(format.format(time2));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Map createOrgTeacherDocuments = null;
        if (GenericsUtils.notNullAndEmpty(teacherUserIds)) {
            createOrgTeacherDocuments = this.orgTeacherDocumentImportService.createOrgTeacherDocuments(orgId, teacherUserIds, beginDate, endDate, true, true);
        }
        log.info("createOrgTeacherDocuments are :{} ", createOrgTeacherDocuments);
    }

    @Override
    public OrgTeacherInfoDto saveTeacherOld(Long orgId, TeacherInfoRequest request, Long szManagerId) {
        User user;
        List temp;
        Preconditions.checkArgument((request.getName() != null && request.getName().length() <= 15 ? 1 : 0) != 0, (Object)"\u59d3\u540d\u5fc5\u586b,\u800c\u4e14\u4e0d\u80fd\u5927\u4e8e15\u4e2a\u5b57");
        OrgTeacher orgTeacher = null;
        if (request.getId() == null) {
            temp = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), Integer.valueOf(1), new String[0]);
            if (temp != null && temp.size() > 0) {
                throw new BussinessException((UniverseErrorCode)TeacherErrorCode.MOBILE_DOUBLE);
            }
        } else {
            orgTeacher = (OrgTeacher)this.orgTeacherDao.getById((Serializable)request.getId(), new String[0]);
            if (!request.getMobile().equals(orgTeacher.getMobile()) && (temp = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), Integer.valueOf(1), new String[0])) != null && temp.size() > 0) {
                throw new BussinessException((UniverseErrorCode)TeacherErrorCode.MOBILE_DOUBLE);
            }
        }
        if (request.getId() == null) {
            orgTeacher = new OrgTeacher();
            orgTeacher.setType(Integer.valueOf(OrgTeacherSource.TIANXIAO.getStatus()));
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            if (orgAccount != null) {
                orgTeacher.setOrgNumber(orgAccount.getNumber());
            }
            orgTeacher.setOrgManagerId(szManagerId);
        }
        if (orgTeacher.getUserId() == null) {
            Map<String, Long> userInfoMap = OrgTeacherUtil.getUserIdAndNumber(orgId, request.getMobile(), request.getName());
            orgTeacher.setUserId(userInfoMap.get("id"));
        }
        Teacher teacher = this.teacherDao.getByUserId(orgTeacher.getUserId(), new String[0]);
        TeacherModified teacherModified = this.teacherModifiedDao.getByUserId(orgTeacher.getUserId(), new String[0]);
        this.saveOrUpdateOrgTeacher(orgTeacher, request, orgId);
        this.SaveOrUpdateCdbTeacher(teacher, request, orgId, orgTeacher);
        this.SaveOrUpdateCdbTeacherModify(teacherModified, request, orgId, orgTeacher);
        if (request.getId() == null && (user = (User)this.userDao.getById((Serializable)orgTeacher.getUserId(), new String[0])) != null) {
            this.orgTeacherDao.saveCdbOrgTeacher(orgTeacher.getUserId(), user.getNumber(), orgId);
        }
        return this.detail(orgTeacher.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(Long teacherId) {
        OrgTeacher orgTeacher = (OrgTeacher)this.orgTeacherDao.getById((Serializable)teacherId, new String[0]);
        if (orgTeacher != null) {
            HashSet teacherIds = Sets.newHashSet();
            teacherIds.add(orgTeacher.getId());
            int count = this.checkoutHasClassRecord(orgTeacher.getOrgId().intValue(), teacherIds);
            if (count != 0) {
                throw new BussinessException((UniverseErrorCode)ErpErrorCode.TEACHER_HAS_CLASS_RECORD);
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        this.hardDelOrgTeacher(orgTeacher);
        this.saveOrUpdateOrgTeacher(orgTeacher.getOrgId(), Arrays.asList(orgTeacher.getUserId()));
    }

    private void hardDelOrgTeacher(OrgTeacher orgTeacher) {
        TeacherModified teacherModified;
        orgTeacher.setStatus(Integer.valueOf(OrgTeacherStatus.TERMINATED.getCode()));
        orgTeacher.setFireTime(new Date());
        log.info("del teacher == {}", (Object)orgTeacher);
        this.orgTeacherDao.update((Object)orgTeacher, new String[0]);
        Teacher teacher = this.teacherDao.getByUserId(orgTeacher.getUserId(), new String[0]);
        if (teacher != null) {
            teacher.setOrgId(null);
            teacher.setUpdatedAt(new Date());
            this.teacherDao.update((Object)teacher, Boolean.valueOf(true), new String[]{"orgId"});
        }
        if ((teacherModified = this.teacherModifiedDao.getByUserId(orgTeacher.getUserId(), new String[0])) != null) {
            teacherModified.setOrgId(null);
            teacherModified.setUpdatedAt(new Date());
            this.teacherModifiedDao.update((Object)teacherModified, Boolean.valueOf(true), new String[]{"orgId"});
        }
    }

    @Override
    public OrgTeacherInfoDto detail(Long teacherId) {
        Teacher teacher;
        OrgTeacher orgTeacher = (OrgTeacher)this.orgTeacherDao.getById((Serializable)teacherId, new String[0]);
        log.info("orgTeacher is :{} ", (Object)orgTeacher);
        OrgTeacherInfoDto orgTeacherInfoDto = new OrgTeacherInfoDto();
        if (orgTeacher != null && (teacher = this.teacherDao.getByUserId(orgTeacher.getUserId(), new String[0])) != null) {
            User user;
            Storage storage;
            orgTeacherInfoDto.setUserId(teacher.getUserId());
            orgTeacherInfoDto.setId(orgTeacher.getId());
            orgTeacherInfoDto.setName(teacher.getRealName());
            orgTeacherInfoDto.setAvatar(teacher.getAvatar());
            if (teacher.getAvatar() != null && (storage = (Storage)this.storageDao.getById((Serializable)teacher.getAvatar(), new String[0])) != null) {
                String avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
                orgTeacherInfoDto.setAvatarUrl(avatarUrl);
            }
            if (teacher.getBirthday() != null) {
                orgTeacherInfoDto.setBirthday(teacher.getBirthday().getTime());
            }
            if ((user = (User)this.userDao.getById((Serializable)teacher.getUserId(), new String[0])) != null) {
                orgTeacherInfoDto.setNumber(user.getNumber());
            }
            orgTeacherInfoDto.setDescr(teacher.getIntroduce() != null && !teacher.getIntroduce().equals("\u65e0") ? teacher.getIntroduce() : "");
            orgTeacherInfoDto.setStatus(orgTeacher.getUseStatus());
            Map hasClassRecords = this.filterSoftDelTeacherService.hasClassRecord(Integer.valueOf(orgTeacher.getOrgId().intValue()), Arrays.asList(teacherId), new Boolean[0]);
            boolean hasClassRecord = hasClassRecords.get(orgTeacher.getId()) != null && (Boolean)hasClassRecords.get(orgTeacher.getId()) != false;
            log.info("useStatus :{} and hasClassRecord:{} ", (Object)orgTeacher.getUseStatus(), (Object)hasClassRecord);
            orgTeacherInfoDto.setMarkType(OrgTeacherMarkType.getMarkType((int)orgTeacher.getUseStatus(), (boolean)hasClassRecord));
            orgTeacherInfoDto.setMobile(orgTeacher.getMobile());
            orgTeacherInfoDto.setGender(teacher.getSex());
            orgTeacherInfoDto.setRemark(teacher.getOtherInfo() == null || teacher.getOtherInfo().equals("\u65e0") ? "" : HtmlUtils.delHTMLTag((String)teacher.getOtherInfo()));
        }
        return orgTeacherInfoDto;
    }

    @Override
    public List<OrgTeacherInfoDto> list(Long orgId, Long lastId, Integer pageSize) {
        List orgTeachers = this.orgTeacherDao.listByLastId(orgId, lastId, pageSize, Boolean.valueOf(true), Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), new String[0]);
        if (orgTeachers == null) {
            return GenericsUtils.emptyList();
        }
        return this.buildOrgTeacherInfo(orgId, orgTeachers);
    }

    @Override
    public List<OrgTeacherInfoDto> listByOrgTeacherIds(Long orgId, List<Long> teacherIds) {
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("id", teacherIds);
        condition.put("status", OrgTeacherStatus.SIGNED.getCode());
        List orgTeachers = this.orgTeacherDao.queryByCondition((Map)condition, null, new String[0]);
        return this.buildOrgTeacherInfo(orgId, orgTeachers);
    }

    @Override
    public Map<Long, OrgTeacherInfoDto> queryMapByOrgTeacherIds(Long orgId, List<Long> teacherIds) {
        List<OrgTeacherInfoDto> list = this.listByOrgTeacherIds(orgId, teacherIds);
        HashMap map = Maps.newHashMap();
        for (OrgTeacherInfoDto dto : list) {
            map.put(dto.getId(), dto);
        }
        return map;
    }

    @Override
    public List<OrgTeacherInfoDto> list(TeacherInfoRequest teacherInfoRequest) {
        log.info("teacherInfoRequest is :{} ", (Object)teacherInfoRequest);
        List<OrgTeacherDocument> orgTeachers = null;
        try {
            orgTeachers = this.listDocs(teacherInfoRequest);
        }
        catch (Exception e) {
            log.warn("can not find OrgTeacherInfoDto cause by mongoDBServerExcepiton:{} ,so will return default value with request1:{} ", (Object)e, (Object)teacherInfoRequest);
            List orgTeacheres = this.orgTeacherDao.listByPageDto(teacherInfoRequest.getOrgId(), teacherInfoRequest.getUseStatus(), Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()), teacherInfoRequest.getPageDto(), new String[0]);
            if (orgTeacheres == null) {
                return GenericsUtils.emptyList();
            }
            return this.buildOrgTeacherInfo(teacherInfoRequest.getOrgId(), orgTeacheres);
        }
        if (GenericsUtils.isNullOrEmpty(orgTeachers)) {
            return GenericsUtils.emptyList();
        }
        return this.buildOrgTeacherInfoWithSolrDocs(teacherInfoRequest.getOrgId(), teacherInfoRequest.getCountType(), orgTeachers);
    }

    public List<OrgTeacherDocument> listDocs(TeacherInfoRequest teacherInfoRequest) {
        try {
            return this.queryOrgTeacherDocumentsFromEs(teacherInfoRequest);
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"error find data from mongoDB", (Object[])new Object[]{teacherInfoRequest});
            throw new MongoDbServerException();
        }
    }

    private List<OrgTeacherDocument> queryOrgTeacherDocumentsFromEs(TeacherInfoRequest teacherInfoRequest) {
        List listByQuery = this.orgTeacherDocumentQueryService.listByQuery(Integer.valueOf(teacherInfoRequest.getOrgId().intValue()), teacherInfoRequest.getUseStatus(), teacherInfoRequest.getCountType(), teacherInfoRequest.getOrderType(), teacherInfoRequest.getSearchKey(), teacherInfoRequest.getPageDto());
        List retDocuments = OrgTeacherDocument.buidOrgTeacherDocumentFromMap((List)listByQuery);
        return retDocuments;
    }

    private List<OrgTeacherInfoDto> buildOrgTeacherInfoWithSolrDocs(Long orgId, Integer countType, List<OrgTeacherDocument> list) {
        ArrayList result = Lists.newArrayList();
        Map orgTeacherMap = CollectorUtil.collectMap(list, (Function)new Function<OrgTeacherDocument, Long>(){

            public Long apply(OrgTeacherDocument teacher) {
                return teacher.getTeacherUserId();
            }
        });
        Map recommendMap = this.orgCourseGroupRelateDao.isRecommendTeacher(orgTeacherMap.keySet());
        List teacherLessoId = this.orgClassLessonDao.queryFinishedLessonCountByTeacherIds(orgId, orgTeacherMap.keySet(), DateUtil.getFirstDate((Date)new Date()), DateUtil.getDayDiff((int)0));
        Map classHourMap = CollectorUtil.collectMap((Collection)teacherLessoId, (Function)new Function<ClassHour, Long>(){

            public Long apply(ClassHour classHour) {
                return classHour.getTeacherId();
            }
        });
        Map userMap = this.userDao.getMapByIds(orgTeacherMap.keySet(), new String[0]);
        Map storageIds = CollectorUtil.collectMap(list, (Function)new Function<OrgTeacherDocument, Long>(){

            public Long apply(OrgTeacherDocument teacher) {
                return teacher.getAvatarStorageId();
            }
        });
        List storages = this.storageDao.getByIds(storageIds.keySet(), new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Long>(){

            public Long apply(Storage storage) {
                return storage.getId();
            }
        });
        for (OrgTeacherDocument orgTeacher : list) {
            Storage storage;
            log.info("orgTeacher is :{} ", (Object)orgTeacher);
            OrgTeacherInfoDto dto = new OrgTeacherInfoDto();
            dto.setId(orgTeacher.getOrgTeacherId());
            dto.setName(orgTeacher.getName());
            dto.setMobile(orgTeacher.getMobile());
            Long userId = orgTeacher.getTeacherUserId();
            dto.setClassNum(classHourMap.get(userId) == null ? 0 : ((ClassHour)classHourMap.get(userId)).getLessonCount());
            long commentScore = orgTeacher.getScoreNum();
            if (commentScore == 0L) {
                dto.setCommentNum(0.0);
            } else {
                dto.setCommentNum(ArithUtil.round((double)((double)commentScore / 100.0), (int)1));
            }
            Integer count = (Integer)recommendMap.get(orgTeacher.getTeacherUserId());
            if (count == null || count == 0) {
                dto.setRecommended(false);
            } else {
                dto.setRecommended(true);
            }
            dto.setCreateDate(orgTeacher.getCreateTime() == null ? new Date().getTime() : orgTeacher.getCreateTime().longValue());
            if (orgTeacher.getAvatarStorageId() != null && (storage = (Storage)storageMap.get(orgTeacher.getAvatarStorageId())) != null) {
                String avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
                dto.setAvatarUrl(avatarUrl);
            }
            dto.setUserId(orgTeacher.getTeacherUserId());
            User user = (User)userMap.get(orgTeacher.getTeacherUserId());
            dto.setNumber(user == null ? 0L : user.getNumber());
            dto.setCountType(countType);
            boolean hasClassRecord = orgTeacher.getFinishedClassTime() != null && orgTeacher.getFinishedClassTime() > 0;
            Integer markType = OrgTeacherMarkType.getMarkType((int)orgTeacher.getUseStatus(), (boolean)hasClassRecord);
            dto.setMarkType(markType);
            dto.setTotalClassTime(OrgTeacherServiceImpl.countTime(orgTeacher.getArrangeClassTime()));
            dto.setFinishClassTime(OrgTeacherServiceImpl.countTime(orgTeacher.getFinishedClassTime()));
            dto.setTotalStudentCount(String.valueOf(orgTeacher.getArrangeStudentCount()));
            dto.setFinishStudentCount(String.valueOf(orgTeacher.getHasSignupStudentCount()));
            dto.setScore(String.valueOf(commentScore == 0L ? 0.0 : ArithUtil.round((double)((double)commentScore / 100.0), (int)1)));
            dto.setStatus(orgTeacher.getUseStatus());
            result.add(dto);
        }
        return result;
    }

    public static String countTime(Integer time) {
        if (time == null) {
            return "0.0";
        }
        BigDecimal b1 = new BigDecimal(time);
        BigDecimal b2 = new BigDecimal(60);
        return b1.divide(b2, 1, 4).toPlainString();
    }

    @Override
    public List<OrgTeacherInfoDto> listPage(Long orgId, PageDto pageDto) {
        List orgTeachers = this.orgTeacherDao.getTeachersByOrgId(orgId, pageDto, new String[0]);
        if (orgTeachers == null) {
            return GenericsUtils.emptyList();
        }
        return this.buildOrgTeacherInfo(orgId, orgTeachers);
    }

    @Override
    public List<OrgTeachersDto> getAndUpdateOrgTeacherByOpenId(Long orgId, String weixinOpenId) {
        List teachers = this.orgTeacherDao.getTeacherByOpenIdAndOrgId(orgId, weixinOpenId, Integer.valueOf(1), new String[0]);
        ArrayList result = Lists.newArrayList();
        if (teachers != null && !teachers.isEmpty()) {
            OrgTeachersDto item = null;
            for (OrgTeacher teacher : teachers) {
                Teacher realTeacher = this.teacherDao.getByUserId(teacher.getUserId(), new String[0]);
                log.info("teacher is : {} and realTeacher is :{} ", (Object)teacher, (Object)realTeacher);
                item = new OrgTeachersDto();
                BeanUtils.copyProperties((Object)teacher, (Object)item);
                item.setTeacherId(teacher.getUserId());
                item.setClassName(this.getClassName(orgId, teacher.getUserId()));
                String nickName = realTeacher.getNickName();
                String realName = realTeacher.getRealName();
                item.setName(GenericsUtils.isNullOrEmpty((Object)nickName) ? realName : nickName);
                result.add(item);
                if (weixinOpenId.equals(teacher.getWeixin())) continue;
                teacher.setWeixin(weixinOpenId);
                teacher.setUpdateTime(new Date());
                this.orgTeacherDao.update((Object)teacher, new String[]{"weixin", "updateTime"});
            }
        }
        return result;
    }

    @Override
    public OrgTeachersDto getAndUpdateOrgStudentByMobile(Long orgId, String mobile, String name, String weinOpenId) throws BussinessException {
        OrgTeachersDto result = null;
        List teachers = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, mobile, Integer.valueOf(1), new String[0]);
        if (teachers != null && !teachers.isEmpty()) {
            result = new OrgTeachersDto();
            BeanUtils.copyProperties(teachers.get(0), (Object)result);
            result.setTeacherId(((OrgTeacher)teachers.get(0)).getId());
            for (OrgTeacher teacher : teachers) {
                String weixin = teacher.getWeixin();
                if (weinOpenId.equals(weixin)) continue;
                teacher.setWeixin(weinOpenId);
                teacher.setUpdateTime(new Date());
                this.orgTeacherDao.update((Object)teacher, new String[]{"weixin", "updateTime"});
            }
        } else {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "\u7ed1\u5b9a\u5931\u8d25\uff0c\u60a8\u6240\u586b\u5199\u7684\u624b\u673a\u53f7\u4e0d\u662f\u8001\u5e08\u624b\u673a\u53f7");
        }
        return result;
    }

    private String getClassName(Long orgId, Long teacherId) {
        OrgAccount orgAccount;
        List list;
        List courseIds = this.orgCourseTeacherDao.getOrgTeacherCourseIds(orgId, teacherId);
        String name = "";
        if (courseIds != null && !courseIds.isEmpty() && (list = this.orgCourseDao.getCourseList((Collection)courseIds, Long.valueOf(Long.parseLong((orgAccount = this.orgAccountDao.getAccountById(Integer.parseInt(orgId + ""), new String[0])).getNumber() + "")), CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null, null, new String[0])) != null && !list.isEmpty()) {
            name = ((OrgCourse)list.get(0)).getName();
        }
        return StringUtils.isNotBlank((CharSequence)name) ? name : "\u672a\u52a0\u73ed";
    }

    private void saveOrUpdateOrgTeacher(OrgTeacher teacher, TeacherInfoRequest request, Long orgId) {
        teacher.setMobile(request.getMobile());
        teacher.setOrgId(orgId);
        teacher.setId(request.getId());
        Date now = new Date();
        if (teacher.getId() == null) {
            teacher.setSignTime(now);
            teacher.setCreateTime(now);
            teacher.setInviteTime(now);
        }
        teacher.setUpdateTime(now);
        teacher.setStatus(Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        log.debug("save or update org teacher = {}", (Object)teacher);
        this.orgTeacherDao.saveOrUpdate((Object)teacher, new String[0]);
    }

    private void SaveOrUpdateCdbTeacher(Teacher teacher, TeacherInfoRequest request, Long orgId, OrgTeacher orgTeacher) {
        if (teacher == null) {
            teacher = new Teacher();
            teacher.setCreatedAt(new Date());
            teacher.setUserId(orgTeacher.getUserId());
        }
        teacher.setRealName(request.getName());
        teacher.setSex(request.getGender());
        teacher.setAvatar(request.getAvatar());
        if (StringUtils.isNotEmpty((CharSequence)request.getRemark())) {
            if (request.getRemark().length() > 20) {
                teacher.setShortIntroduce(request.getRemark().substring(0, 20) + "...");
            } else {
                teacher.setShortIntroduce(request.getRemark());
            }
            teacher.setOtherInfo(request.getRemark());
        }
        teacher.setOrgId(orgId);
        if (request.getBirthday() != null) {
            teacher.setBirthday(new Date(request.getBirthday()));
        }
        teacher.setUpdatedAt(new Date());
        log.debug("save or update cdb teacher = {}", (Object)teacher);
        this.teacherDao.saveOrUpdate((Object)teacher, new String[0]);
    }

    private void SaveOrUpdateCdbTeacherModify(TeacherModified teacherModified, TeacherInfoRequest request, Long orgId, OrgTeacher orgTeacher) {
        if (teacherModified == null) {
            teacherModified = new TeacherModified();
            teacherModified.setCreatedAt(new Date());
            teacherModified.setUserId(orgTeacher.getUserId());
        }
        teacherModified.setRealName(request.getName());
        teacherModified.setSex(request.getGender());
        teacherModified.setAvatar(request.getAvatar());
        if (StringUtils.isNotEmpty((CharSequence)request.getRemark())) {
            if (request.getRemark().length() > 20) {
                teacherModified.setShortIntroduce(request.getRemark().substring(0, 20) + "...");
            } else {
                teacherModified.setShortIntroduce(request.getRemark());
            }
            teacherModified.setOtherInfo(request.getRemark());
        }
        teacherModified.setOrgId(orgId);
        if (request.getBirthday() != null) {
            teacherModified.setBirthday(new Date(request.getBirthday()));
        }
        teacherModified.setUpdatedAt(new Date());
        log.debug("save or update cdb teacherModified = {}", (Object)teacherModified);
        this.teacherModifiedDao.saveOrUpdate((Object)teacherModified, new String[0]);
    }

    private List<OrgTeacherInfoDto> buildOrgTeacherInfo(Long orgId, List<OrgTeacher> list) {
        ArrayList result = Lists.newArrayList();
        Map orgTeacherMap = CollectorUtil.collectMap(list, (Function)new Function<OrgTeacher, Long>(){

            public Long apply(OrgTeacher teacher) {
                return teacher.getUserId();
            }
        });
        List teachers = this.teacherDao.getByUserIds(orgTeacherMap.keySet(), new String[0]);
        Map teacherMap = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher teacher) {
                return teacher.getUserId();
            }
        });
        Map userMap = this.userDao.getMapByIds(orgTeacherMap.keySet(), new String[0]);
        List teacherLessoId = this.orgClassLessonDao.queryFinishedLessonCountByTeacherIds(orgId, orgTeacherMap.keySet(), DateUtil.getFirstDate((Date)new Date()), DateUtil.getDayDiff((int)0));
        Map classHourMap = CollectorUtil.collectMap((Collection)teacherLessoId, (Function)new Function<ClassHour, Long>(){

            public Long apply(ClassHour classHour) {
                return classHour.getTeacherId();
            }
        });
        Map scoreMap = this.orgLessonCommentDao.getAveCommentByTeacherIds(orgTeacherMap.keySet(), new String[0]);
        Map recommendMap = this.orgCourseGroupRelateDao.isRecommendTeacher(orgTeacherMap.keySet());
        Map storageIds = CollectorUtil.collectMap((Collection)teachers, (Function)new Function<Teacher, Long>(){

            public Long apply(Teacher teacher) {
                return teacher.getAvatar();
            }
        });
        List storages = this.storageDao.getByIds(storageIds.keySet(), new String[0]);
        Map storageMap = CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Long>(){

            public Long apply(Storage storage) {
                return storage.getId();
            }
        });
        for (OrgTeacher orgTeacher : list) {
            Storage storage;
            OrgTeacherInfoDto dto = new OrgTeacherInfoDto();
            Teacher teacher = (Teacher)teacherMap.get(orgTeacher.getUserId());
            if (null == teacher) continue;
            dto.setId(orgTeacher.getId());
            dto.setMobile(orgTeacher.getMobile());
            if (teacher != null) {
                dto.setName(teacher.getRealName());
                if (teacher.getBirthday() != null) {
                    dto.setBirthday(teacher.getBirthday().getTime());
                }
            }
            dto.setClassNum(classHourMap.get(orgTeacher.getUserId()) == null ? 0 : ((ClassHour)classHourMap.get(orgTeacher.getUserId())).getLessonCount());
            Long commentScore = (Long)scoreMap.get(orgTeacher.getUserId());
            if (commentScore == null) {
                dto.setCommentNum(0.0);
            } else {
                dto.setCommentNum(ArithUtil.round((double)((double)commentScore.longValue() / 100.0), (int)1));
            }
            Integer count = (Integer)recommendMap.get(orgTeacher.getUserId());
            if (count == null || count == 0) {
                dto.setRecommended(false);
            } else {
                dto.setRecommended(true);
            }
            dto.setCreateDate(orgTeacher.getSignTime() == null ? new Date().getTime() : orgTeacher.getSignTime().getTime());
            if (teacher.getAvatar() != null && (storage = (Storage)storageMap.get(teacher.getAvatar())) != null) {
                String avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
                dto.setAvatarUrl(avatarUrl);
            }
            dto.setGender(teacher.getSex());
            dto.setUserId(teacher.getUserId());
            User user = (User)userMap.get(teacher.getUserId());
            dto.setNumber(user == null ? 0L : user.getNumber());
            dto.setRemark(teacher.getOtherInfo() == null || teacher.getOtherInfo().equals("\u65e0") ? "" : HtmlUtils.delHTMLTag((String)teacher.getOtherInfo()));
            dto.setDescr(teacher.getShortIntroduce() == null || teacher.getShortIntroduce().equals("\u65e0") ? "" : teacher.getShortIntroduce());
            dto.setOtherInfo(teacher.getOtherInfo() == null || teacher.getOtherInfo().equals("\u65e0") ? "" : HtmlUtils.delHTMLTag((String)teacher.getOtherInfo()));
            result.add(dto);
        }
        return result;
    }

    @Override
    public OrgTeacher getByUserId(long parseLong) {
        return this.orgTeacherDao.getTeachersByUserId(Long.valueOf(parseLong));
    }

    @Override
    public OrgTeacher getByUserIdIgnorUserStatus(long parseLong) {
        return this.orgTeacherDao.getTeachersByUserIdIgnorStatus(Long.valueOf(parseLong));
    }

    @Override
    public int getTeacherIds(long id) {
        List list = this.orgTeacherDao.getTeacherIds(Long.valueOf(id), Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        return list.size();
    }

    public static void saveOrEditTeacher(OrgTeacher teacher, TeacherInfoRequest request, Long orgId) {
        HashMap args = Maps.newHashMap();
        args.put("name", request.getName());
        args.put("org_id", orgId.toString());
        args.put("school_age", "0");
        args.put("intro", request.getRemark() == null || request.getRemark().equals("") ? "\u65e0" : request.getRemark());
        args.put("avatar_storage_id", request.getAvatar().toString());
        args.put("photo_storage_ids", PropertiesReader.getValue((String)"erp", (String)"teacher.male.photo.id"));
        if (request.getBirthday() != null) {
            args.put("birthday", DateUtil.getStrByDate((Date)new Date(request.getBirthday())));
        }
        args.put("gender", request.getGender().toString());
        args.put("app_id", Config.APP_ID);
        args.put("timestamp", String.valueOf(System.currentTimeMillis()));
        args.put("auth_token", OrgTeacherServiceImpl.getTokenFromCache());
        try {
            Integer userId;
            Map data;
            String controller = "org_teacher";
            String action = "create";
            if (request.getId() != null) {
                action = "update_profile";
                args.remove("mobile");
                args.put("user_id", teacher.getUserId() + "");
            }
            RestfulResult result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, controller, action, null, (Map)args, null);
            log.info("addOrEditBaseInfo.args:{}, ret:{}", (Object)args, (Object)result);
            if (result == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.IO_ERROR, "\u8c03\u7528\u4e3b\u7ad9\u63a5\u53e3\u6dfb\u52a0\u8001\u5e08\u662f\u5427");
            }
            if (result.getCode() == 1) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, result.getMsg());
            }
            if (request.getId() == null && (data = (Map)result.getData()) != null && (userId = (Integer)data.get("user_id")) != null) {
                teacher.setUserId(Long.valueOf(userId.longValue()));
            }
        }
        catch (Exception e) {
            log.warn("addBaseInfo failed, e:{}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.IO_ERROR, "\u8001\u5e08\u4fdd\u5b58\u5931\u8d25");
        }
    }

    public static String getTokenFromCache() {
        String token = null;
        try {
            token = RestUtil.getInstance().getAuthToken();
            log.info("Get token from cached,token=" + token);
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.TOKEN_ERROR, "\u83b7\u53d6\u7cfb\u7edfToken\u9519\u8bef");
        }
        return token;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTeacher(Integer orgId, Collection<Long> teacherIds) {
        List<Long> updateOrgCourseTeacherStatus = this.updateOrgCourseTeacherStatus(orgId, teacherIds, OrgCourseTeacher.softDelWithClassRecord);
        this.removeTeachers(orgId, teacherIds);
        this.saveOrUpdateOrgTeacher(orgId.longValue(), updateOrgCourseTeacherStatus);
        log.info("has removeTeachers:{} ", teacherIds);
    }

    private List<Long> updateOrgCourseTeacherStatus(Integer orgId, Collection<Long> teacherIds, Integer status) {
        if (GenericsUtils.isNullOrEmpty(teacherIds)) {
            return GenericsUtils.emptyList();
        }
        Map hasClassRecord = this.filterSoftDelTeacherService.hasClassRecord(orgId, teacherIds, new Boolean[0]);
        List byIds = this.orgTeacherDao.getByIds(teacherIds, new String[]{"id", "userId"});
        if (GenericsUtils.isNullOrEmpty((Object)byIds)) {
            return GenericsUtils.emptyList();
        }
        ArrayList teacherUserIds = Lists.newArrayList();
        HashSet needUpdateToCanSeeUserIds = Sets.newHashSet();
        for (OrgTeacher ot : byIds) {
            Long otId = ot.getId();
            Long userId = ot.getUserId();
            teacherUserIds.add(userId);
            boolean isHasClassRecord = hasClassRecord.get(otId) != null && (Boolean)hasClassRecord.get(otId) != false;
            if (isHasClassRecord) continue;
            needUpdateToCanSeeUserIds.add(userId);
        }
        this.orgCourseTeacherDao.updateStatusWithUserIds((Set)needUpdateToCanSeeUserIds, status.intValue());
        return teacherUserIds;
    }

    private void removeTeachers(Integer orgId, Collection<Long> teacherIds) {
        for (Long teacherId : teacherIds) {
            OrgTeacher obj = new OrgTeacher();
            obj.setUseStatus(Integer.valueOf(1));
            obj.setId(teacherId);
            obj.setUpdateTime(new Date());
            obj.setOrgId(Long.valueOf(orgId.longValue()));
            try {
                this.orgTeacherDao.update((Object)obj, Boolean.valueOf(false), new String[0]);
            }
            catch (Exception e) {
                log.error("can not find record with :orgID:{}  and teacherId:{} ", (Object)orgId, (Object)teacherId);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reUseTeacher(int orgId, List<Long> teacherIds) {
        for (Long teacherId : teacherIds) {
            OrgTeacher obj = new OrgTeacher();
            obj.setUseStatus(Integer.valueOf(0));
            obj.setId(teacherId);
            obj.setOrgId(Long.valueOf(orgId));
            try {
                this.orgTeacherDao.update((Object)obj, Boolean.valueOf(false), new String[0]);
            }
            catch (Exception e) {
                log.error("can not find record with :orgID:{}  and teacherId:{} so can not reUseTeacher it ", (Object)orgId, (Object)teacherId);
            }
        }
        List<Long> updateOrgCourseTeacherStatus = this.updateOrgCourseTeacherStatus(orgId, teacherIds, OrgCourseTeacher.normal);
        this.saveOrUpdateOrgTeacher(Long.valueOf(orgId), updateOrgCourseTeacherStatus);
        log.info("has removeTeachers:{} ", teacherIds);
    }

    @Override
    public TwoTuple<Integer, List<Long>> removeAllTeachers(int orgId, int confirm) {
        List orgTeacherListByOrgIds = this.orgTeacherDao.getPausedOrgTeacherListByOrgIds(Arrays.asList(orgId));
        log.info("find all orgTeacherListByOrgIds are:{} ", (Object)orgTeacherListByOrgIds);
        HashSet teacherIds = Sets.newHashSet();
        for (OrgTeacher ot : orgTeacherListByOrgIds) {
            teacherIds.add(ot.getId());
        }
        Map hasClassRecord = this.filterSoftDelTeacherService.hasClassRecord(Integer.valueOf(orgId), (Collection)teacherIds, new Boolean[0]);
        int count = this.checkoutHasClassRecord(hasClassRecord);
        ArrayList hardDelTeacherIds = Lists.newArrayList();
        if (count == 0 || count != 0 && confirm == 1) {
            ArrayList hardDelTeachers = Lists.newArrayList();
            for (OrgTeacher ot : orgTeacherListByOrgIds) {
                Long id = ot.getId();
                Boolean containsKey = (Boolean)hasClassRecord.get(id);
                if (containsKey != null && !containsKey.booleanValue()) {
                    hardDelTeachers.add(ot.getUserId());
                    hardDelTeacherIds.add(ot.getId());
                    this.hardDelOrgTeacher(ot);
                    log.info("delete orgTeacher:{} ", (Object)ot);
                    continue;
                }
                log.info("ot {} has class record , so will not delete it ", (Object)ot);
            }
            this.saveOrUpdateOrgTeacher(Long.valueOf(orgId), hardDelTeachers);
        } else if (count == teacherIds.size()) {
            log.info("current operator can not be do cause by all teachers has clas record whit orgId:{} and confirm:{} ", (Object)orgId, (Object)confirm);
            throw new BussinessException((UniverseErrorCode)ErpErrorCode.ALL_TEACHER_HAS_CLASS_RECORD);
        }
        log.info("[OrgTeacherServiceImpl] remove teacherIds :{} ", (Object)teacherIds);
        return new TwoTuple((Object)count, (Object)hardDelTeacherIds);
    }

    private int checkoutHasClassRecord(int orgId, Set<Long> teacherIds) {
        Map hasClassRecord = this.filterSoftDelTeacherService.hasClassRecord(Integer.valueOf(orgId), teacherIds, new Boolean[0]);
        log.info("hasClassRecord are :{} ", (Object)hasClassRecord);
        int count = this.countHasRecords(hasClassRecord);
        return count;
    }

    private int checkoutHasClassRecord(Map<Long, Boolean> hasClassRecord) {
        int count = 0;
        log.info("hasClassRecord are :{} ", hasClassRecord);
        count = this.countHasRecords(hasClassRecord);
        return count;
    }

    private int countHasRecords(Map<Long, Boolean> hasClassRecord) {
        int count = 0;
        if (GenericsUtils.notNullAndEmpty(hasClassRecord)) {
            for (Map.Entry<Long, Boolean> entry : hasClassRecord.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public Long getUserIdByCascadeId(Long orgId, Integer cascadeId) {
        String mobile = "";
        if (cascadeId != null && cascadeId != 0) {
            TXCascadeAccount account = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (account == null) {
                throw new ParameterException("\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728,cascadeId=" + cascadeId);
            }
            TXCascadeCredential txCascadeCredential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)account.getCredentialId(), new String[]{"mobile"});
            if (txCascadeCredential != null) {
                mobile = txCascadeCredential.getMobile();
            }
        } else {
            OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"mobile"});
            if (accountById != null && accountById.getIsDel().intValue() == DeleteStatus.NORMAL.getValue()) {
                mobile = accountById.getMobile();
            }
        }
        if (GenericsUtils.notNullAndEmpty((Object)mobile)) {
            List teacherByMobileAndOrgId = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, mobile, null, new String[0]);
            log.info("find all orgTeachers are:{} ", (Object)teacherByMobileAndOrgId);
            if (GenericsUtils.notNullAndEmpty((Object)teacherByMobileAndOrgId)) {
                OrgTeacher orgTeacher = (OrgTeacher)teacherByMobileAndOrgId.get(0);
                log.info("find all orgTeacher is:{} ", (Object)orgTeacher);
                return orgTeacher.getUserId();
            }
        }
        log.info("Cannot find orgTeacherId:orgId={},cascadeId={} ", (Object)orgId, (Object)cascadeId);
        return null;
    }
}

