package com.baijia.tianxiao.sal.teacher.util;

import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.http.RestUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/5/18
 * Time: 上午11:12
 * To change this template use File | Settings | File Templates.
 */
@Slf4j
public class OrgTeacherUtil {


    /**
     * 通过浅注册获取userId
     *
     * @param
     * @return <"id",..>,<"number",..>
     * @throws Exception
     */
    public static Map<String, Long> getUserIdAndNumber(Long orgId, String mobile, String name) {
        try {
            Map<String, Long> userInfoMap = new HashMap<String, Long>();
            RestfulResult<Map<String, Object>> createResult = RestUtils.createTeacherNoMobile(null, orgId, "tianxiao100", null, name, null);

            log.debug("getUserId and Number = {}", createResult);
            String id = null;
            String number = null;
            if (0 == createResult.getCode()) {
                if (null != createResult.getData()) {
                    id = createResult.getData().get("user_id").toString();
                    number = createResult.getData().get("number").toString();
                    if (StringUtils.isNotBlank(id) && StringUtils.isNotBlank(number)) {
                        userInfoMap.put("id", Long.valueOf(id));
                        userInfoMap.put("number", Long.valueOf(number));
                        return userInfoMap;
                    } else {
                        log.warn("create teacher failed-----userId = {},number = {}", id, number);
                        throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                    }
                } else {
                    log.warn("create teacher failed-----createResult.getData = {}", createResult.getData());
                    throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                }
            } else {
                log.warn("create  teacher-----createResult.getCode() = {}", createResult.getCode());
                throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
            }
        } catch (Exception e) {
            log.warn("create teacher get error:{}", e);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
        }
    }

}
