
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.teacher.impl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.activity.dao.article.OrgTeacherDocumentMongoDbDao;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupRelateDao;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.ClassHour;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.solr.dto.OrgTeacherDocument;
import com.baijia.tianxiao.dal.solr.enums.OrgTeacherMarkType;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.TeacherModifiedDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.TeacherModified;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ErpErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.FilterSoftDelTeacherService;
import com.baijia.tianxiao.sal.common.api.OrgTeacherForSolrService;
import com.baijia.tianxiao.sal.push.constant.Config;
import com.baijia.tianxiao.sal.push.utils.RestUtil;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeacherInfoDto;
import com.baijia.tianxiao.sal.teacher.dto.OrgTeachersDto;
import com.baijia.tianxiao.sal.teacher.dto.request.TeacherInfoRequest;
import com.baijia.tianxiao.sal.teacher.enums.OrgTeacherSource;
import com.baijia.tianxiao.sal.teacher.exception.MongoDbServerException;
import com.baijia.tianxiao.sal.teacher.util.OrgTeacherUtil;
import com.baijia.tianxiao.sal.teacher.util.TeacherErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HtmlUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class OrgTeacherServiceImpl implements OrgTeacherService {

    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgCourseGroupRelateDao orgCourseGroupRelateDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private TeacherModifiedDao teacherModifiedDao;
    @Autowired(required = false)
    private OrgTeacherDocumentMongoDbDao orgTeacherDocumentMongoDbDao;
    @Autowired
    private FilterSoftDelTeacherService filterSoftDelTeacherService;
    @Autowired
    private OrgTeacherForSolrService orgTeacherForSolrService;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;

    @Override
    public OrgTeacherInfoDto saveTeacher(Long orgId, TeacherInfoRequest request, Long szManagerId) {
        Preconditions.checkArgument(request.getName() != null && request.getName().length() <= 15, "姓名必填,而且不能大于15个字");

        OrgTeacher orgTeacher = null;
        if (request.getId() == null) {
            List<OrgTeacher> temp = orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), 1);
            log.info("find all temp orgTeacher is :{} ", temp);
            if (temp != null && temp.size() > 0) {
                throw new BussinessException(TeacherErrorCode.MOBILE_DOUBLE);
            }
        } else {
            orgTeacher = orgTeacherDao.getById(request.getId());
            if (!request.getMobile().equals(orgTeacher.getMobile())) {
                List<OrgTeacher> temp = orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), 1);
                if (temp != null && temp.size() > 0) {
                    throw new BussinessException(TeacherErrorCode.MOBILE_DOUBLE);
                }
            }
        }

        if (request.getId() == null) {
            orgTeacher = new OrgTeacher();
            orgTeacher.setType(OrgTeacherSource.TIANXIAO.getStatus());// 天校app添加来源
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue());
            if (orgAccount != null) {
                orgTeacher.setOrgNumber(orgAccount.getNumber());
            }

            orgTeacher.setOrgManagerId(szManagerId);
        }

        // 调用主站接口保存
        saveOrEditTeacher(orgTeacher, request, orgId);

        // 保存orgTeacher
        saveOrUpdateOrgTeacher(orgTeacher, request, orgId);

        saveOrUpdateOrgTeacher(orgId, Arrays.asList(orgTeacher.getUserId()));

        return detail(orgTeacher.getId());
    }

    /**
     * @param orgId
     * @param orgTeacher
     */

    private void saveOrUpdateOrgTeacher(Long orgId, List<Long> teacherUserIds) {
        Date beginDate = null;
        Date endDate = null;
        Date timestamp = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(timestamp);
        c.add(Calendar.MONTH, 1);
        Date time2 = c.getTime();
        Date time1 = timestamp;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-01 00:00:00");
        try {
            beginDate = format.parse(format.format(time1));
            endDate = format.parse(format.format(time2));
        } catch (ParseException e) {
        }

        Map<Long, OrgTeacherDocument> createOrgTeacherDocuments = null;
        if (GenericsUtils.notNullAndEmpty(teacherUserIds)) {
            createOrgTeacherDocuments = this.orgTeacherForSolrService.createOrgTeacherDocuments(orgId, teacherUserIds,
                beginDate, endDate, true);
        }
        log.info("createOrgTeacherDocuments are :{} ", createOrgTeacherDocuments);
    }

    @Override
    public OrgTeacherInfoDto saveTeacherOld(Long orgId, TeacherInfoRequest request, Long szManagerId) {
        Preconditions.checkArgument(request.getName() != null && request.getName().length() <= 15, "姓名必填,而且不能大于15个字");

        OrgTeacher orgTeacher = null;
        if (request.getId() == null) {
            List<OrgTeacher> temp = orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), 1);
            if (temp != null && temp.size() > 0) {
                throw new BussinessException(TeacherErrorCode.MOBILE_DOUBLE);
            }
        } else {
            orgTeacher = orgTeacherDao.getById(request.getId());
            if (!request.getMobile().equals(orgTeacher.getMobile())) {
                List<OrgTeacher> temp = orgTeacherDao.getTeacherByMobileAndOrgId(orgId, request.getMobile(), 1);
                if (temp != null && temp.size() > 0) {
                    throw new BussinessException(TeacherErrorCode.MOBILE_DOUBLE);
                }
            }
        }

        if (request.getId() == null) {
            orgTeacher = new OrgTeacher();
            orgTeacher.setType(OrgTeacherSource.TIANXIAO.getStatus());// 天校app添加来源
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue());
            if (orgAccount != null) {
                orgTeacher.setOrgNumber(orgAccount.getNumber());
            }

            orgTeacher.setOrgManagerId(szManagerId);
        }

        if (orgTeacher.getUserId() == null) {
            Map<String, Long> userInfoMap =
                OrgTeacherUtil.getUserIdAndNumber(orgId, request.getMobile(), request.getName());
            orgTeacher.setUserId(userInfoMap.get("id"));
        }

        Teacher teacher = teacherDao.getByUserId(orgTeacher.getUserId());
        TeacherModified teacherModified = teacherModifiedDao.getByUserId(orgTeacher.getUserId());

        // 保存orgTeacher
        saveOrUpdateOrgTeacher(orgTeacher, request, orgId);
        // 更新cdbTeacher
        // teacher.setUserId(orgTeacher.getUserId());
        SaveOrUpdateCdbTeacher(teacher, request, orgId, orgTeacher);
        // 更新cdbTeacherModify
        // teacherModified.setUserId(orgTeacher.getUserId());
        SaveOrUpdateCdbTeacherModify(teacherModified, request, orgId, orgTeacher);

        // 添加cdb.org_teacher 免审核
        if (request.getId() == null) {
            User user = userDao.getById(orgTeacher.getUserId());
            if (user != null) {
                orgTeacherDao.saveCdbOrgTeacher(orgTeacher.getUserId(), user.getNumber(), orgId);
            }
        }

        return detail(orgTeacher.getId());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void del(Long teacherId) {
        OrgTeacher orgTeacher = orgTeacherDao.getById(teacherId);

        if (orgTeacher != null) {
            Set<Long> teacherIds = Sets.newHashSet();
            teacherIds.add(orgTeacher.getId());
            int count = checkoutHasClassRecord(orgTeacher.getOrgId().intValue(), teacherIds);
            if (count != 0) {
                throw new BussinessException(ErpErrorCode.TEACHER_HAS_CLASS_RECORD);
            }
            hardDelOrgTeacher(orgTeacher);
            this.saveOrUpdateOrgTeacher(orgTeacher.getOrgId(), Arrays.asList(orgTeacher.getUserId()));
        } else {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

    }

    /**
     * @param orgTeacher
     */
    private void hardDelOrgTeacher(OrgTeacher orgTeacher) {
        orgTeacher.setStatus(OrgTeacherStatus.TERMINATED.getCode());
        orgTeacher.setFireTime(new Date());
        log.info("del teacher == {}", orgTeacher);
        orgTeacherDao.update(orgTeacher);
        Teacher teacher = teacherDao.getByUserId(orgTeacher.getUserId());
        if (teacher != null) {
            teacher.setOrgId(null);
            teacher.setUpdatedAt(new Date());
            teacherDao.update(teacher, true, "orgId");
        }

        TeacherModified teacherModified = teacherModifiedDao.getByUserId(orgTeacher.getUserId());
        if (teacherModified != null) {
            teacherModified.setOrgId(null);
            teacherModified.setUpdatedAt(new Date());
            teacherModifiedDao.update(teacherModified, true, "orgId");
        }

    }

    @Override
    public OrgTeacherInfoDto detail(Long teacherId) {
        OrgTeacher orgTeacher = orgTeacherDao.getById(teacherId);
        log.info("orgTeacher is :{} ", orgTeacher);
        OrgTeacherInfoDto orgTeacherInfoDto = new OrgTeacherInfoDto();
        if (orgTeacher != null) {
            Teacher teacher = teacherDao.getByUserId(orgTeacher.getUserId());
            if (teacher != null) {
                orgTeacherInfoDto.setUserId(teacher.getUserId());
                orgTeacherInfoDto.setId(orgTeacher.getId());
                orgTeacherInfoDto.setName(teacher.getRealName());
                orgTeacherInfoDto.setAvatar(teacher.getAvatar());
                if (teacher.getAvatar() != null) {
                    Storage storage = storageDao.getById(teacher.getAvatar());
                    if (storage != null) {
                        String avatarUrl =
                            StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
                        orgTeacherInfoDto.setAvatarUrl(avatarUrl);
                    }
                }
                if (teacher.getBirthday() != null) {
                    orgTeacherInfoDto.setBirthday(teacher.getBirthday().getTime());
                }
                User user = userDao.getById(teacher.getUserId());
                if (user != null) {
                    orgTeacherInfoDto.setNumber(user.getNumber());
                }

                orgTeacherInfoDto.setDescr(teacher.getIntroduce() != null && !teacher.getIntroduce().equals("无")
                    ? teacher.getIntroduce() : "");
                orgTeacherInfoDto.setStatus(orgTeacher.getUseStatus());
                Map<Long, Boolean> hasClassRecords = filterSoftDelTeacherService
                    .hasClassRecord(orgTeacher.getOrgId().intValue(), Arrays.asList(teacherId));
                boolean hasClassRecord =
                    (hasClassRecords.get(orgTeacher.getId()) != null && hasClassRecords.get(orgTeacher.getId()));
                log.info("useStatus :{} and hasClassRecord:{} ", orgTeacher.getUseStatus(), hasClassRecord);
                orgTeacherInfoDto
                    .setMarkType(OrgTeacherMarkType.getMarkType(orgTeacher.getUseStatus(), hasClassRecord));
                orgTeacherInfoDto.setMobile(orgTeacher.getMobile());
                orgTeacherInfoDto.setGender(teacher.getSex());
                orgTeacherInfoDto.setRemark(teacher.getOtherInfo() == null || teacher.getOtherInfo().equals("无") ? ""
                    : HtmlUtils.delHTMLTag(teacher.getOtherInfo()));
                // orgTeacherInfoDto.setBackPictrueUrl(backPictrueUrl);
            }
        }
        return orgTeacherInfoDto;
    }

    @Override
    public List<OrgTeacherInfoDto> list(Long orgId, Long lastId, Integer pageSize) {
        List<OrgTeacher> orgTeachers =
            orgTeacherDao.listByLastId(orgId, lastId, pageSize, true, OrgTeacherStatus.SIGNED.getCode());
        if (orgTeachers == null) {
            return GenericsUtils.emptyList();
        }
        return buildOrgTeacherInfo(orgId, orgTeachers);
    }

    @Override
    public List<OrgTeacherInfoDto> listByOrgTeacherIds(Long orgId, List<Long> teacherIds) {
        Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("id", teacherIds);
        condition.put("status", OrgTeacherStatus.SIGNED.getCode());
        List<OrgTeacher> orgTeachers = orgTeacherDao.queryByCondition(condition, null);

        return buildOrgTeacherInfo(orgId, orgTeachers);
    }

    @Override
    public Map<Long, OrgTeacherInfoDto> queryMapByOrgTeacherIds(Long orgId, List<Long> teacherIds) {
        List<OrgTeacherInfoDto> list = listByOrgTeacherIds(orgId, teacherIds);
        Map<Long, OrgTeacherInfoDto> map = Maps.newHashMap();
        for (OrgTeacherInfoDto dto : list) {
            map.put(dto.getId(), dto);
        }
        return map;
    }

    @Override
    public List<OrgTeacherInfoDto> list(TeacherInfoRequest teacherInfoRequest) {
        log.info("teacherInfoRequest is :{} ", teacherInfoRequest);
        List<OrgTeacherDocument> orgTeachers = null;
        try {
            orgTeachers = this.listDocs(teacherInfoRequest);
        } catch (Exception e) {
            log.warn(
                "can not find OrgTeacherInfoDto cause by mongoDBServerExcepiton:{} ,so will return default value with request:{} ",
                e, teacherInfoRequest);
            List<OrgTeacher> orgTeacheres = orgTeacherDao.listByPageDto(teacherInfoRequest.getOrgId(),
                teacherInfoRequest.getUseStatus(), OrgTeacherStatus.SIGNED.getCode(), teacherInfoRequest.getPageDto());
            if (orgTeacheres == null) {
                return GenericsUtils.emptyList();
            }
            return buildOrgTeacherInfo(teacherInfoRequest.getOrgId(), orgTeacheres);
        }
        if (GenericsUtils.isNullOrEmpty(orgTeachers)) {
            return GenericsUtils.emptyList();
        }
        return buildOrgTeacherInfoWithSolrDocs(teacherInfoRequest.getOrgId(), teacherInfoRequest.getCountType(),
            orgTeachers);
    }

    public List<OrgTeacherDocument> listDocs(TeacherInfoRequest teacherInfoRequest) {
        try {
            return queryOrgTeacherDocumentsFromMongoDB(teacherInfoRequest);
        } catch (Exception e) {
            GenericsUtils.logErrorAndInfo(log, e, "error find data from mongoDB", teacherInfoRequest);
            throw new MongoDbServerException();
        }
        // return this.orgTeacherQuery.queryOrgTeachers(null, teacherInfoRequest.getOrgId().intValue(),
        // teacherInfoRequest.getUseStatus(), teacherInfoRequest.getCountType(), teacherInfoRequest.getOrderType(),
        // teacherInfoRequest.getSearchKey(), teacherInfoRequest.getPageDto());
    }

    /**
     * @param teacherInfoRequest
     * @return
     */
    private List<OrgTeacherDocument> queryOrgTeacherDocumentsFromMongoDB(TeacherInfoRequest teacherInfoRequest) {
        List<Map<String, Object>> listByQuery =
            this.orgTeacherDocumentMongoDbDao.listByQuery(teacherInfoRequest.getOrgId().intValue(),
                teacherInfoRequest.getUseStatus(), teacherInfoRequest.getCountType(), teacherInfoRequest.getOrderType(),
                teacherInfoRequest.getSearchKey(), teacherInfoRequest.getPageDto());
        List<OrgTeacherDocument> retDocuments = OrgTeacherDocument.buidOrgTeacherDocumentFromMap(listByQuery);
        return retDocuments;
    }

    private List<OrgTeacherInfoDto> buildOrgTeacherInfoWithSolrDocs(Long orgId, Integer countType,
        List<OrgTeacherDocument> list) {
        List<OrgTeacherInfoDto> result = Lists.newArrayList();
        Map<Long, OrgTeacherDocument> orgTeacherMap =
            CollectorUtil.collectMap(list, new Function<OrgTeacherDocument, Long>() {
                @Override
                public Long apply(OrgTeacherDocument teacher) {
                    return teacher.getTeacherUserId();
                }
            });

        Map<Long, Integer> recommendMap = orgCourseGroupRelateDao.isRecommendTeacher(orgTeacherMap.keySet());

        List<ClassHour> teacherLessoId = orgClassLessonDao.queryFinishedLessonCountByTeacherIds(orgId,
            orgTeacherMap.keySet(), DateUtil.getFirstDate(new Date()), DateUtil.getDayDiff(0));
        Map<Long, ClassHour> classHourMap = CollectorUtil.collectMap(teacherLessoId, new Function<ClassHour, Long>() {
            @Override
            public Long apply(ClassHour classHour) {
                return classHour.getTeacherId();
            }
        });

        Map<Long, User> userMap = userDao.getMapByIds(orgTeacherMap.keySet());
        Map<Long, OrgTeacherDocument> storageIds =
            CollectorUtil.collectMap(list, new Function<OrgTeacherDocument, Long>() {
                @Override
                public Long apply(OrgTeacherDocument teacher) {
                    return teacher.getAvatarStorageId();
                }
            });

        List<Storage> storages = storageDao.getByIds(storageIds.keySet());
        Map<Long, Storage> storageMap = CollectorUtil.collectMap(storages, new Function<Storage, Long>() {
            @Override
            public Long apply(Storage storage) {
                return storage.getId();
            }
        });

        for (OrgTeacherDocument orgTeacher : list) {
            log.info("orgTeacher is :{} ", orgTeacher);
            OrgTeacherInfoDto dto = new OrgTeacherInfoDto();
            dto.setId(orgTeacher.getOrgTeacherId());
            dto.setName(orgTeacher.getName());
            Long userId = orgTeacher.getTeacherUserId();
            dto.setClassNum(classHourMap.get(userId) == null ? 0 : classHourMap.get(userId).getLessonCount());
            long commentScore = orgTeacher.getScoreNum();
            if (commentScore == 0) {
                dto.setCommentNum(0.0d);
            } else {
                dto.setCommentNum(ArithUtil.round(((double) (commentScore)) / 100, 1));
            }
            Integer count = recommendMap.get(orgTeacher.getTeacherUserId());
            if (count == null || count == 0) {
                dto.setRecommended(false);
            } else {
                dto.setRecommended(true);
            }
            dto.setCreateDate(orgTeacher.getCreateTime() == null ? new Date().getTime() : orgTeacher.getCreateTime());

            if (orgTeacher.getAvatarStorageId() != null) {
                Storage storage = storageMap.get(orgTeacher.getAvatarStorageId());
                if (storage != null) {
                    String avatarUrl =
                        StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
                    dto.setAvatarUrl(avatarUrl);
                }
            }
            dto.setUserId(orgTeacher.getTeacherUserId());
            User user = userMap.get(orgTeacher.getTeacherUserId());
            dto.setNumber(user == null ? 0 : user.getNumber());

            dto.setCountType(countType);
            boolean hasClassRecord =
                (orgTeacher.getFinishedClassTime() != null && orgTeacher.getFinishedClassTime().intValue() > 0);
            Integer markType = OrgTeacherMarkType.getMarkType(orgTeacher.getUseStatus(), hasClassRecord);
            dto.setMarkType(markType);
            dto.setTotalClassTime(countTime(orgTeacher.getArrangeClassTime()));
            dto.setFinishClassTime(countTime(orgTeacher.getFinishedClassTime()));
            dto.setTotalStudentCount(String.valueOf(orgTeacher.getArrangeStudentCount()));
            dto.setFinishStudentCount(String.valueOf(orgTeacher.getHasSignupStudentCount()));
            dto.setScore(String.valueOf(commentScore == 0 ? 0 : ArithUtil.round(((double) (commentScore)) / 100, 1)));
            dto.setStatus(orgTeacher.getUseStatus());

            result.add(dto);
        }
        return result;
    }

    public static String countTime(Integer time) {
        if (time == null) {
            return "0.0";
        }
        BigDecimal b1 = new BigDecimal(time);
        BigDecimal b2 = new BigDecimal(60);
        return b1.divide(b2, 1, BigDecimal.ROUND_HALF_UP).toPlainString();
    }

    @Override
    public List<OrgTeacherInfoDto> listPage(Long orgId, PageDto pageDto) {
        List<OrgTeacher> orgTeachers = orgTeacherDao.getTeachersByOrgId(orgId, pageDto);
        if (orgTeachers == null) {
            return GenericsUtils.emptyList();
        }
        return buildOrgTeacherInfo(orgId, orgTeachers);
    }

    @Override
    public List<OrgTeachersDto> getAndUpdateOrgTeacherByOpenId(Long orgId, String weixinOpenId) {
        // List<OrgTeacher> teachers = this.orgTeacherDao.getTeacherByOpenIdAndOrgId(orgId, weixinOpenId, 1);
        // 1是啥？？
        List<OrgTeacher> teachers = this.orgTeacherDao.getTeacherByOpenIdAndOrgId(orgId, weixinOpenId, 1);

        List<OrgTeachersDto> result = Lists.newArrayList();
        if (teachers != null && !teachers.isEmpty()) {
            OrgTeachersDto item = null;
            for (OrgTeacher teacher : teachers) {
                Teacher realTeacher = teacherDao.getByUserId(teacher.getUserId());
                log.info("teacher is : {} and realTeacher is :{} ", teacher, realTeacher);
                item = new OrgTeachersDto();
                org.springframework.beans.BeanUtils.copyProperties(teacher, item);
                item.setTeacherId(teacher.getUserId());
                item.setClassName(this.getClassName(orgId, teacher.getUserId()));
                String nickName = realTeacher.getNickName();
                String realName = realTeacher.getRealName();
                item.setName(GenericsUtils.isNullOrEmpty(nickName) ? realName : nickName);

                result.add(item);
                // 将openId与student绑定
                if (!weixinOpenId.equals(teacher.getWeixin())) {
                    teacher.setWeixin(weixinOpenId);
                    teacher.setUpdateTime(new Date());
                    orgTeacherDao.update(teacher, "weixin", "updateTime");
                }
            }

        }
        return result;
    }

    @Override
    public OrgTeachersDto getAndUpdateOrgStudentByMobile(Long orgId, String mobile, String name, String weinOpenId)
        throws BussinessException {
        OrgTeachersDto result = null;

        List<OrgTeacher> teachers = this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, mobile, 1);

        if (teachers != null && !teachers.isEmpty()) {
            result = new OrgTeachersDto();
            org.springframework.beans.BeanUtils.copyProperties(teachers.get(0), result);
            result.setTeacherId(teachers.get(0).getId());

            for (OrgTeacher teacher : teachers) {
                String weixin = teacher.getWeixin();
                if (!weinOpenId.equals(weixin)) {
                    // teacher.setTeacherName(name);
                    teacher.setWeixin(weinOpenId);
                    teacher.setUpdateTime(new Date());

                    // this.orgTeacherDao.update(teacher, "name", "weixin", "updateTime");
                    this.orgTeacherDao.update(teacher, "weixin", "updateTime");
                }
            }
        } else {
            throw new BussinessException(CommonErrorCode.NOT_FOUND, "绑定失败，您所填写的手机号不是老师手机号");
        }
        return result;
    }

    private String getClassName(Long orgId, Long teacherId) {
        List<Long> courseIds = orgCourseTeacherDao.getOrgTeacherCourseIds(orgId, teacherId);
        String name = "";
        if (courseIds != null && !courseIds.isEmpty()) {
            OrgAccount orgAccount = orgAccountDao.getAccountById(Integer.parseInt(orgId + ""));
            List<OrgCourse> list = this.orgCourseDao.getCourseList(courseIds,
                Long.parseLong(orgAccount.getNumber() + ""), CourseTypeEnum.IS_COURSE_TRUE.getCode(), null, null, null);
            if (list != null && !list.isEmpty()) {
                name = list.get(0).getName();
            }
        }
        return StringUtils.isNotBlank(name) ? name : "未加班";
    }

    private void saveOrUpdateOrgTeacher(OrgTeacher teacher, TeacherInfoRequest request, Long orgId) {

        teacher.setMobile(request.getMobile());
        teacher.setOrgId(orgId);
        teacher.setId(request.getId());
        Date now = new Date();
        if (teacher.getId() == null) {
            teacher.setSignTime(now);
            teacher.setCreateTime(now);
            teacher.setInviteTime(now);
        }
        teacher.setUpdateTime(now);
        teacher.setStatus(OrgTeacherStatus.SIGNED.getCode());

        log.debug("save or update org teacher = {}", teacher);
        orgTeacherDao.saveOrUpdate(teacher);
    }

    private void SaveOrUpdateCdbTeacher(Teacher teacher, TeacherInfoRequest request, Long orgId,
        OrgTeacher orgTeacher) {
        if (teacher == null) {
            teacher = new Teacher();
            teacher.setCreatedAt(new Date());
            teacher.setUserId(orgTeacher.getUserId());
        }
        teacher.setRealName(request.getName());
        teacher.setSex(request.getGender());
        teacher.setAvatar(request.getAvatar());
        if (StringUtils.isNotEmpty(request.getRemark())) {
            if (request.getRemark().length() > 20) {
                teacher.setShortIntroduce(request.getRemark().substring(0, 20) + "...");
            } else {
                teacher.setShortIntroduce(request.getRemark());
            }
            teacher.setOtherInfo(request.getRemark());
        }
        teacher.setOrgId(orgId);
        if (request.getBirthday() != null) {
            teacher.setBirthday(new Date(request.getBirthday()));
        }
        teacher.setUpdatedAt(new Date());
        log.debug("save or update cdb teacher = {}", teacher);
        teacherDao.saveOrUpdate(teacher);
    }

    private void SaveOrUpdateCdbTeacherModify(TeacherModified teacherModified, TeacherInfoRequest request, Long orgId,
        OrgTeacher orgTeacher) {
        if (teacherModified == null) {
            teacherModified = new TeacherModified();
            teacherModified.setCreatedAt(new Date());
            teacherModified.setUserId(orgTeacher.getUserId());
        }
        teacherModified.setRealName(request.getName());
        teacherModified.setSex(request.getGender());
        teacherModified.setAvatar(request.getAvatar());
        if (StringUtils.isNotEmpty(request.getRemark())) {
            if (request.getRemark().length() > 20) {
                teacherModified.setShortIntroduce(request.getRemark().substring(0, 20) + "...");
            } else {
                teacherModified.setShortIntroduce(request.getRemark());
            }
            teacherModified.setOtherInfo(request.getRemark());
        }
        teacherModified.setOrgId(orgId);
        if (request.getBirthday() != null) {
            teacherModified.setBirthday(new Date(request.getBirthday()));
        }
        teacherModified.setUpdatedAt(new Date());
        log.debug("save or update cdb teacherModified = {}", teacherModified);
        teacherModifiedDao.saveOrUpdate(teacherModified);
    }

    private List<OrgTeacherInfoDto> buildOrgTeacherInfo(Long orgId, List<OrgTeacher> list) {
        List<OrgTeacherInfoDto> result = Lists.newArrayList();
        Map<Long, OrgTeacher> orgTeacherMap = CollectorUtil.collectMap(list, new Function<OrgTeacher, Long>() {
            @Override
            public Long apply(OrgTeacher teacher) {
                return teacher.getUserId();
            }
        });
        List<Teacher> teachers = teacherDao.getByUserIds(orgTeacherMap.keySet());
        Map<Long, Teacher> teacherMap = CollectorUtil.collectMap(teachers, new Function<Teacher, Long>() {
            @Override
            public Long apply(Teacher teacher) {
                return teacher.getUserId();
            }
        });

        Map<Long, User> userMap = userDao.getMapByIds(orgTeacherMap.keySet());

        List<ClassHour> teacherLessoId = orgClassLessonDao.queryFinishedLessonCountByTeacherIds(orgId,
            orgTeacherMap.keySet(), DateUtil.getFirstDate(new Date()), DateUtil.getDayDiff(0));
        Map<Long, ClassHour> classHourMap = CollectorUtil.collectMap(teacherLessoId, new Function<ClassHour, Long>() {
            @Override
            public Long apply(ClassHour classHour) {
                return classHour.getTeacherId();
            }
        });

        Map<Long, Long> scoreMap = orgLessonCommentDao.getAveCommentByTeacherIds(orgTeacherMap.keySet());

        Map<Long, Integer> recommendMap = orgCourseGroupRelateDao.isRecommendTeacher(orgTeacherMap.keySet());

        Map<Long, Teacher> storageIds = CollectorUtil.collectMap(teachers, new Function<Teacher, Long>() {
            @Override
            public Long apply(Teacher teacher) {
                return teacher.getAvatar();
            }
        });

        List<Storage> storages = storageDao.getByIds(storageIds.keySet());
        Map<Long, Storage> storageMap = CollectorUtil.collectMap(storages, new Function<Storage, Long>() {
            @Override
            public Long apply(Storage storage) {
                return storage.getId();
            }
        });

        for (OrgTeacher orgTeacher : list) {
            OrgTeacherInfoDto dto = new OrgTeacherInfoDto();
            Teacher teacher = teacherMap.get(orgTeacher.getUserId());
            if (null == teacher) {
                continue;
            }
            dto.setId(orgTeacher.getId());
            dto.setMobile(orgTeacher.getMobile());
            if (teacher != null) {
                dto.setName(teacher.getRealName());
                if (teacher.getBirthday() != null) {
                    dto.setBirthday(teacher.getBirthday().getTime());
                }
            }
            dto.setClassNum(classHourMap.get(orgTeacher.getUserId()) == null ? 0
                : classHourMap.get(orgTeacher.getUserId()).getLessonCount());
            Long commentScore = scoreMap.get(orgTeacher.getUserId());
            if (commentScore == null) {
                dto.setCommentNum(0.0d);
            } else {
                dto.setCommentNum(ArithUtil.round(((double) (commentScore)) / 100, 1));
            }
            Integer count = recommendMap.get(orgTeacher.getUserId());
            if (count == null || count == 0) {
                dto.setRecommended(false);
            } else {
                dto.setRecommended(true);
            }
            dto.setCreateDate(
                orgTeacher.getSignTime() == null ? new Date().getTime() : orgTeacher.getSignTime().getTime());

            if (teacher.getAvatar() != null) {
                Storage storage = storageMap.get(teacher.getAvatar());
                if (storage != null) {
                    String avatarUrl =
                        StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
                    dto.setAvatarUrl(avatarUrl);
                }
            }
            dto.setGender(teacher.getSex());
            dto.setUserId(teacher.getUserId());
            User user = userMap.get(teacher.getUserId());
            dto.setNumber(user == null ? 0 : user.getNumber());
            dto.setRemark(teacher.getOtherInfo() == null || teacher.getOtherInfo().equals("无") ? ""
                : HtmlUtils.delHTMLTag(teacher.getOtherInfo()));
            dto.setDescr(teacher.getShortIntroduce() == null || teacher.getShortIntroduce().equals("无") ? ""
                : teacher.getShortIntroduce());
            dto.setOtherInfo(teacher.getOtherInfo() == null || teacher.getOtherInfo().equals("无") ? ""
                : HtmlUtils.delHTMLTag(teacher.getOtherInfo()));
            result.add(dto);
        }
        return result;
    }

    @Override
    public OrgTeacher getByUserId(long parseLong) {
        return orgTeacherDao.getTeachersByUserId(parseLong);
    }

    @Override
    public int getTeacherIds(long id) {
        List<Long> list = orgTeacherDao.getTeacherIds(id, OrgTeacherStatus.SIGNED.getCode());
        return list.size();
    }

    @SuppressWarnings("unchecked")
    public static void saveOrEditTeacher(OrgTeacher teacher, TeacherInfoRequest request, Long orgId) {
        Map<String, String> args = Maps.newHashMap();
        args.put("name", request.getName());
        args.put("org_id", orgId.toString());
        // args.put("mobile", request.getMobile());
        args.put("school_age", "0");// 默认不能为0
        args.put("intro", request.getRemark() == null || request.getRemark().equals("") ? "无" : request.getRemark());
        args.put("avatar_storage_id", request.getAvatar().toString());
        args.put("photo_storage_ids", PropertiesReader.getValue("erp", "teacher.male.photo.id"));// 必须有图片就来个默认的吧
        if (request.getBirthday() != null) {
            args.put("birthday", DateUtil.getStrByDate(new Date(request.getBirthday())));
        }
        args.put("gender", request.getGender().toString());
        args.put("app_id", Config.APP_ID);
        args.put("timestamp", String.valueOf(System.currentTimeMillis()));
        args.put("auth_token", getTokenFromCache());

        try {
            String controller = "org_teacher";
            String action = "create";

            if (request.getId() != null) {
                action = "update_profile";
                args.remove("mobile");
                args.put("user_id", teacher.getUserId() + "");
            }

            RestfulResult<Object> result =
                RestUtil.getInstance().rest(RestUtils.RestMethod.POST, controller, action, null, args, null);

            log.info("addOrEditBaseInfo.args:{}, ret:{}", args, result);
            if (result == null) {
                throw new BussinessException(CommonErrorCode.IO_ERROR, "调用主站接口添加老师是吧");
            }
            if (result.getCode() == 1) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, result.getMsg());
            }
            if (request.getId() == null) {
                Map<String, Integer> data = (Map<String, Integer>) result.getData();
                if (data != null) {
                    Integer userId = data.get("user_id");
                    if (userId != null) {
                        teacher.setUserId(userId.longValue());
                    }
                }
            }
        } catch (Exception e) {
            log.warn("addBaseInfo failed, e:{}", e);
            throw new BussinessException(CommonErrorCode.IO_ERROR, "老师保存失败");
        }
    }

    public static String getTokenFromCache() {
        String token = null;
        try {
            token = RestUtil.getInstance().getAuthToken();
            log.info("Get token from cached,token=" + token);
        } catch (Exception e) {
            throw new BussinessException(CommonErrorCode.TOKEN_ERROR, "获取系统Token错误");
        }
        return token;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void removeTeacher(Integer orgId, Collection<Long> teacherIds) {
        List<Long> updateOrgCourseTeacherStatus =
            updateOrgCourseTeacherStatus(orgId, teacherIds, OrgCourseTeacher.softDelWithClassRecord);
        removeTeachers(orgId, teacherIds);
        saveOrUpdateOrgTeacher(orgId.longValue(), updateOrgCourseTeacherStatus);
        log.info("has removeTeachers:{} ", teacherIds);
    }

    /**
     * @param teacherIds
     * @param status
     */
    private List<Long> updateOrgCourseTeacherStatus(Integer orgId, Collection<Long> teacherIds, Integer status) {
        if (GenericsUtils.isNullOrEmpty(teacherIds)) {
            return GenericsUtils.emptyList();
        }
        Map<Long, Boolean> hasClassRecord = filterSoftDelTeacherService.hasClassRecord(orgId, teacherIds);
        List<OrgTeacher> byIds = this.orgTeacherDao.getByIds(teacherIds, "id", "userId");
        if (GenericsUtils.isNullOrEmpty(byIds)) {
            return GenericsUtils.emptyList();
        }
        List<Long> teacherUserIds = Lists.newArrayList();
        Set<Long> needUpdateToCanSeeUserIds = Sets.newHashSet();
        for (OrgTeacher ot : byIds) {
            Long otId = ot.getId();
            Long userId = ot.getUserId();
            teacherUserIds.add(userId);
            boolean isHasClassRecord = hasClassRecord.get(otId) != null && hasClassRecord.get(otId);
            if (!isHasClassRecord) {
                needUpdateToCanSeeUserIds.add(userId);
            }
        }
        this.orgCourseTeacherDao.updateStatusWithUserIds(needUpdateToCanSeeUserIds, status);
        return teacherUserIds;
    }

    /**
     * @param orgId
     * @param teacherIds
     */
    private void removeTeachers(Integer orgId, Collection<Long> teacherIds) {
        for (Long teacherId : teacherIds) {
            OrgTeacher obj = new OrgTeacher();
            obj.setUseStatus(1);
            obj.setId(teacherId);
            obj.setOrgId(orgId.longValue());
            try {
                this.orgTeacherDao.update(obj, false);
            } catch (Exception e) {
                log.error("can not find record with :orgID:{}  and teacherId:{} ", orgId, teacherId);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reUseTeacher(int orgId, List<Long> teacherIds) {
        for (Long teacherId : teacherIds) {
            OrgTeacher obj = new OrgTeacher();
            obj.setUseStatus(0);
            obj.setId(teacherId);
            obj.setOrgId((long) orgId);
            try {
                this.orgTeacherDao.update(obj, false);
            } catch (Exception e) {
                log.error("can not find record with :orgID:{}  and teacherId:{} so can not reUseTeacher it ", orgId,
                    teacherId);
            }
        }
        List<Long> updateOrgCourseTeacherStatus =
            updateOrgCourseTeacherStatus(orgId, teacherIds, OrgCourseTeacher.normal);
        saveOrUpdateOrgTeacher((long) orgId, updateOrgCourseTeacherStatus);
        log.info("has removeTeachers:{} ", teacherIds);
    }

    @Override
    public int removeAllTeachers(int orgId, int confirm) {
        List<OrgTeacher> orgTeacherListByOrgIds =
            this.orgTeacherDao.getPausedOrgTeacherListByOrgIds(Arrays.asList((long) orgId));
        log.info("find all orgTeacherListByOrgIds are:{} ", orgTeacherListByOrgIds);
        Set<Long> teacherIds = Sets.newHashSet();
        for (OrgTeacher ot : orgTeacherListByOrgIds) {
            teacherIds.add(ot.getId());
        }
        Map<Long, Boolean> hasClassRecord = filterSoftDelTeacherService.hasClassRecord(orgId, teacherIds);
        int count = checkoutHasClassRecord(hasClassRecord);
        // 如果不存在有上课记录或者上课记录存在但确认删除的，进行删除操作
        if (count == 0 || (count != 0 && confirm == 1)) {
            List<Long> hardDelTeachers = Lists.newArrayList();
            for (OrgTeacher ot : orgTeacherListByOrgIds) {
                Long id = ot.getId();
                Boolean containsKey = hasClassRecord.get(id);
                if (containsKey != null && !containsKey) {
                    hardDelTeachers.add(ot.getUserId());
                    this.hardDelOrgTeacher(ot);
                    log.info("delete orgTeacher:{} ", ot);
                } else {
                    log.info("ot {} has class record , so will not delete it ", ot);
                }
            }
            this.saveOrUpdateOrgTeacher((long) orgId, hardDelTeachers);
        } else if (count == teacherIds.size()) {
            log.info(
                "current operator can not be do cause by all teachers has clas record whit orgId:{} and confirm:{} ",
                orgId, confirm);
            throw new BussinessException(ErpErrorCode.ALL_TEACHER_HAS_CLASS_RECORD);
        }
        log.info("[OrgTeacherServiceImpl] remove teacherIds :{} ", teacherIds);
        return count;
    }

    /**
     * @param orgId
     * @param teacherIds
     * @return
     */
    private int checkoutHasClassRecord(int orgId, Set<Long> teacherIds) {
        Map<Long, Boolean> hasClassRecord = filterSoftDelTeacherService.hasClassRecord(orgId, teacherIds);
        log.info("hasClassRecord are :{} ", hasClassRecord);
        int count = countHasRecords(hasClassRecord);
        return count;
    }

    private int checkoutHasClassRecord(Map<Long, Boolean> hasClassRecord) {
        int count = 0;
        log.info("hasClassRecord are :{} ", hasClassRecord);
        count = countHasRecords(hasClassRecord);
        return count;
    }

    /**
     * @param hasClassRecord
     * @return
     */

    private int countHasRecords(Map<Long, Boolean> hasClassRecord) {
        int count = 0;
        if (GenericsUtils.notNullAndEmpty(hasClassRecord)) {
            for (Map.Entry<Long, Boolean> entry : hasClassRecord.entrySet()) {
                if (entry.getValue()) {
                    count++;
                }
            }
        }
        return count;
    }

    @Override
    public Long getUserIdByCascadeId(Long orgId, Integer cascadeId) {
        String mobile = "";
        if (cascadeId != null && cascadeId != 0) {
            TXCascadeAccount account = cascadeAccountDao.getById(cascadeId);
            if (account == null) {
                throw new ParameterException("子账号不存在,cascadeId=" + cascadeId);
            }
            TXCascadeCredential txCascadeCredential =
                txCascadeCredentialDao.getById(account.getCredentialId(), "mobile");
            if (txCascadeCredential != null) {
                mobile = txCascadeCredential.getMobile();
            }
        } else {
            OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), "mobile");
            if (accountById != null && accountById.getIsDel() == DeleteStatus.NORMAL.getValue()) {
                mobile = accountById.getMobile();
            }
        }
        if (GenericsUtils.notNullAndEmpty(mobile)) {
            List<OrgTeacher> teacherByMobileAndOrgId =
                this.orgTeacherDao.getTeacherByMobileAndOrgId(orgId, mobile, null);
            log.info("find all orgTeachers are:{} ", teacherByMobileAndOrgId);
            if (GenericsUtils.notNullAndEmpty(teacherByMobileAndOrgId)) {
                OrgTeacher orgTeacher = teacherByMobileAndOrgId.get(0);
                log.info("find all orgTeacher is:{} ", orgTeacher);
                return orgTeacher.getUserId();
            }
        }
        log.info("Cannot find orgTeacherId:orgId={},cascadeId={} ", orgId, cascadeId);
        return null;
    }
}
